<?php
if ($tipo_reporte == 'excel') {
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=" . $filename . ".xls");
}
$tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO");
if ($tipo_reporte != 'grid') {
    $periodo = formatear_fecha('d-m-Y', $fecha_ini) . " / " . formatear_fecha('d-m-Y', $fecha_fin);
?>
    <style type="text/css">
        .tabla {
            width: 100%;
            margin-left: auto;
            margin-right: auto;
        }

        th {
            font-weight: bold !important;
        }

        td {
            font-family: arial;
        }

        .fuente_titulo {
            font-family: <?php echo $tipo_fuente; ?>;
        }
    </style>

    <?php if ($tipo_reporte == 'excel') {
    ?>
        <table>
            <thead>
                <tr>
                    <th colspan="6">Listado de ordenes de produccion por proyecto</th>
                </tr>
            </thead>
        </table>
    <?php
    }
    ?>
    <table>
        <tr>
            <td style="text-align: left;" colspan="2"><b>Período:</b></td>
            <td style="text-align: left;" colspan="2"><?php echo $periodo; ?></td>
            <td style="text-align: left;" colspan="1"><b>Cliente:</b></td>
            <td style="text-align: left;" colspan="1"><?php echo $cliente; ?></td>
        </tr>
        <tr>
            <td style="text-align: left;" colspan="2"><b>Proyecto:</b></td>
            <td style="text-align: left;" colspan="2"><?php echo $pro; ?></td>
            <td style="text-align: left;" colspan="1"><b>Estado proyecto:</b></td>
            <td style="text-align: left;" colspan="1"><?php echo $estado_nombre; ?></td>
        </tr>
    </table>
    <?php if ($tipo_reporte == 'excel') {
        echo "<br>";
    } else {
        echo "<br><br>";
    }
    ?>

    <table border="1" width="100%">
        <thead>
            <tr>
                <th width="4%">No.</th>
                <th>Fecha OP.</th>
                <th>No. OP.</th>
                <th>Cliente</th>
                <th>Proyecto</th>
                <th>Estado proyecto</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if (count($proyectos) > 0) {
                $num_pro = 1;
                foreach ($proyectos as $key) {
                    $fecha = formatear_fecha('d-m-Y', $key['ord_fecha']);
            ?>
                    <tr>
                        <td width="4%"><?php echo $num_pro++; ?></td>
                        <td><?= $fecha ?></td>
                        <td><?= $key['ord_codigo'] ?></td>
                        <td><?= $key['cliente'] ?></td>
                        <td><?= $key['proyecto'] ?></td>
                        <td><?= $key['epr_nombre'] ?></td>
                    </tr>
            <?php }
            } ?>
        </tbody>
    </table>
<?php
} else {

?>
    <!--Datos de la grid-->
    <table border="1" style="font-size:12.5px;color:black;" class="responsive table table-bordered contenedor" id="datagried" width="100%" name="datagried">
        <thead>
            <tr>
                <th>No.</th>
                <th>Fecha OP.</th>
                <th>No. OP.</th>
                <th>Cliente</th>
                <th>Proyecto</th>
                <th>Estado proyecto</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if (count($proyectos) > 0) {
                $num_pro = 1;
                foreach ($proyectos as $key) {
                    $fecha = formatear_fecha('d-m-Y', $key['ord_fecha']);
            ?>
                    <tr>
                        <td><?php echo $num_pro++; ?></td>
                        <td><?= $fecha ?></td>
                        <td><?= $key['ord_codigo'] ?></td>
                        <td><?= $key['cliente'] ?></td>
                        <td><?= $key['proyecto'] ?></td>
                        <td><?= $key['epr_nombre'] ?></td>
                    </tr>
            <?php }
            } ?>
        </tbody>
    </table>
<?php } ?>