<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
if ($tipo_reporte == 'excel') {
	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	header("content-disposition: attachment;filename=" . $filename . ".xls");
	header("Pragma: no-cache");
	header("Expires: 0");
}

if ($tipo_reporte == 'excel') { ?>
	<meta charset="utf-8" />
	<div class="head">
		<table>
			<tr>
				<td align="center" colspan="8">
					<h4>
						<?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?>
						<br>Reporte de Costo de Venta de Producto
					</h4>
				</td>
			</tr>
		</table>
	</div>
<?php } ?>
<?php if ($tipo_reporte == 'pdf' || $tipo_reporte == 'excel') : //Mostrar los filtros seleccionados
?>
	<table border="0" width="100%">
		<tr>
			<td><?php echo $fecha_inicio_t; ?></td>
			<td><?php echo $fecha_fin_t; ?></td>
			<td><?php echo $category_t; ?></td>
		</tr>
	</table>
<?php endif; ?>

<style type="text/css">
	.tabla th {
		/*border:1px solid black;*/
		vertical-align: middle;
		text-align: center;
		font: bold;
		background-color: #DCDCDC;
	}

	.money {
		text-align: right;
	}

	td {
		padding: 5% 0;
	}
</style>

<?php if ($tipo_reporte != '') { //Agregar borde si se exporta
?>
	<table class="responsive display tabla table-bordered dataTable" id="tbl_cost" name="tbl_cost" border="1" style="width:99%;text-align:left;font-size:9px;">
	<?php } else { ?>
		<table class="responsive display tabla table-bordered dataTable" id="tbl_cost" name="tbl_cost" border="0" style="width:99%;text-align:left;font-size:12px;">
		<?php } ?>
		<thead>
			<tr>
				<th width="20%">Categoría</th>
				<th width="38%">Nombre de producto</th>
				<th width="14%">Cantidad vendida</th>
				<th width="14%">Costo promedio</th>
				<th width="14%">Total</th>
			</tr>
		</thead>
		<tbody>
			<?php
			if ($rows > 0) {
				$total = 0;
				$cantidad = 0;
				$costo = array();
				foreach ($info as $key => $value) {
					$unidad 	= ($value["mep_nombre"] != '') ? ' (' . $value["mep_nombre"] . ')' : '';
					$cant_row 	= number_format($value['def_cantidad'], 2);
					$total_row 	= number_format(($value['def_cantidad'] * $value['def_precio_inventario']), 2);
			?>
					<tr>
						<td width="20%"><?php echo $value["tia_codigo"] . ' - ' . $value["tia_nombre"]; ?></td>
						<td width="38%"><?php echo $value["art_codigo"] . ' - ' . $value["art_nombre"] . $unidad; ?></td>
						<td width="14%" class="money"><?php echo $cant_row ?></td>
						<td width="14%" class="money">$ <?php echo number_format($value['def_precio_inventario'], 4); ?></td>
						<td width="14%" class="money">$ <?php echo $total_row; ?> </td>
					</tr>
				<?php
					$cantidad += $cant_row;
					$total += $total_row;
					array_push($costo, number_format($value['def_precio_inventario'], 4));
				}
			} else { ?>
				<tr>
					<td colspan="5" style="text-align: center; font-weight: bold;">NO SE ENCONTRARON REGISTROS</td>
				</tr>
			<?php } ?>
		</tbody>
		<?php if ($rows > 0) {
			$costo_prom = array_sum($costo) / $rows;
		?>
			<tfoot>
				<tr style="border-top: solid 1px silver;">
					<td colspan="2" style="text-align: right;"><b>TOTAL GENERAL</b></td>
					<td class="money"><b><?php echo number_format($cantidad, 2); ?></b></td>
					<td class="money"><b> <?php echo $simbolo . number_format($costo_prom, 4); ?></b></td>
					<td class="money"><b> <?php echo $simbolo . number_format($total, 2); ?></b></td>
				</tr>
			</tfoot>
		<?php } ?>

		</table>