<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
$ver_costos = ($mostrar_costo > 0) ? true : false;
$dec = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
$costos_final_real = $costos_final_receta = 0;

if ($tipo_reporte == 'excel') {
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=" . $filename . ".xls");
}

if ($tipo_reporte == 'excel') {
?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="6">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Consumo de Materia Prima por Orden de Producción
                    </h4>
                </td>
            </tr>
        </table>
    </div>
    <br>
    <?php
}

if (count($orden) > 0) {
    if (count($total_axos) && (count($materias) > 0 || count($mano_obra) > 0 || count($gastos_indirectos) > 0)) {
        for ($i = 0; $i < count($total_axos); $i++) {
            if ($orden[$i]['cli_personeria'] == 2) {
                $Cliente = $orden[$i]['cli_apellido'];
            } elseif ($orden[$i]['cli_personeria'] == 1) {
                $Cliente = $orden[$i]['cli_nombre'] . ' ' . $orden[$i]['cli_apellido'];
            } else {
                $Cliente = '---';
            }
            $this->db->join('cva_conversion_articulo', 'mep_id = cva_id_mep');
            $mep_axos = $this->gsatelite->get_campo('mep_medida_producto', 'mep_nombre', array('cva_id' => $orden[$i]['axo_id_cva']));
    ?>
            <table border="0" width="100%" class="table" style="font-size: <?= ($tipo_reporte != "") ? '10pt' : '15px'; ?>;">
                <tr nobr="true">
                    <td width="10%"><b>Artículo: </b></td>
                    <td width="42%"><?php echo $orden[$i]['art_codigo'] . ' - ' . $orden[$i]['art_nombre']; ?></td>
                    <td width="8%"></td>
                    <td width="22%"><b>Cantidad a Producir:</b></td>
                    <td width="18%"><?php echo number_format($orden[$i]['axo_cantidad'], $dec); ?></td>
                </tr>
                <tr nobr="true">
                    <td><b>Cliente: </b></td>
                    <td><?php echo $Cliente; ?></td>
                    <td></td>
                    <td><b>Unidad a Producir:</b></td>
                    <td><?php echo $mep_axos; ?></td>
                </tr>
            </table>
            <!-- MATERIA PRIMA -->
            <table border="1" width="100%" class="table table-bordered" <?= ($tipo_reporte != "") ? 'style="font-size: 8pt;"' : 'style="font-size: 15px;"'; ?>>
                <thead>
                    <tr>
                        <th rowspan="2" style="text-align: center; vertical-align: middle;"><b>Materia Prima</b></th>
                        <th colspan="<?php echo ($ver_costos) ? 4 : 2; ?>" style="text-align: center;"><b>Según Costeo</b></th>
                        <th colspan="<?php echo ($ver_costos) ? 4 : 2; ?>" style="text-align: center;"><b>Según Receta</b></th>
                        <th rowspan="2" style="text-align: center; vertical-align: middle;"><b>Diferencia (Cantidad)</b></th>
                        <?php
                        if ($ver_costos) {
                        ?>
                            <th rowspan="2" style="text-align: center; vertical-align: middle;"><b>Diferencia (Monto <?= $simbolo ?>)</b></th>
                        <?php
                        }
                        ?>
                    </tr>
                    <tr>
                        <th style="text-align: center;"><b>Cantidad Despachada</b></th>
                        <th style="text-align: center;"><b>Medida Despachada</b></th>
                        <?php
                        if ($ver_costos) {
                        ?>
                            <th style="text-align: center;"><b>Costo Unidad</b></th>
                            <th style="text-align: center;"><b>Costo Total</b></th>
                        <?php
                        }
                        ?>
                        <th style="text-align: center;"><b>Cantidad a Solicitar</b></th>
                        <th style="text-align: center;"><b>Medida a Solicitar</b></th>
                        <?php
                        if ($ver_costos) {
                        ?>
                            <th style="text-align: center;"><b>Costo Unidad</b></th>
                            <th style="text-align: center;"><b>Costo Total</b></th>
                        <?php
                        }
                        ?>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if (count($materias) > 0) {
                        $ctdad_usado_mpa = $ctdad_receta_mpa = $costo_usado_mpa = $costo_receta_mpa = $costo_diferencia_mpa = $diferencia_ctdad_mpa = 0;
                        foreach ($materias as $key => $value) {
                            $costo_total_usado_mpa = $costo_total_receta_mpa = 0;
                            if ($value['axo'] == $total_axos[$i]) {
                                if ($value['es_nueva'] == 0) {
                                    if ($value['se_uso'] > 0) {
                                        $costo_total_usado_mpa = number_format($value['costo_uni'], $dec, '.', '') * $value['uni_usada'];
                                        $costo_total_receta_mpa = number_format($value['costo_uni'], $dec, '.', '') * $value['uni_estim'];
                                        $diferencia_costo_mpa = $costo_total_usado_mpa - $costo_total_receta_mpa;
                                        $dif_ctdad_mpa = $value['uni_usada'] - $value['uni_estim'];
                                        $costo_usado_mpa += $costo_total_usado_mpa;
                                        $costo_receta_mpa += $costo_total_receta_mpa;
                                        $ctdad_usado_mpa += $value['uni_usada'];
                                        $ctdad_receta_mpa += $value['uni_estim'];
                                        $costo_diferencia_mpa += $diferencia_costo_mpa;
                                        $diferencia_ctdad_mpa += $dif_ctdad_mpa;
                    ?>
                                        <tr nobr="true">
                                            <td><?php echo $value['nombre']; ?></td>
                                            <td style="text-align: right;"><?php echo number_format($value['uni_usada'], $dec); ?></td>
                                            <td><?php echo $value['medida']; ?></td>
                                            <?php
                                            if ($ver_costos) {
                                            ?>
                                                <td style="text-align: right;"><?php echo $simbolo . number_format($value['costo_uni'], 2); ?></td>
                                                <td style="text-align: right;"><?php echo $simbolo . number_format($costo_total_usado_mpa, 2); ?></td>
                                            <?php
                                            }
                                            ?>
                                            <td style="text-align: right;"><?php echo number_format($value['uni_estim'], $dec); ?></td>
                                            <td><?php echo $value['medida']; ?></td>
                                            <?php
                                            if ($ver_costos) {
                                            ?>
                                                <td style="text-align: right;"><?php echo $simbolo . number_format($value['costo_uni'], 2); ?></td>
                                                <td style="text-align: right;"><?php echo $simbolo . number_format($costo_total_receta_mpa, 2); ?></td>
                                            <?php
                                            }
                                            ?>
                                            <td style="text-align: right;"><?php echo number_format($dif_ctdad_mpa, $dec); ?></td>
                                            <?php
                                            if ($ver_costos) {
                                            ?>
                                                <td style="text-align: right;"><?php echo $simbolo . number_format($diferencia_costo_mpa, 2); ?></td>
                                            <?php
                                            }
                                            ?>
                                        </tr>
                                    <?php
                                    }
                                } else {
                                    $costo_total_usado_mpa = number_format($value['costo_uni'], $dec, '.', '') * $value['uni_usada'];
                                    $costo_total_receta_mpa = 0;
                                    $diferencia_costo_mpa = $costo_total_usado_mpa - $costo_total_receta_mpa;
                                    $dif_ctdad_mpa = $value['uni_usada'];
                                    $ctdad_usado_mpa += $value['uni_usada'];
                                    $ctdad_receta_mpa += 0;
                                    $costo_usado_mpa += $costo_total_usado_mpa;
                                    $costo_receta_mpa += $costo_total_receta_mpa;
                                    $costo_diferencia_mpa += $diferencia_costo_mpa;
                                    $diferencia_ctdad_mpa += $dif_ctdad_mpa;
                                    ?>
                                    <tr nobr="true">
                                        <td><?php echo $value['nombre']; ?></td>
                                        <td style="text-align: right;"><?php echo number_format($value['uni_usada'], $dec); ?></td>
                                        <td><?php echo $value['medida']; ?></td>
                                        <?php
                                        if ($ver_costos) {
                                        ?>
                                            <td style="text-align: right;"><?php echo $simbolo . number_format($value['costo_uni'], 2); ?></td>
                                            <td style="text-align: right;"><?php echo $simbolo . number_format($costo_total_usado_mpa, 2); ?></td>
                                        <?php
                                        }
                                        ?>
                                        <td style="text-align: center;"><?php echo '---'; ?></td>
                                        <td style="text-align: center;"><?php echo '---'; ?></td>
                                        <?php
                                        if ($ver_costos) {
                                        ?>
                                            <td style="text-align: center;"><?php echo '---'; ?></td>
                                            <td style="text-align: center;"><?php echo '---'; ?></td>
                                        <?php
                                        }
                                        ?>
                                        <td style="text-align: right;"><?php echo number_format($dif_ctdad_mpa, $dec); ?></td>
                                        <?php
                                        if ($ver_costos) {
                                        ?>
                                            <td style="text-align: right;"><?php echo $simbolo . number_format($diferencia_costo_mpa, 2); ?></td>
                                        <?php
                                        }
                                        ?>
                                    </tr>
                        <?php
                                }
                            }
                        }
                        $costos_final_real += $costo_usado_mpa;
                        $costos_final_receta += $costo_receta_mpa;
                        ?>
                        <tr>
                            <th style="text-align: right;"><b>Total Materia Prima</b></th>
                            <th style="text-align: right;"><b><?php echo number_format($ctdad_usado_mpa, $dec); ?></b></th>
                            <th colspan="<?php echo ($ver_costos) ? 2 : 1; ?>"></th>
                            <?php
                            if ($ver_costos) {
                            ?>
                                <th style="text-align: right;"><?php echo $simbolo . number_format($costo_usado_mpa, 2); ?></th>
                            <?php
                            }
                            ?>
                            <th style="text-align: right;"><b><?php echo number_format($ctdad_receta_mpa, $dec); ?></b></th>
                            <th colspan="<?php echo ($ver_costos) ? 2 : 1; ?>"></th>
                            <?php
                            if ($ver_costos) {
                            ?>
                                <th style="text-align: right;"><?php echo $simbolo . number_format($costo_receta_mpa, 2); ?></th>
                            <?php
                            }
                            ?>
                            <th style="text-align: right;"><?php echo number_format($diferencia_ctdad_mpa, $dec); ?></th>
                            <?php
                            if ($ver_costos) {
                            ?>
                                <th style="text-align: right;"><?php echo $simbolo . number_format($costo_diferencia_mpa, 2); ?></th>
                            <?php
                            }
                            ?>
                        </tr>
                    <?php
                    } else {
                    ?>
                        <tr>
                            <td colspan="<?php echo ($ver_costos) ? 11 : 6; ?>" style="text-align: center;"><b>No se encontró información sobre materia prima para esta orden</b></td>
                        </tr>
                    <?php
                    }
                    ?>
                </tbody>
            </table>
            <div><?php echo ($tipo_reporte == "excel") ? "<br>" : ""; ?></div>
            <!-- MANO DE OBRA -->
            <table border="1" width="100%" class="table table-bordered" <?= ($tipo_reporte != "") ? 'style="font-size: 8pt;"' : 'style="font-size: 15px;"'; ?>>
                <thead>
                    <tr>
                        <th rowspan="2" style="text-align: center; vertical-align: middle;"><b>Mano de Obra</b></th>
                        <th colspan="<?php echo ($ver_costos) ? 3 : 1; ?>" style="text-align: center;"><b>Según Costeo</b></th>
                        <th colspan="<?php echo ($ver_costos) ? 3 : 1; ?>" style="text-align: center;"><b>Según Receta</b></th>
                        <th rowspan="2" style="text-align: center; vertical-align: middle;"><b>Diferencia (Cantidad)</b></th>
                        <?php
                        if ($ver_costos) {
                        ?>
                            <th rowspan="2" style="text-align: center; vertical-align: middle;"><b>Diferencia (Monto <?= $simbolo ?>)</b></th>
                        <?php
                        }
                        ?>
                    </tr>
                    <tr>
                        <th style="text-align: center;"><b>Cantidad Utilizada</b></th>
                        <?php
                        if ($ver_costos) {
                        ?>
                            <th style="text-align: center;"><b>Costo Unidad</b></th>
                            <th style="text-align: center;"><b>Costo Total</b></th>
                        <?php
                        }
                        ?>
                        <th style="text-align: center;"><b>Cantidad a Solicitar</b></th>
                        <?php
                        if ($ver_costos) {
                        ?>
                            <th style="text-align: center;"><b>Costo Unidad</b></th>
                            <th style="text-align: center;"><b>Costo Total</b></th>
                        <?php
                        }
                        ?>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if (count($mano_obra) > 0) {
                        $ctdad_usado_mob = $ctdad_receta_mob = $costo_usado_mob = $costo_receta_mob = $costo_diferencia_mob = $diferencia_ctdad_mob = 0;
                        foreach ($mano_obra as $key => $value) {
                            $costo_total_usado_mob = $costo_total_receta_mob = 0;
                            if ($value['axo'] == $total_axos[$i]) {
                                if ($value['es_nueva'] == 0) {
                                    if ($value['se_uso'] > 0) {
                                        $costo_total_usado_mob = number_format($value['costo_uni'], $dec, '.', '') * $value['uni_usada'];
                                        $costo_total_receta_mob = number_format($value['costo_uni'], $dec, '.', '') * $value['uni_estim'];
                                        $diferencia_costo_mob = $costo_total_usado_mob - $costo_total_receta_mob;
                                        $dif_ctdad_mob = $value['uni_usada'] - $value['uni_estim'];
                                        $costo_usado_mob += $costo_total_usado_mob;
                                        $costo_receta_mob += $costo_total_receta_mob;
                                        $ctdad_usado_mob += $value['uni_usada'];
                                        $ctdad_receta_mob += $value['uni_estim'];
                                        $costo_diferencia_mob += $diferencia_costo_mob;
                                        $diferencia_ctdad_mob += $dif_ctdad_mob;
                    ?>
                                        <tr nobr="true">
                                            <td><?php echo ($value['responsable'] != "") ? $value['nombre'] . ' ( ' . $value['responsable'] . ')' : $value['nombre']; ?></td>
                                            <td style="text-align: right;"><?php echo number_format($value['uni_usada'], $dec); ?></td>
                                            <?php
                                            if ($ver_costos) {
                                            ?>
                                                <td style="text-align: right;"><?php echo $simbolo . number_format($value['costo_uni'], 2); ?></td>
                                                <td style="text-align: right;"><?php echo $simbolo . number_format($costo_total_usado_mob, 2); ?></td>
                                            <?php
                                            }
                                            ?>
                                            <td style="text-align: right;"><?php echo number_format($value['uni_estim'], $dec); ?></td>
                                            <?php
                                            if ($ver_costos) {
                                            ?>
                                                <td style="text-align: right;"><?php echo $simbolo . number_format($value['costo_uni'], 2); ?></td>
                                                <td style="text-align: right;"><?php echo $simbolo . number_format($costo_total_receta_mob, 2); ?></td>
                                            <?php
                                            }
                                            ?>
                                            <td style="text-align: right;"><?php echo number_format($dif_ctdad_mob, $dec); ?></td>
                                            <?php
                                            if ($ver_costos) {
                                            ?>

                                                <td style="text-align: right;"><?php echo $simbolo . number_format($diferencia_costo_mob, 2); ?></td>
                                            <?php
                                            }
                                            ?>
                                        </tr>
                                    <?php
                                    }
                                } else {
                                    $costo_total_usado_mob = number_format($value['costo_uni'], $dec, '.', '') * $value['uni_usada'];
                                    $costo_total_receta_mob = 0;
                                    $diferencia_costo_mob = $costo_total_usado_mob - $costo_total_receta_mob;
                                    $dif_ctdad_mob = $value['uni_usada'];
                                    $ctdad_usado_mob += $value['uni_usada'];
                                    $ctdad_receta_mob += 0;
                                    $costo_usado_mob += $costo_total_usado_mob;
                                    $costo_receta_mob += $costo_total_receta_mob;
                                    $costo_diferencia_mob += $diferencia_costo_mob;
                                    $diferencia_ctdad_mob += $dif_ctdad_mob;
                                    ?>
                                    <tr nobr="true">
                                        <td><?php echo ($value['responsable'] != "") ? $value['nombre'] . ' ( ' . $value['responsable'] . ')' : $value['nombre']; ?></td>
                                        <td style="text-align: right;"><?php echo number_format($value['uni_usada'], $dec); ?></td>
                                        <?php
                                        if ($ver_costos) {
                                        ?>
                                            <td style="text-align: right;"><?php echo $simbolo . number_format($value['costo_uni'], 2); ?></td>
                                            <td style="text-align: right;"><?php echo $simbolo . number_format($costo_total_usado_mob, 2); ?></td>
                                        <?php
                                        }
                                        ?>
                                        <td style="text-align: center;"><?php echo '---'; ?></td>
                                        <?php
                                        if ($ver_costos) {
                                        ?>
                                            <td style="text-align: center;"><?php echo '---'; ?></td>
                                            <td style="text-align: center;"><?php echo '---'; ?></td>
                                        <?php
                                        }
                                        ?>
                                        <td style="text-align: right;"><?php echo number_format($dif_ctdad_mob, $dec); ?></td>
                                        <?php
                                        if ($ver_costos) {
                                        ?>
                                            <td style="text-align: right;"><?php echo $simbolo . number_format($diferencia_costo_mob, 2); ?></td>
                                        <?php
                                        }
                                        ?>
                                    </tr>
                        <?php
                                }
                            }
                        }
                        $costos_final_real += $costo_usado_mob;
                        $costos_final_receta += $costo_receta_mob;
                        ?>
                        <tr>
                            <th style="text-align: right;"><b>Total Mano de Obra</b></th>
                            <th style="text-align: right;"><b><?php echo number_format($ctdad_usado_mob, $dec); ?></b></th>
                            <?php
                            if ($ver_costos) {
                            ?>
                                <th></th>
                                <th style="text-align: right;"><?php echo $simbolo . number_format($costo_usado_mob, 2); ?></th>
                            <?php
                            }
                            ?>
                            <th style="text-align: right;"><b><?php echo number_format($ctdad_receta_mob, $dec); ?></b></th>
                            <?php
                            if ($ver_costos) {
                            ?>
                                <th></th>
                                <th style="text-align: right;"><?php echo $simbolo . number_format($costo_receta_mob, 2); ?></th>
                            <?php
                            }
                            ?>
                            <th style="text-align: right;"><?php echo number_format($diferencia_ctdad_mob, $dec); ?></th>
                            <?php
                            if ($ver_costos) {
                            ?>
                                <th style="text-align: right;"><?php echo $simbolo . number_format($costo_diferencia_mob, 2); ?></th>
                            <?php
                            }
                            ?>
                        </tr>
                    <?php
                    } else {
                    ?>
                        <tr>
                            <td colspan="<?php echo ($ver_costos) ? 9 : 5; ?>" style="text-align: center;"><b>No se encontró información sobre mano de obra para esta orden</b></td>
                        </tr>
                    <?php
                    }
                    ?>
                </tbody>
            </table>
            <div><?php echo ($tipo_reporte == "excel") ? "<br>" : ""; ?></div>
            <table border="1" width="100%" class="table table-bordered" <?= ($tipo_reporte != "") ? 'style="font-size: 8pt;"' : 'style="font-size: 15px;"'; ?>>
                <thead>
                    <tr>
                        <th rowspan="2" style="text-align: center; vertical-align: middle;"><b>Gastos Indirectos de Fab.</b></th>
                        <th colspan="<?php echo ($ver_costos) ? 3 : 1; ?>" style="text-align: center;"><b>Según Costeo</b></th>
                        <th colspan="<?php echo ($ver_costos) ? 3 : 1; ?>" style="text-align: center;"><b>Según Receta</b></th>
                        <th rowspan="2" style="text-align: center; vertical-align: middle;"><b>Diferencia (Cantidad)</b></th>
                        <?php
                        if ($ver_costos) {
                        ?>
                            <th rowspan="2" style="text-align: center; vertical-align: middle;"><b>Diferencia (Monto <?= $simbolo ?>)</b></th>
                        <?php
                        }
                        ?>
                    </tr>
                    <tr>
                        <th style="text-align: center;"><b>Cantidad Utilizada</b></th>
                        <?php
                        if ($ver_costos) {
                        ?>
                            <th style="text-align: center;"><b>Costo Unidad</b></th>
                            <th style="text-align: center;"><b>Costo Total</b></th>
                        <?php
                        }
                        ?>
                        <th style="text-align: center;"><b>Cantidad a Solicitar</b></th>
                        <?php
                        if ($ver_costos) {
                        ?>
                            <th style="text-align: center;"><b>Costo Unidad</b></th>
                            <th style="text-align: center;"><b>Costo Total</b></th>
                        <?php
                        }
                        ?>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if (count($gastos_indirectos) > 0) {
                        $ctdad_usado_gif = $ctdad_receta_gif = $costo_usado_gif = $costo_receta_gif = $costo_diferencia_gif = $diferencia_ctdad_gif = 0;
                        foreach ($gastos_indirectos as $key => $value) {
                            $costo_total_usado_gif = $costo_total_receta_gif = 0;
                            if ($value['axo'] == $total_axos[$i]) {
                                if ($value['es_nueva'] == 0) {
                                    if ($value['se_uso'] > 0) {
                                        $monto_calculado = ($value['monto_calculo'] != "") ? $value['monto_calculo'] : ($value['precio'] * $value['uni_usada']);
                                        $precio = number_format($value['precio'], 2, '.', '');
                                        $costo_total_usado_gif = number_format($monto_calculado, $dec, '.', '');
                                        $costo_total_receta_gif = 0;
                                        if ($value['tipo'] > 0) {
                                            $costo_total_receta_gif = number_format($precio, $dec, '.', '') * $value['uni_estim'];
                                        } else {
                                            if (count($estimacion_mat) > 0) {
                                                foreach ($estimacion_mat as $k => $vmp) {
                                                    if (isset($vmp['receta']) && $vmp['receta'] > 0) {
                                                        $costo_total_receta_gif += ($vmp['monto'] * ($precio / 100));
                                                    }
                                                }
                                            }
                                            if (count($estimacion_mob) > 0) {
                                                foreach ($estimacion_mob as $k2 => $vmo) {
                                                    if (isset($vmo['receta']) && $vmo['receta'] > 0) {
                                                        $costo_total_receta_gif += ($vmo['monto'] * ($precio / 100));
                                                    }
                                                }
                                            }
                                        }
                                        $diferencia_costo_gif = $costo_total_usado_gif - $costo_total_receta_gif;
                                        $dif_ctdad_gif = $value['uni_usada'] - $value['uni_estim'];
                                        $ctdad_usado_gif += $value['uni_usada'];
                                        $ctdad_receta_gif += $value['uni_estim'];
                                        $costo_usado_gif += $costo_total_usado_gif;
                                        $costo_receta_gif += $costo_total_receta_gif;
                                        $costo_diferencia_gif += $diferencia_costo_gif;
                                        $diferencia_ctdad_gif += $dif_ctdad_gif;
                    ?>
                                        <tr nobr="true">
                                            <td><?php echo $value['nombre']; ?></td>
                                            <td style="text-align: right;"><?php echo number_format($value['uni_usada'], $dec); ?></td>
                                            <?php
                                            if ($ver_costos) {
                                            ?>
                                                <td style="text-align: right;"><?php echo ($value['tipo'] > 0) ? $simbolo . number_format($precio, 2) : $precio . ' %'; ?></td>
                                                <td style="text-align: right;"><?php echo $simbolo . number_format($costo_total_usado_gif, 2); ?></td>
                                            <?php
                                            }
                                            ?>
                                            <td style="text-align: right;"><?php echo number_format($value['uni_estim'], $dec); ?></td>
                                            <?php
                                            if ($ver_costos) {
                                            ?>
                                                <td style="text-align: right;"><?php echo ($value['tipo'] > 0) ? $simbolo . number_format($precio, 2) : $precio . ' %'; ?></td>
                                                <td style="text-align: right;"><?php echo $simbolo . number_format($costo_total_receta_gif, 2); ?></td>
                                            <?php
                                            }
                                            ?>
                                            <td style="text-align: right;"><?php echo number_format($diferencia_ctdad_gif, $dec); ?></td>
                                            <?php
                                            if ($ver_costos) {
                                            ?>

                                                <td style="text-align: right;"><?php echo $simbolo . number_format($costo_diferencia_gif, 2); ?></td>
                                            <?php
                                            }
                                            ?>
                                        </tr>
                                    <?php
                                    }
                                } else {
                                    $monto_calculado = ($value['monto_calculo'] != "") ? $value['monto_calculo'] : ($value['precio'] * $value['uni_usada']);
                                    $precio = number_format($value['precio'], 2, '.', '');
                                    $costo_total_usado_gif = number_format($monto_calculado, $dec, '.', '');
                                    $costo_total_receta_gif = 0;
                                    $diferencia_costo_gif = $costo_total_usado_gif - $costo_total_receta_gif;
                                    $dif_ctdad_gif = $value['uni_usada'];
                                    $ctdad_usado_gif += $value['uni_usada'];
                                    $ctdad_receta_gif += 0;
                                    $costo_usado_gif += $costo_total_usado_gif;
                                    $costo_receta_gif += $costo_total_receta_gif;
                                    $costo_diferencia_gif += $diferencia_costo_gif;
                                    $diferencia_ctdad_gif += $dif_ctdad_gif;
                                    ?>
                                    <tr nobr="true">
                                        <td><?php echo $value['nombre']; ?></td>
                                        <td style="text-align: right;"><?php echo number_format($value['uni_usada'], $dec); ?></td>
                                        <?php
                                        if ($ver_costos) {
                                        ?>
                                            <td style="text-align: right;"><?php echo ($value['tipo'] > 0) ? $simbolo . number_format($precio, 2) : $precio . ' %'; ?></td>
                                            <td style="text-align: right;"><?php echo $simbolo . number_format($costo_total_usado_gif, 2); ?></td>
                                        <?php
                                        }
                                        ?>
                                        <td style="text-align: center;"><?php echo '---'; ?></td>
                                        <?php
                                        if ($ver_costos) {
                                        ?>
                                            <td style="text-align: center;"><?php echo '---'; ?></td>
                                            <td style="text-align: center;"><?php echo '---'; ?></td>
                                        <?php
                                        }
                                        ?>
                                        <td style="text-align: right;"><?php echo number_format($dif_ctdad_gif, $dec); ?></td>
                                        <?php
                                        if ($ver_costos) {
                                        ?>
                                            <td style="text-align: right;"><?php echo $simbolo . number_format($diferencia_costo_gif, 2); ?></td>
                                        <?php
                                        }
                                        ?>
                                    </tr>
                        <?php
                                }
                            }
                        }
                        $costos_final_real += $costo_usado_gif;
                        $costos_final_receta += $costo_receta_gif;
                        ?>
                        <tr>
                            <th style="text-align: right;"><b>Total Gastos Indirectos</b></th>
                            <th style="text-align: right;"><b><?php echo number_format($ctdad_usado_gif, $dec); ?></b></th>
                            <?php
                            if ($ver_costos) {
                            ?>
                                <th></th>
                                <th style="text-align: right;"><?php echo $simbolo . number_format($costo_usado_gif, 2); ?></th>
                            <?php
                            }
                            ?>
                            <th style="text-align: right;"><b><?php echo number_format($ctdad_receta_gif, $dec); ?></b></th>
                            <?php
                            if ($ver_costos) {
                            ?>
                                <th></th>
                                <th style="text-align: right;"><?php echo $simbolo . number_format($costo_receta_gif, 2); ?></th>
                            <?php
                            }
                            ?>
                            <th style="text-align: right;"><?php echo number_format($diferencia_ctdad_gif, $dec); ?></th>
                            <?php
                            if ($ver_costos) {
                            ?>
                                <th style="text-align: right;"><?php echo $simbolo . number_format($costo_diferencia_gif, 2); ?></th>
                            <?php
                            }
                            ?>
                        </tr>
                    <?php
                    } else {
                    ?>
                        <tr>
                            <td colspan="<?php echo ($ver_costos) ? 9 : 5; ?>" style="text-align: center;"><b>No se encontró información sobre gastos indirectos de fabricación para esta orden</b></td>
                        </tr>
                    <?php
                    }
                    ?>
                </tbody>
            </table>
            <?php
            if ($mostrar_costo) {
            ?>
                <div><?php echo ($tipo_reporte == "excel") ? "<br>" : ""; ?></div>
                <table border="0" width="100%" class="table" style="font-size: <?= ($tipo_reporte != "") ? '9pt' : '15px'; ?>;">
                    <tr style="text-align: right;">
                        <th width="20%" style="border-top: solid black;"><b>Total según Costeo</b></th>
                        <th width="14%" style="border-top: solid black;"><?php echo $simbolo . number_format($costos_final_real, 2); ?></th>
                        <th width="1%" style="border-top: solid black;"></th>
                        <th width="20%" style="border-top: solid black;"><b>Total según Receta</b></th>
                        <th width="14%" style="border-top: solid black;"><?php echo $simbolo . number_format($costos_final_receta, 2); ?></th>
                        <th width="1%" style="border-top: solid black;"></th>
                        <th width="16%" style="border-top: solid black;"><b>Diferencia</b></th>
                        <th width="14%" style="border-top: solid black;"><?php echo $simbolo . number_format(($costos_final_real - $costos_final_receta), 2); ?></th>
                    </tr>
                </table>
        <?php
            }
        }
    } else { //No hay costeo
        ?>
        <table class="table-bordered table" width="100%">
            <tr>
                <td style="text-align: center;"><b>No se ha realizado la estimación de costos para esta orden</b></td>
            </tr>
        </table>
<?php
    }
}
?>