<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

$decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
if ($tipo_reporte == 'excel') {
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=" . $filename . ".xls");
}

if ($tipo_reporte != '') {
    if ($tipo_reporte == 'excel') {
?>
        <meta charset="utf-8" />
        <div class="head">
            <table>
                <tr>
                    <td align="center" colspan="6">
                        <h4>
                            <?php
                            echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                            ?> <br />
                            Reporte de Producción Valorizada
                        </h4>
                    </td>
                </tr>
            </table>
        </div>
    <?php
    }
    ?>
    <div><b><?php echo $periodo ?></b></div>
    <table border="1" width="100%">
        <thead>
            <tr style="text-align: center;">
                <th width="19%"><b>Categoría</b></th>
                <th width="25%"><b>Producto</b></th>
                <th width="14%"><b>Unidad Medida</b></th>
                <th width="14%"><b>Suma Cantidades</b></th>
                <th width="12%"><b>Costo Unit. Prom.</b></th>
                <th width="16%"><b>Suma Valores</b></th>
            </tr>
        </thead>
        </thead>
        <tbody>
            <?php
        }

        if (count($detalles) > 0) {
            $tia_inicial = $detalles[0]['tia_id'];
            $tia_nombre = $detalles[0]['tia_nombre'];
            $cantidad_total_general = $monto_total_general = 0;
            $cantidad_total_tia = $monto_total_tia = 0;
            $mostrar_tia = true;
            foreach ($detalles as $key => $value) {
                if ($value['tia_id'] == $tia_inicial) {
                    $cantidad_total_tia += number_format($value['cantidad'], $decimales, '.', '');
                    $total = number_format($value['costo_unitario'], 2, '.', '') * number_format($value['cantidad'], $decimales, '.', '');
                    $monto_total_tia += $total;
            ?>
                    <tr nobr="true">
                        <td width="19%"><?php
                                        if ($mostrar_tia) {
                                            echo $value['tia_codigo'] . ' - ' . $value['tia_nombre'];
                                            $mostrar_tia = false;
                                        } ?>
                        </td>
                        <td width="25%"><?php echo $value['art_codigo'] . ' - ' . $value['art_nombre']; ?></td>
                        <td width="14%"><?php echo $value['medida']; ?></td>
                        <td style="text-align: right;" width="14%"><?php echo number_format($value['cantidad'], $decimales); ?></td>
                        <td style="text-align: right;" width="12%"><?php echo $simbolo . number_format($value['costo_unitario'], 2); ?></td>
                        <td style="text-align: right;" width="16%"><?php echo $simbolo . number_format($total, 2); ?></td>
                    </tr>
                <?php
                } else {
                    $cantidad_total_general += number_format($cantidad_total_tia, $decimales, '.', '');
                    $monto_total_general += number_format($monto_total_tia, 2, '.', '');
                ?>
                    <tr>
                        <td><b>Total <?php echo $tia_nombre; ?></b></td>
                        <td colspan="2"></td>
                        <td style="text-align: right;"><?php echo number_format($cantidad_total_tia, $decimales); ?></td>
                        <td></td>
                        <td style="text-align: right;"><?php echo $simbolo . number_format($monto_total_tia, 2); ?></td>
                    </tr>
                    <tr>
                        <td colspan="6"></td>
                    </tr>
                    <?php
                    $mostrar_tia = true;
                    $cantidad_total_tia = $monto_total_tia = 0;
                    $tia_inicial = $value['tia_id'];
                    $tia_nombre = $value['tia_nombre'];
                    $cantidad_total_tia += number_format($value['cantidad'], $decimales, '.', '');
                    $total = number_format($value['costo_unitario'], 2, '.', '') * number_format($value['cantidad'], $decimales, '.', '');
                    $monto_total_tia += $total;
                    ?>
                    <tr nobr="true">
                        <td width="19%"><?php
                                        if ($mostrar_tia) {
                                            echo $value['tia_codigo'] . ' - ' . $value['tia_nombre'];
                                            $mostrar_tia = false;
                                        } ?>
                        </td>
                        <td width="25%"><?php echo $value['art_codigo'] . ' - ' . $value['art_nombre']; ?></td>
                        <td width="14%"><?php echo $value['medida']; ?></td>
                        <td style="text-align: right;" width="14%"><?php echo number_format($value['cantidad'], $decimales); ?></td>
                        <td style="text-align: right;" width="12%"> <?php echo $simbolo . number_format($value['costo_unitario'], 2); ?></td>
                        <td style="text-align: right;" width="16%"> <?php echo $simbolo . number_format($total, 2); ?></td>
                    </tr>
            <?php
                }
            }
            $cantidad_total_general += number_format($cantidad_total_tia, $decimales, '.', '');
            $monto_total_general += number_format($monto_total_tia, 2, '.', '');
            ?>
            <tr>
                <td><b>Total <?php echo $tia_nombre; ?></b></td>
                <td colspan="2"></td>
                <td style="text-align: right;"><?php echo number_format($cantidad_total_tia, $decimales); ?></td>
                <td></td>
                <td style="text-align: right;"><?php echo $simbolo . number_format($monto_total_tia, 2); ?></td>
            </tr>
            <tr>
                <td colspan="6"></td>
            </tr>
            <tr>
                <td style="text-align: right;" colspan="3"><b>Total General</b></td>
                <td style="text-align: right;"><?php echo number_format($cantidad_total_general, $decimales) ?></td>
                <td></td>
                <td style="text-align: right;"><?php echo $simbolo . number_format($monto_total_general, 2) ?></td>
            </tr>
        <?php
        } else {
        ?>
            <tr>
                <td colspan="6" style="text-align: center;">
                    <h4>No se encontraron registros</h4>
                </td>
            </tr>
        <?php
        }

        if ($tipo_reporte != '') {
        ?>
        </tbody>
    </table>
<?php
        }
?>