<?php
$tr_null = "<tr><td span='11'>No hay datos que mostrar</td></tr>";
if (count($productos) > 0) {
	for ($i = 0; $i < count($productos); $i++) {
		$articuloxorden = $this->gsatelite->get_tabla('axo_articuloxorden', array('axo_id_art' => $productos[$i]['art_id'], 'axo_id_ord' => $productos[$i]['ord_id']));
		if (count($articuloxorden) > 0) {
			for ($k = 0; $k < count($articuloxorden); $k++) {
				$data_materia_prima = $this->proyecto_model->get_materia_prima_presupuesto(array('axm_id_axo' => $articuloxorden[$k]['axo_id']));
				$data_mano_obra = $this->proyecto_model->get_mano_obra_presupuesto(array('mxo_id_axo' => $articuloxorden[$k]['axo_id']));
				$data_gastos_indirectos = $this->proyecto_model->get_gastos_indirectos_presupuesto(array('exr_id_axo' => $articuloxorden[$k]['axo_id']));

				$orden = $this->gsatelite->get_tabla('ord_orden', array('ord_id' => $articuloxorden[$k]['axo_id_ord']));
				$cliente = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $orden[0]['ord_id_cli']));
				$nombre_cliente = ($cliente[0]['cli_personeria'] > 1) ? $cliente[0]['cli_apellido'] : $cliente[0]['cli_nombre'] . ' ' . $cliente[0]['cli_apellido'];
				$producto = trim($productos[$i]['art_codigo']) . "-" . trim($productos[$i]['art_nombre']);

				$materia_prima = $mano_obra = $chk_est = 0;
				$materia_prima_semi = $gasto_indirectos = 0;
				//Comprobamos si tiene flag de produccion
				foreach ($data_materia_prima as $key => $value) {
					if ($value['art_produccion'] > 0) {
						//Esto es para producto semi terminado
						$materia_prima_semi += ($value['axm_cantidad'] * $value['axm_precio']);
					} else {
						$materia_prima += ($value['axm_cantidad'] * $value['axm_precio']);
					}
					if ($value['axm_estimacion_porcentaje'] > 0) {
						$chk_est += ($value['axm_cantidad'] * $value['axm_precio']);
					}
				}
				foreach ($data_mano_obra as $key2 => $value2) {
					$mano_obra += ($value2['mxo_cantidad'] * $value2['mxo_precio']);
					if ($value2['mxo_estimacion_porcentaje'] > 0) {
						$chk_est += ($value2['mxo_cantidad'] * $value2['mxo_precio']);
					}
				}
				$costo_primo = $materia_prima + $mano_obra;
				if (count($data_gastos_indirectos) > 0) {
					foreach ($data_gastos_indirectos as $key3 => $data) {
						if ($data['esm_tipo_calculo'] == 0) {
							// porcentaje
							if (isset($data['exr_id']) && $data['exr_id'] != null) {
								$cantidad_gasto = $data['exr_cantidad'];
								$gasto_indirectos += $data['exr_monto_calculo'];
							} else {
								$cantidad_gasto = $data['esr_cantidad'];
								$gasto_indirectos += $data['esr_monto_calculo'];
							}
						} else {
							// monto
							if (isset($data['exr_id']) && $data['exr_id'] != null) {
								$cantidad_gasto = $data['exr_cantidad'];
								$precio_gasto = $data['exr_precio'];
							} else {
								$cantidad_gasto = ($data['esr_cantidad'] * $articuloxorden[$k]['axo_cantidad']);
								$precio_gasto = $data['esr_precio'];
							}
							$gasto_indirectos += ($cantidad_gasto * $precio_gasto);
						}
					}
				}
				$costo_prod = $costo_primo + $gasto_indirectos + $materia_prima_semi;

				$costo_unitario = $costo_prod / $articuloxorden[$k]['axo_cantidad'];
?>
				<tr>
					<td><?php echo $producto; ?></td>
					<td><?php echo $orden[0]['ord_codigo']; ?></td>
					<td><?php echo $nombre_cliente; ?></td>
					<td style="text-align: center;"><?php echo number_format($articuloxorden[$k]['axo_cantidad']); ?></td>
					<td><?php echo number_format($materia_prima, 2); ?></td>
					<td><?php echo number_format($mano_obra, 2); ?></td>
					<td><?php echo number_format($costo_primo, 2); ?></td>
					<td><?php echo number_format($gasto_indirectos, 2); ?></td>
					<td><?php echo number_format($materia_prima_semi, 2); ?></td>
					<td><?php echo number_format($costo_prod, 2); ?></td>
					<td><?php echo number_format($costo_unitario, 2); ?></td>
				</tr>
<?php
			}
		}
	}
}
?>