    <?php
    if ($tipo_reporte == 'excel') {
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header("content-disposition: attachment;filename=" . $filename . ".xls");
        header("Pragma: no-cache");
        header("Expires: 0");
    }
    ?>
    <?php if ($tipo_reporte == 'excel') { ?>
        <meta charset="utf-8" />
        <div class="head">
            <table>
                <tr>
                    <td align="center" colspan="7">
                        <h4>
                            <?php
                            echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                            ?> <br />
                            Reporte de avance de produccion por producto
                        </h4>
                    </td>
                </tr>
            </table>
        </div>
    <?php } ?>

    <?php if ($data) : ?>

        <table class="responsive table table-bordered contenedor" id="datagried" name="datagried">
            <tbody id="body_productos_dee">
                <?php foreach ($data as $k1 => $prod) : ?>



                    <tr nobr="true">
                        <td style="border:1px solid black;" colspan="2"><strong><?php echo 'Orden ' . $prod['ord_codigo'] . ' / ' . $prod['axo_descripcion']; ?></strong></td>
                        <td style="border:none"></td>
                    </tr>
                    <tr nobr="true">
                        <td style="border:1px solid black;"><strong>Lote</strong></td>
                        <td style="border:1px solid black;"><?php echo $prod['lop_nombre']; ?></td>
                        <td style="border:none"></td>
                    </tr>
                    <tr nobr="true">
                        <td style="border:1px solid black;"><strong>Cantidad</strong></td>
                        <td style="border:1px solid black;"><?php echo $prod['lop_cantidad']; ?></td>
                        <td style="border:none"></td>
                    </tr>
                    <tr nobr="true" style="color: #000000;">
                        <td style="text-align: center; border:1px solid black;"><strong>ETAPAS</strong></td>
                        <td style="text-align: center; border:1px solid black;"><strong>PROCESADOS</strong></td>
                        <td style="text-align: center; border:1px solid black;"><strong>% DE AVANCE</strong></td>
                    </tr>
                    <?php foreach ($prod['etp_nombre'] as $k2 => $etp_nom) : ?>
                        <tr nobr="true">
                            <td style="border:1px solid black;"><?php echo $etp_nom ?></td>
                            <td style="border:1px solid black;"><?php echo ($prod['exo_cantidad'][$k2]) ? $prod['exo_cantidad'][$k2] : 0.00; ?></td>
                            <td style="border:1px solid black;"><?php echo number_format(($prod['exo_cantidad'][$k2] / $prod['lop_cantidad']) * 100, 2, '.', ' '); ?></td>
                        </tr>
                    <?php endforeach; ?>
                    <tr nobr="true" style="border:none">
                        <td style="border:none"></td>
                        <td style="border:none"></td>
                        <td style="border:none"></td>
                    </tr>

                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else : ?>
        <table class="responsive table table-bordered contenedor" id="datagried" name="datagried">
            <thead id="head_productos_dee">
            </thead>
            <tbody>
                <tr>
                    <td><strong>No se encontraron resultados</strong></td>
                </tr>
            </tbody>
        </table>
    <?php endif; ?>
    <!--</div>-->

    <script type="text/javascript">

    </script>