<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment; filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<style type="text/css">
    .num {
        mso-number-format:General;
    }
    .text{
        mso-number-format:"\@";/*force text*/
    }
</style>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="6" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Programación de Producción #<?php echo $programacion[0]['ppd_id']; ?>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php 
if (count($programacion) > 0) {
    $periodo = "";
    if ($programacion[0]['ppd_fecha_inicio'] != "" && $programacion[0]['ppd_fecha_fin'] != "") {
        $fecha_inicio = formatear_fecha('d-m-Y', $programacion[0]['ppd_fecha_inicio']);
        $fecha_fin = formatear_fecha('d-m-Y', $programacion[0]['ppd_fecha_fin']);
        $periodo = $fecha_inicio . "/" . $fecha_fin;
    }
    ?>
    <table border="0">
        <tr>
            <th>Período</th>
            <th><?php echo $periodo; ?></th>
            <th>Concepto</th>
            <th><?php echo $programacion[0]["ppd_concepto"]; ?></th>
        </tr>
    </table>
    <div class="clear"></div>
    <table border="1" width="100%">
        <thead>            
            <tr>
                <th>Orden de Producción</th>
                <th>Categoría</th>
                <th>Código</th>
                <th>Producto</th>
                <th>Cantidad a Producir</th>
                <th>Unidad</th>
                <th>Fecha Inicio</th>
            </tr>
        </thead>
        <tbody>
            <?php
            foreach ($programacion as $key => $value) {
                ?>
                <tr>
                    <td class="text"><?php echo $value['ord_codigo']; ?></td>
                    <td><?php echo $value['tia_nombre']; ?></td>
                    <td class="text"><?php echo $value['art_codigo']; ?></td>
                    <td><?php echo $value['art_nombre']; ?></td>
                    <td style="text-align: right;" class="num"><?php echo number_format($value['dpp_cantidad_orden'], 2); ?></td>
                    <td><?php echo $value['unidad']; ?></td>
                    <td><?php echo formatear_fecha('d-m-Y', $value['dpp_fecha_inicio']); ?></td>
                </tr>
                <?php
            }
            ?>
        </tbody>
    </table>
    <?php
} 
?>

    


                

            
            

        
