<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment; filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<style type="text/css">
    .num {
        mso-number-format:General;
    }
    .text{
        mso-number-format:"\@";/*force text*/
    }
</style>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="6" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Planificación de Producción #<?php echo $planificacion[0]['plf_id']; ?>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php 
if (count($planificacion) > 0) {
    $periodo = "";
    if ($planificacion[0]['plf_fecha_inicio'] != "" && $planificacion[0]['plf_fecha_fin'] != "") {
        $fecha_inicio = formatear_fecha('d-m-Y', $planificacion[0]['plf_fecha_inicio']);
        $fecha_fin = formatear_fecha('d-m-Y', $planificacion[0]['plf_fecha_fin']);
        $periodo = $fecha_inicio . "/" . $fecha_fin;
    }
    ?>
    <table border="0">
        <tr>
            <th>Período</th>
            <th><?php echo $periodo; ?></th>
            <th>Concepto</th>
            <th><?php echo $planificacion[0]["plf_concepto"]; ?></th>
        </tr>
    </table>
    <div class="clear"></div>
    <table border="1" width="100%">
        <thead>            
            <tr>
                <th>Categoría</th>
                <th>Producto</th>
                <th>Unidad de Medida</th>
                <th>Cantidad a Producir</th>
                <th>Inventario Actual</th>
                <th>Inventario en Proceso</th>
                <th>Última OP</th>
                <th>Última Producción</th>
                <th>Última Fecha de Producción</th>
                <th>Promedio Ventas 12 Meses</th>
                <th>Promedio Ventas 6 Meses</th>
                <th>Promedio Ventas 3 Meses</th>
                <th>Promedio Ventas 2 Meses</th>
                <th>Promedio Ventas 1 Mes</th>
                <th>Alcance Actual</th>
                <th>Alcance Proyectado</th>
                <th>Venta Proyectada 3 Meses</th>
                <th>Venta Proyectada 6 Meses</th>
            </tr>
        </thead>
        <tbody>
            <?php
            foreach ($planificacion as $key => $value) {
                ?>
                <tr>
                    <td><?php echo $value['tia_nombre']; ?></td>
                    <td><?php echo $value['art_codigo'] . ' - ' . $value['art_nombre']; ?></td>
                    <td><?php echo $value['unidad']; ?></td>
                    <td style="text-align: right;" class="num"><?php echo number_format($value['dpf_cantidad_producir'], 2); ?></td>
                    <td style="text-align: right;" class="num"><?php echo number_format($value['dpf_inventario_actual'], 2); ?></td>
                    <td style="text-align: right;" class="num"><?php echo number_format($value['dpf_inventario_proceso'], 2); ?></td>
                    <td class="text"><?php echo $value['ord_codigo']; ?></td>
                    <td class="num"><?php echo ($value['dpf_ultima_produccion'] != "") ? number_format($value['dpf_ultima_produccion'], 2) : '--'; ?></td>
                    <td><?php echo ($value['dpf_fecha_produccion'] != "") ? formatear_fecha('d-m-Y', $value['dpf_fecha_produccion']): '--'; ?></td>
                    <td class="num"><?php echo number_format($value['dpf_promedio_venta5'], 2); ?></td>
                    <td class="num"><?php echo number_format($value['dpf_promedio_venta4'], 2); ?></td>
                    <td class="num"><?php echo number_format($value['dpf_promedio_venta3'], 2); ?></td>
                    <td class="num"><?php echo number_format($value['dpf_promedio_venta2'], 2); ?></td>
                    <td class="num"><?php echo number_format($value['dpf_promedio_venta1'], 2); ?></td>
                    <td class="num"><?php echo number_format($value['dpf_alcance_actual'], 2); ?></td>
                    <td class="num"><?php echo number_format($value['dpf_alcance_proyectado'], 2); ?></td>
                    <td class="num"><?php echo ($value['dpf_venta_proyectada1'] > 0) ? number_format($value['dpf_venta_proyectada1'], 2) : '--'; ?></td>
                    <td class="num"><?php echo ($value['dpf_venta_proyectada2'] > 0) ? number_format($value['dpf_venta_proyectada2'], 2) : '--'; ?></td>
                </tr>
                <?php
            }
            ?>
        </tbody>
    </table>
    <?php
} 
?>

