<?php
$nombre_cliente = $orden['cli_codigo'] . " - ";
$nombre_cliente .= ($orden['cli_personeria'] == 1) ? $orden['cli_nombre'] . ' ' . $orden['cli_apellido'] : $orden['cli_apellido'];
?>
<table width="100%" border="0">
    <thead>
        <tr>
            <th colspan="5" style="text-align: center; border: black 1px solid;"><b>Detalles de la orden</b></th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td><b>Código Orden:</b></td>
            <td><?php echo $orden['ord_codigo']; ?></td>
            <td></td>
            <td><b>Cliente:</b></td>
            <td><?php echo $nombre_cliente; ?></td>
        </tr>
        <tr>
            <td><b>Cantidad:</b></td>
            <td><?php echo number_format($producto['axo_cantidad'], $decimales); ?></td>
            <td></td>
            <td><b>Producto:</b></td>
            <td><?php echo $producto['art_codigo'] . ' - ' . $producto['art_nombre']; ?></td>
        </tr>
        <tr>
            <td><b>Presentación:</b></td>
            <td><?php echo $producto['mep_nombre']; ?></td>
            <td></td>
            <td><b>Descripción:</b></td>
            <td><?php echo $producto['axo_descripcion']; ?></td>
        </tr>
    </tbody>
</table>
<br><br>
<table width="100%" border="1">
    <thead>
        <tr>
            <th colspan="7" style="text-align: center;"><b>Materia Prima</b></th>
        </tr>
        <tr>
            <th><b>Materia Prima</b></th>
            <th>Etapa</th>
            <th>U. Medida</th>
            <th>Proveedor</th>
            <th>Cantidad</th>
            <th>Precio ($)</th>
            <th>Subtotal ($)</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $totalMateriaPrima = 0;
        if (count($materia_prima) > 0) {
            $solicitud_orden = $producto['axo_cantidad'] * $producto['cva_conversion'];
            foreach ($materia_prima as $key => $axm) {
                $nombre_proveedor = $axm['prv_codigo'] . ' - ';
                $nombre_proveedor .= ($axm['prv_tipo_pers'] > 1) ? $axm['prv_apellido'] : $axm['prv_nombre'] . ' ' . $axm['prv_apellido'];
                $subtotalMateriaPrima = ($axm['axm_cantidad'] * $axm['axm_precio']);
                $totalMateriaPrima += $subtotalMateriaPrima;
                ?>
                <tr nobr="true">
                    <td><?php echo $axm['art_codigo'] . ' - ' . $axm['art_nombre']; ?></td>
                    <td><?php echo ($axm['etapa_nombre'] != '') ? $axm['etapa_nombre'] : "--"; ?></td>
                    <td><?php echo $axm['mep_nombre']; ?></td>
                    <td><?php echo $nombre_proveedor; ?></td>
                    <td style="text-align: right;"><?php echo number_format($axm['axm_cantidad'], $decimales); ?></td>
                    <td style="text-align: right;">$<?php echo number_format($axm['axm_precio'], $decimales); ?></td>
                    <td style="text-align: right;">$<?php echo number_format($subtotalMateriaPrima, $decimales); ?></td>
                </tr>
            <?php } ?>
            <tr>
                <td colspan="6" style="text-align: right;"><b>Total ($):</b></td>
                <td style="text-align: right;"><b>$<?php echo number_format($totalMateriaPrima, $decimales); ?></b></td>
            </tr>
        <?php } else { ?>
            <tr>
                <td colspan="7" style="text-align: center;"><b>No se encontraron datos para Materia Prima</b></td>
            </tr>
        <?php } ?>
    </tbody>    
</table>
<br><br>
<table width="100%" border="1">
    <thead>
        <tr>
            <th colspan="6" style="text-align: center;"><b>Mano de Obra</b></th>
        </tr>
        <tr>
            <th>Código</th>
            <th>Mano de Obra</th>
            <th>Responsable</th>
            <th>Cantidad</th>
            <th>Precio ($)</th>
            <th>Subtotal ($)</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $totalMob = 0; 
        if (count($mano_obra) > 0) {
            foreach ($mano_obra as $key => $mxo) {
                $nombre_empleado = ($mxo['emp_nombre'] != "") ? $mxo['emp_codigo'] . ' - ' . $mxo['emp_nombre'] . ' ' . $mxo['emp_apellido'] : "--";
                $horas_etapa = ($mxo['mob_calculo_etapa'] > 0) ? 1 : $producto['axo_cantidad'];
                $subtotalMob = ($mxo['mxo_precio'] * $mxo['mxo_cantidad']);
                $totalMob += $subtotalMob;
                ?>
                <tr nobr="true">
                    <td><?php echo $mxo['mob_codigo']; ?></td>
                    <td><?php echo $mxo['mob_nombre']; ?></td>
                    <td><?php echo $nombre_empleado; ?></td>
                    <td style="text-align: right;"><?php echo number_format($mxo['mxo_cantidad'], $decimales); ?></td>
                    <td style="text-align: right;">$<?php echo number_format($mxo['mxo_precio'], $decimales); ?></td>
                    <td style="text-align: right;">$<?php echo number_format($subtotalMob, $decimales); ?></td>
                </tr>
            <?php } ?>
            <tr>
                <td colspan="5" style="text-align: right;"><b>Total ($):</b></td>
                <td style="text-align: right;"><b>$<?php echo number_format($totalMob, $decimales); ?></b></td>
            </tr>
        <?php } else { ?>
            <tr>
                <td colspan="6" style="text-align: center;"><b>No se encontraron datos para Mano de Obra</b></td>
            </tr>
        <?php } ?>
    </tbody>
</table>
<br><br>
<table width="100%" border="1">
    <thead>
        <tr>
            <th colspan="6" style="text-align: center;"><b>Otros Gastosde Fabricación</b></th>
        </tr>
        <tr>
            <th>Código</th>
            <th>Estimación</th>
            <th>Tipo de cálculo</th>
            <th>Cantidad</th>
            <th>Valor</th>
            <th>Subtotal ($)</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $totalGasto = 0;
        if (count($otros_gastos) > 0) {
            foreach ($otros_gastos as $key => $exr) {
                $gtos_indirectos = ($exr['esm_tipo_calculo'] == 0) ? 'Porcentaje' : 'Monto';
                $gtos_fijo_var = (isset($exr['esr_tipo_costo']) && $exr['esr_tipo_costo'] > 0) ? 1 : $producto['axo_cantidad'];
                $gtos_indirectos .= ($exr['esr_tipo_costo'] > 0) ? ' (Gasto Fijo)' : ' (Variable)';
                $subtotalGasto = ($exr['esm_tipo_calculo'] == 1) ? ($exr['exr_cantidad'] * $exr['exr_precio']) : $exr['exr_monto_calculo'];
                $totalGasto += $subtotalGasto;
                ?>
                <tr nobr="true">
                    <td><?php echo $exr['esm_codigo']; ?></td>
                    <td><?php echo $exr['esm_nombre']; ?></td>
                    <td><?php echo $gtos_indirectos; ?></td>
                    <td style="text-align: right;"><?php echo number_format($exr['exr_cantidad'], $decimales); ?></td>
                    <td style="text-align: right;">$<?php echo number_format($exr['exr_precio'], $decimales); ?></td>
                    <td style="text-align: right;">$<?php echo number_format($subtotalGasto, $decimales); ?></td>
                </tr>
            <?php } ?>
            <tr>
                <td colspan="5" style="text-align: right"><b>Total ($):</b></td>
                <td style="text-align: right;">$<?php echo number_format($totalGasto, $decimales); ?></td>
            </tr>
        <?php } else { ?>
        <?php } ?>
    </tbody>
</table>
<br><br>
<?php
$totalCosto = $totalMateriaPrima + $totalMob + $totalGasto;
$costo_unit = ($totalCosto / $producto['axo_cantidad']);
?>
<table border="0" cellpadding="0">
    <tr>
        <td width="60%"></td>
        <td width="40%"><table width="100%" border="1" cellpadding="1">
                <tr nobr="true">
                    <td>Total Costo ($):</td>
                    <td style="text-align: right;">$<?php echo number_format($totalCosto, $decimales); ?></td>
                </tr>
                <tr nobr="true">
                    <td>Costo Unitario ($):</td>
                    <td style="text-align: right;">$<?php echo number_format($costo_unit, $decimales); ?></td>
                </tr>
            </table>
        </td>
    </tr>
</table>
