<script type="text/javascript">
    $(document).ready(function () {
        $(".ver-accion-modal").live('click', function (event) {
            event.preventDefault();
            var url = $(this).attr('href');
            $.fancybox({
                'href': url,
                type: 'iframe',
                width: '70%',
                closeBtn: true,
                height: '70%'
            });
        });
    });
</script>
<div class="row-fluid">
    <div class="span12">
        <!-- Grid -->
        <div class="box">
            <a type="button" class="btn btn-large" id="crear_orden" href="<?php echo base_url('proyectos/procesos/solicitud_materiales/' . $orden['ord_id']); ?>">
                <strong>Nueva solicitud</strong>
            </a>   
            <div class="title">
                <h4>
                    <span>Listado de Solicitudes</span>
                </h4>
            </div>
            <div class="content noPad clearfix" id="dv_contenedor_documentos">
                <table id="tblDocumentos" cellpadding="0" cellspacing="0" border="0" class="responsive <?php
                if ($requisiciones) {
                    echo 'dynamicTable';
                }
                ?> display table table-bordered" width="100%">
                    <thead>
                        <tr>
                            <th>Código</th>
                            <th>Fecha</th>
                            <th>Tipo de Solicitud</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if ($requisiciones):
                            $numero_fila = 1;
                            foreach ($requisiciones as $rxi) :
                                switch ($rxi['rxi_estado']) {
                                    case 1:
                                        $estado_requisicion = "Creada";
                                        break;
                                    case 2 :
                                        $estado_requisicion = "Pendiente de autorización";
                                        break;

                                    case 3 :
                                        $estado_requisicion = "Autorizada";
                                        break;

                                    case 4 :
                                        $estado_requisicion = "Rechazada";
                                        break;

                                    case 5 :
                                        $estado_requisicion = "Anulada";
                                        break;
                                    case 6 :
                                        $estado_requisicion = "Parciales";
                                        break;
                                    case 0:
                                        $estado_requisicion = "Despachada";
                                        break;
                                }

                                $tipoSolicitud = ($rxi['rxi_proceso_requisicion'] == 1) ? "Inventario" : "Compras";
                                ?>
                                <tr >
                                    <td><?php echo $rxi['rxi_numero']; ?></td>
                                    <td><?php echo formatear_fecha('d-m-Y', $rxi['rxi_fecha']); ?></td>
                                    <td><?php echo $tipoSolicitud; ?></td>
                                    <td><?php echo $estado_requisicion; ?></td>
                                    <td> 
                                        <div class="tools">
                                            <div class="btn-group">
                                                <button class="btn"><span class="icon16 icomoon-icon-cog-2"></span></button>
                                                <button class="btn dropdown-toggle" data-toggle="dropdown">
                                                    <span class="caret"></span>
                                                </button>
                                                <ul class="dropdown-menu">
                                                    <?php if ($rxi['rxi_proceso_requisicion'] == 1): ?>
                                                        <li>
                                                            <a class="tipB ver-accion-modal" title="Ver Requisición" href="<?= base_url('inventario/gestion_productos/ver_detalle_req/1/' . $rxi['rxi_id']) ?>">
                                                                <span aria-hidden="true" class="icomoon-icon-search-3"></span>
                                                                Ver Detalle
                                                            </a>
                                                        </li>
                                                        <?php if ($rxi['rxi_estado'] == 1): ?>
                                                            <li>
                                                                <a class="tipB ver-accion-modal" title="Anular Requisición" href="<?= base_url('inventario/gestion_productos/anular_requisicion/1/' . $rxi['rxi_id']) ?>">
                                                                    <span aria-hidden="true" class="icomoon-icon-cancel-4"></span>
                                                                    Anular
                                                                </a>
                                                            </li>
                                                        <?php endif; ?>
                                                    <?php elseif ($rxi['rxi_proceso_requisicion'] == 2): ?>
                                                        <li>
                                                            <a class="tipB ver-accion-modal" title="Ver Requisición" href="<?= base_url('modulo_compras/procesos/ver_detalle_req/1/' . $rxi['rxi_id']) ?>">
                                                                <span aria-hidden="true" class="icomoon-icon-search-3"></span>
                                                                Ver Detalle
                                                            </a>
                                                        </li>
                                                        <?php if ($rxi['rxi_estado'] == 1): ?>
                                                            <li>
                                                                <a class="tipB ver-accion-modal" title="Anular Requisición" href="<?= base_url('modulo_compras/procesos/anular_requisicion/1/' . $rxi['rxi_id']) ?>">
                                                                    <span aria-hidden="true" class="icomoon-icon-cancel-4"></span>
                                                                    Anular
                                                                </a>
                                                            </li>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                    <li>
                                                        <a target="_blank" class="tipB" title="Imprimir Requisición" href="<?= base_url('proyectos/reportes/reporte_requisicion_materiales/' . $rxi['rxi_id'] . '/1') ?>">
                                                            <span aria-hidden="true" class="icomoon-icon-printer    "></span>
                                                            Imprimir
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>                        
                                    </td>
                                </tr>
                                <?php
                            endforeach;
                        else :
                            ?>
                            <tr>
                                <td>0</td>
                                <td colspan="5" align="center">Cero registros encontrados</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>