<form id="frm-lotes" name="frm-lotes" method="POST" action="<?php echo base_url('proyectos/procesos/editar_lotes/' . $detalle_orden[0]['axo_id']); ?>">
    <div class="row-fluid">
        <div class="span12">
            <div class="box">
                <div class="title">
                    <h4>Orden de Producción</h4>
                </div>
                <div class="content">
                    <div class="form-row row-fluid">
                        <div class="span6">
                            <div class="row-fluid">                                    
                                <label class="span3 form-label">N. Orden:</label>
                                <div class="span7 controls">
                                    <input type="text" id="txtOrden" readonly="readonly" value="<?php echo $orden['ord_codigo']; ?>" />
                                </div>
                                <input type="hidden" name="hdnOrden" value="<?php echo $orden['ord_id']; ?>"/>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">                                    
                                <label class="span3 form-label">Concepto:</label>
                                <div class="span7 controls">
                                    <input type="text" id="txtConcepto" readonly="readonly" value="<?php echo $orden['ord_concepto']; ?>" />
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Producto:<b class="red">*</b></label>
                                <div class="span7 controls">
                                    <select class="nostyle" id="slcProducto">
                                        <option></option>
                                        <?php
                                        if (count($detalle_orden) > 0):
                                            foreach ($detalle_orden as $det):
                                                $cantidad = $det['axo_cantidad'];
                                                ?>
                                                <option selected="selected" data-cantidad="<?php echo $det['axo_cantidad']; ?>" value="<?php echo $det['axo_id']; ?>">
                                                    <?php echo $det['art_codigo'] . ' - ' . $det['art_nombre']." (".$det['axo_descripcion'].")"; ?>
                                                </option>
                                                <?php
                                            endforeach;
                                        endif;
                                        ?>
                                    </select>
                                    <input type="hidden" id="hdnSelectProducto" />
                                    <br/>
                                    <div id="slcProducto_error" style="position: relative;margin-top: 6%;"></div>
                                </div>
                            </div>
                        </div>
                        <div class="span7">
                            <div class="row-fluid">
                                <label class="form-label span3" style="margin-right: -2.5%;">Cantidad Total:</label>
                                <div class="span5 controls">
                                    <input type="text" id="txtCantidadTotal" readonly="readonly" value="<?php echo $cantidad; ?>"/>
                                    <input type="hidden" id="edit_lop" value="1">
                                    <br/>
                                    <div id="txtCantidadTotal_error" class="div-error"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="box">
                <div class="title">
                    <h4>Detalles</h4>
                </div>
                <div class="content">
                    <div class="form-row row-fluid">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Nombre:</label>
                                <div class="span7 controls">
                                    <input type="text" id="txtNombreLote" maxlength="300"/>
                                    <br/>
                                    <div id="txtNombreLote_error" class="div-error"></div>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Cantidad:</label>
                                <div class="span7 controls">
                                    <input type="text" id="txtCantidad" class="soloNumeros" maxlength="17"/>
                                    <br/>
                                    <div id="ttxtCantidad_error" class="div-error"></div>
                                </div>
                            </div>
                        </div>
                        <div class="span12">
                            <div class="span7 controls">
                                <button type="button" class="btn btn-info" id="btnAgregar">Agregar</button>
                            </div>
                        </div>
                        <div class="span12"></div>
                        <div class="span12" style="width: 99%;">
                            <table class="simpleTablePaging responsive table table-bordered contenedor" id="tblProductos">
                                <thead id="thProductos">
                                <th>Producto</th>
                                <th>Lote</th>
                                <th>Cantidad</th>
                                <th>Acciones</th>
                                </thead>
                                <tbody id="tbProductos">
                                    <?php
                                    $totalLotes = 0;
                                    $total_etapas = 0;
                                    $job_tracking = 0;
                                    if (count($lotes) > 0):
                                        $i = 0;
                                        foreach ($lotes as $lop):
                                            $totalLotes += $lop['lop_cantidad'];
                                            $total_etapas += $lop['num_etapas'];
                                            $job_tracking += $lop['num_moe_jt'];
                                            ?>
                                            <tr id="tr_<?php echo $i; ?>" class="trProducto" data-id="<?php echo $i; ?>">
                                                <td>
                                                    <input type="hidden" name="hdnDetalle[]" class="tables-input" value="<?php echo $lop['lop_id']; ?>" />
                                                    <input type="hidden" class="productos_reg" value="<?= $lop['axo_id'] ?>" />
                                                    <input type="text" class="text tables-input" value="<?php echo $lop['art_codigo'] . ' - ' . $lop['art_nombre']; ?>" readonly="readonly"/>
                                                    <select id="slcProducto_<?php echo $i; ?>" data-id="<?php echo $i; ?>" name="productos[]" style="display:none;" class="slcProducto">
                                                        <option selected="selected" value="<?php echo $lop['axo_id']; ?>"><?php echo $lop['art_nombre']; ?></option>
                                                    </select>
                                                </td>
                                                <td>
                                                    <input type="text" id="txtNombreLote_<?php echo $i; ?>" name="nombreLotes[]" class="loteProducto text tables-input-show tables-input" value="<?php echo $lop['lop_nombre']; ?>" readonly="readonly"/>
                                                </td>
                                                <td>
                                                    <input type="text" id="txtCantidad_<?php echo $i; ?>" name="cantidades[]" class="text tables-input-show tables-input cantidadProducto soloNumeros" extras="." value="<?php echo number_format($lop['lop_cantidad'],2,'.',''); ?>" readonly="readonly"/>
                                                </td>
                                                <td>
                                                    <?php if ($lop['num_moe_jt'] == 0){ ?>
                                                        <button type="button" class="btn btn-primary btn-mini btnGuardarProd" style="margin-right: 5px;float: left; height: 30px; width: 50px;display: none;">Guardar</button>
                                                        <button type="button" class="btn btn-primary btn-mini btnEditProd" style="margin-right: 5px;float: left; height: 30px; width: 50px; display: block;">Editar</button>
                                                    <?php }; ?>
                                                    <?php if ($lop['num_etapas'] == 0): ?>
                                                        <button type="button" class="btn btn-danger btn-mini btnDelProd" style="float:left;height:30px;width:50px;">Eliminar</button>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php
                                            $i++;
                                        endforeach;
                                    endif;
                                    ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="span7">
                            <div class="row-fluid">
                                <label class="form-label span3" style="margin-right: -2.5%;">Total Lotes:</label>
                                <div class="span5 controls">
                                    <input type="text" id="txtTotalLotes" readonly="readonly" value="<?php echo number_format($totalLotes,2); ?>" />
                                    <br/>
                                </div>
                            </div>
                        </div>
                        <div class="form-actions span12" style="text-align: center;">
                            <button type="submit" class="btn btn-success" name="btnCrear" value="1"><span class="icon16 icomoon-icon-checkmark white"></span>Actualizar</button>
                            <button type="submit" class="btn btn-success" name="btnCrear" value="2"><span class="icon16 icomoon-icon-checkmark white"></span>Actualizar y volver a la lista</button>
                            <a href="<?php echo base_url('proyectos/procesos/lotes/' . $orden['ord_id']); ?>" class="btn btn-danger btn-cancelar" id="">
                                <span class="icon16 icomoon-icon-cancel-2 white"></span>Cancelar
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<script type="text/javascript" src="<?= base_url() ?>js/proyectos/procesos/frmLotes.js" ></script>
<script type="text/javascript">
    $(document).ready(function () {
        $("#slcProducto").select2('disable');
        var totalEtapas = '<?php echo $total_etapas; ?>';
        var totalJobtrk = '<?php echo $job_tracking; ?>';
        if (totalEtapas > 0 || totalJobtrk > 0) {
            var texto = "";
            if (totalEtapas > 0) {
                texto += 'Lotes que posean registros que dependan de ellos no podrán ser eliminados.\n'
            }
            if (totalJobtrk > 0) {
                texto += 'Lotes que ya iniciaron el proceso de Job tracking no podrán ser editados.\n'
            }
            crear_alerta('info', 'Lotes', texto);
        }        
    });
</script>