<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment; filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<style type="text/css">
    .num {
        mso-number-format:General;
    }
    .text{
        mso-number-format:"\@";/*force text*/
    }
</style>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="6" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Explosión de Materiales, <?= ($tipo > 0) ? 'Programación' : 'Planificación'; ?> #<?= ($tipo > 0) ? $detalles[0]['edp_id_ppd'] : $detalles[0]['dex_id_plf']; ?>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php 
if (count($detalles) > 0) {
    ?>
    <div class="clear"></div>
    <table border="1" width="100%">                            
        <thead>            
            <tr>
                <th>Categoría</th>
                <th>Código</th>
                <th>Producto</th>
                <th>Presentación</th>                
                <th>Total a Solicitar</th>
                <th>Existencias</th>
                <th>Faltante</th>
                <th>Tipo Solicitud</th>
                <th>Se Solicitó</th>
                <th>Orden / Requisición</th>
            </tr>
        </thead>
        <tbody>
            <?php
            foreach ($detalles as $key => $value) {
                //tipo_rxi: 1=compras, 2=produccion, 3=inventario
                if ($tipo > 0) {
                    $ctdad_req = $value['edp_cantidad_requerida'];
                    $ctdad_ext = $value['edp_cantidad_existencia'];
                    $ctdad_flt = $value['edp_cantidad_faltante'];
                    if ($value['edp_tipo'] > 2) {
                        $tipo_rqui = 'Inventario';
                        $solicitud = ($value['edp_solicitar'] > 0) ? 'Sí' : 'No';
                        $orden_rxi = ($value['rex_invent'] != '') ? $value['rex_invent'] : '';
                    } elseif ($value['edp_tipo'] > 1) {
                        $tipo_rqui = 'Producción';
                        $solicitud = 'No';
                        $orden_rxi = '';
                    }else{
                        $tipo_rqui = 'Compras';
                        $solicitud = 'No';
                        $orden_rxi = '';
                    } 
                } else {
                    $ctdad_req = $value['dex_cantidad_requerida'];
                    $ctdad_ext = $value['dex_cantidad_existencia'];
                    $ctdad_flt = $value['dex_cantidad_faltante'];
                    if ($value['dex_tipo'] > 2) {
                        $tipo_rqui = 'Inventario';
                        $solicitud = 'No';
                        $orden_rxi = '';
                    } elseif ($value['dex_tipo'] > 1) {
                        $tipo_rqui = 'Producción';
                        $solicitud = ($value['dex_solicitar'] > 0) ? 'Sí' : 'No';
                        $orden_rxi = ($value['op_intermedio'] != '') ? $value['op_intermedio'] : '';
                    }else{
                        $tipo_rqui = 'Compras';
                        $solicitud = ($value['dex_solicitar'] > 0) ? 'Sí' : 'No';
                        $orden_rxi = ($value['rex_compras'] != '') ? $value['rex_compras'] : '';
                    }                    
                }
                ?>
                <tr>
                    <td><?php echo $value['tia_nombre']; ?></td>
                    <td><?php echo $value['art_codigo']; ?></td>
                    <td><?php echo $value['art_nombre']; ?></td>
                    <td><?php echo $value['mep_nombre']; ?></td>
                    <td style="text-align: right;" class="num"><?php echo number_format($ctdad_req, $dec); ?></td>
                    <td style="text-align: right;" class="num"><?php echo number_format($ctdad_ext, $dec); ?></td>
                    <td style="text-align: right;" class="num"><?php echo number_format($ctdad_flt, $dec); ?></td>
                    <td><?php echo $tipo_rqui; ?></td>
                    <td><?php echo $solicitud; ?></td>
                    <td><?php echo $orden_rxi; ?></td>
                </tr>
                <?php
            }
            ?>
        </tbody>
    </table>
    <?php
} 
?>

