<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4><span>Filtros </span></h4>
                <a href="#" class="minimize" style="display: none;">Minimize</a>
            </div>
            <div class="content">
                <div class="form-row row-fluid">
                    <div class="span5">
                        <div class="row-fluid">  
                            <label class="form-label span5">Desde:<b class="red">*</b></label>
                            <div class="span7 controls labels-info">
                                <input type="text" id="txt_fecha_ini" name="txt_fecha_ini" class="datePicker" value="<?php echo date('01-m-Y');?>" placeholder="dd-mm-yyyy" />
                            </div>
                        </div>
                    </div>
                    <div class="span5">
                        <div class="row-fluid">
                            <label class="form-label span3">Hasta:<b class="red">*</b></label>
                            <div class="span7 controls labels-info">
                                <input type="text" id="txt_fecha_fin" name="txt_fecha_fin"  class="datePicker" value="<?php echo date('d-m-Y');?>" placeholder="dd-mm-yyyy"/>
                            </div>
                        </div>
                    </div>
                    <div class="span2">
                        <div class="row-fluid">
                            <div class="span12 controls labels-info">
                                <button type="button" id="btn_consultar" class="btn btn-success"><span class="entypo-icon-search-2"> Consultar</span></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4><span>Ordenes de Producción</span></h4>
            </div>
            <div class="noPad content">
                <div class="row-fluid" >
                    <div class="span12" >              
                        <div class="noPad clearfix" id="dv_contenedor_listado" style="overflow: auto;height:100%;">
                            <table id="tabla_ordenes" class="dynamicTable responsive display table table-bordered">
                                <thead id="thProductos">
                                    <tr>
                                        <th>Código de Orden</th>
                                        <th>Cliente</th>
                                        <th>Fecha</th>
                                        <th>Concepto</th>
                                        <th>Estado</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody id="tbDetalle">
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function(){
        $(".datePicker").datepicker({
            showButtonPanel: false,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd-mm-yy',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior"
        });

        $('#btn_consultar').click(function() {
            $.ajax({
                type: 'post',
                url: urlj + 'proyectos/procesos/control_calidad',
                data: {
                    fecha_ini: $('#txt_fecha_ini').val(),
                    fecha_fin: $('#txt_fecha_fin').val()
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    var oTable = $('#tabla_ordenes').dataTable();
                    oTable.fnDestroy(); 
                    $("#tbDetalle").html(data);
                    aplicarDataTable('tabla_ordenes');
                    wait.close();
                }
            });
        });

        $("body").on("change", "#txt_fecha_ini, #txt_fecha_fin", function(){
            if (!(verifica_fecha($('#txt_fecha_ini').val(), $('#txt_fecha_fin').val()))) {
                $('#txt_fecha_ini').val('');
                $('#txt_fecha_fin').val('');
            }
        });

        $('#btn_consultar').trigger('click');

    });

    function verifica_fecha(fecha_ini, fecha_fin) {
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");
        if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
            crear_alerta('error','Fechas','Verifique las fechas del período');
            return false;
        }else{
            return true;
        }
    }

    function aplicarDataTable(idTabla) {
        $('#' + idTabla).dataTable({
    //         "sPaginationType": "full_numbers",
    //         "bJQueryUI": false,
    //         "bAutoWidth": false,
    //         "iDisplayLength": 20,
            "bLengthChange": false,
    //         "bDestroy": true,
    //         // "bFilter": true,//Esconder el buscador del datatable
    //         // "fnInitComplete": function (oSettings, json) {
    //         //  $('.dataTables_filter>label>input').attr('id', 'search');
    //         // }
        });
    }
</script>



<!-- <script type="text/javascript" src="<?= base_url() ?>js/proyectos/procesos/agregar_programacion_prod.js" ></script> -->

