<?php
$codigo             = "";
$fecha              = "";
$lugar              = "";
$actividad          = "";
$cursograma         = "";
$correlativo_global = 0;
if (count($analisis) > 0) {
    $codigo     = $analisis[0]["cra_codigo"];
    $fecha      = date('d-m-Y', strtotime($analisis[0]["cra_fecha"]));
    $lugar      = $analisis[0]["cra_lugar"];
    $actividad  = $analisis[0]["cra_actividad"];
    $cursograma = $analisis[0]["cra_id"];
}
?>

<form id="frm_estapas" method="post" name="frm_estapas" action="<?php echo base_url(); ?>proyectos/mantenimientos/etapas_cursograma_analitico/<?php echo $articulo[0]["art_id"]; ?>">
    <input type="hidden" id="txt_cursograma" name="txt_cursograma" value="<?php echo $cursograma; ?>">
    <input type="hidden" id="txt_decimales" value="<?php echo $decimales; ?>">
    <input type="hidden" id="txt_correlativo_global" value="<?php echo count($analisis); ?>">
    <div class="row-fluid">
        <a href="<?php echo base_url('proyectos/mantenimientos/articulo'); ?>" style="float:right;" class="btn"><span class="icon16 icomoon-icon-undo-2"></span>Regresar</a>
        <div class="span12">
            <div class="box">
                <div class="title">
                    <h4>
                        <span class="icon16 icomoon-icon-equalizer-2"></span>
                        <span>Lista de etapas analíticas</span>
                    </h4>
                    <a href="#" class="minimize" style="display: none;">Minimize</a>
                </div>
                <div class="content">
                    <div class="form-row row-fluid">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Código: <b style="color:red">*</b></label>
                                <div class="span7 controls">
                                    <input onchange="$('#txt_codigo_error').text('');" maxlength="100" type="text" name="txt_codigo" id="txt_codigo" class="" value="<?php echo $codigo; ?>" />
                                    <br><small id="txt_codigo_error" style="color:red;"></small>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Producto: <b style="color:red">*</b></label>
                                <div class="span7 controls">
                                    <input type="text" id="txt_producto" class="" value="<?php echo $articulo[0]["art_nombre"]; ?>" readonly />
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3" style="padding-right: 15px;">Fecha: <b style="color:red">*</b></label>
                                <div class="span7 controls">
                                    <input onchange="$('#txt_fecha_error').text('');" type="text" name="txt_fecha" id="txt_fecha" class="txtFechas" value="<?php echo ($fecha != "") ? $fecha : date('d-m-Y'); ?>" />
                                    <br><small id="txt_fecha_error" style="color:red;"></small>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Lugar: <b style="color:red">*</b></label>
                                <div class="span7 controls">
                                    <input onchange="$('#txt_lugar_error').text('');" maxlength="300" type="text" name="txt_lugar" id="txt_lugar" class="" value="<?php echo $lugar; ?>" />
                                    <br><small id="txt_lugar_error" style="color:red;"></small>
                                </div>
                            </div>
                        </div>

                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Actividad:</label>
                                <div class="span7 controls">
                                    <textarea onchange="$('#txt_actividad_error').text('');" name="txt_actividad" id="txt_actividad" cols="30" rows="3" maxlength="500"><?php echo $actividad; ?></textarea>
                                    <br><small id="txt_actividad_error" style="color:red;"></small>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Responsable:<b style="color:red">*</b></label>
                                <div class="span7 controls">
                                    <select onchange="$('#slc_responsable_error').text('');" class="dinamic nostyle" name="slc_responsable" id="slc_responsable" placeholder="seleccione">
                                        <?php echo $empleados; ?>
                                    </select>
                                    <br><br><small id="slc_responsable_error" style="color:red;"></small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div><!-- End .box -->
        </div><!-- End .span12 -->
    </div><!-- End .row-fluid -->
    <div class="row-fluid">
        <div class="span12">
            <div class="box">
                <div class="title">
                    <h4>
                        <span class="icon16 icomoon-icon-equalizer-2"></span>
                        <span>Etapas analíticas</span>
                    </h4>
                    <a href="#" class="minimize" style="display: none;">Minimize</a>
                </div>
                <div class="content">
                    <div class="form-row row-fluid">
                        <div id="div-categorias">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span3">Etapas:</label>
                                    <div class="span7 controls">
                                        <select class="dinamic nostyle" id="slc_etapas" placeholder="seleccione">
                                            <?php echo $etapas; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Cantidad:</label>
                                <div class="span7 controls">
                                    <input maxlength="19" type="text" name="txt_cantidad" id="txt_cantidad" class="soloDecimales" decimales="<?php echo $decimales; ?>" value="" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <br />
                    <div class="form-actions btn-agregar">
                        <button type="button" class="btn btn-info" id="btn_agregar"><span class="icon16 icomoon-icon-basket white"></span> Agregar</button>
                    </div>
                    <br>
                    <div class="span12" style="overflow-x: scroll;padding: 10px 0px 0px 5px;">
                        <table class="responsive table table-bordered contenedor" id="tbl_analisis">
                            <thead>
                                <tr>
                                    <th style="width: 5%;">
                                        Orden
                                    </th>
                                    <th style="width: 15%;">
                                        Etapa
                                    </th>
                                    <th style="width: 5%;">
                                        Cantidad
                                    </th>
                                    <th style="width: 10%;">
                                        Tiempo (min)
                                    </th>
                                    <th style="width: 15%;">
                                        Distancia (Mts)
                                    </th>
                                    <th style="width: 15%;">
                                        Proceso
                                    </th>
                                    <th style="width: 25%;">
                                        Observación
                                    </th>
                                    <th style="width: 10%;">
                                        Acción
                                    </th>
                                </tr>
                            </thead>
                            <tbody id="tb_analisis">
                                <?php
                                $html = "";
                                if (count($analisis) > 0) {
                                    foreach ($analisis as $key => $etapas) {
                                        $correlativo        = $etapas["exg_orden"];
                                        $correlativo_global++;
                                        $nombre_etapa       = $etapas["eca_nombre"];
                                        $etapa              = $etapas["exg_id_eca"];
                                        $cantidad           = number_format($etapas["exg_cantidad"], $decimales);
                                        $tiempo             = number_format($etapas["exg_tiempo"], $decimales);
                                        $distancia          = number_format($etapas["exg_distancia"], $decimales);
                                        $proceso            = $etapas["eca_proceso"];
                                        $etapa_id           = $etapas["exg_id"];
                                        $observacion        =  $etapas["exg_observacion"];
                                        $proceso_nom        = "";

                                        switch ($proceso) {
                                            case 1:
                                                $proceso_nom = "Operación";
                                                break;
                                            case 2:
                                                $proceso_nom = "Inspección";
                                                break;
                                            case 3:
                                                $proceso_nom = "Demora";
                                                break;
                                            case 4:
                                                $proceso_nom = "Transporte";
                                                break;
                                            case 5:
                                                $proceso_nom = "Almacenamiento";
                                                break;
                                        }

                                        $html    .= '<tr>';
                                        $html    .= '<td style="width: 5%;">';
                                        $html    .= ' <label class="correlativo_etapa">' . $correlativo . '</label>';
                                        $html    .= '<input type="hidden" class="correlativo_etapa_txt" id="tbl_orden_' . $correlativo_global . '" name="tbl_orden[]" value="' . $correlativo . '" readonly>';
                                        $html    .= '<input type="hidden" id="tbl_etapaxcursograma_' . $correlativo_global . '" name="tbl_etapaxcursograma[]" value="' . $etapa_id . '" readonly>';
                                        $html    .= '</td>';
                                        $html    .= '<td style="width: 15%;">';
                                        $html    .= $nombre_etapa;
                                        $html    .= '<input type="hidden" id="tbl_actividad_' . $correlativo_global . '" name="tbl_etapa[]" value="' . $etapa . '" readonly>';
                                        $html    .= '</td>';
                                        $html    .= '<td style="width: 5%;"><input type="text" id="tbl_cantidad_' . $correlativo_global . '" name="tbl_cantidad[]" value="' . $cantidad . '" class="soloDecimales tbl_cantidades" decimales="' . $decimales . '" maxlength="19"></td>';
                                        $html    .= '<td style="width: 10%;"><input type="text" id="tbl_tiempo_' . $correlativo_global . '" name="tbl_tiempo[]" value="' . $tiempo . '" class="soloDecimales" decimales="' . $decimales . '" maxlength="19"></td>';
                                        $html    .= '<td style="width: 15%;"><input type="text" id="tbl_distancia_' . $correlativo_global . '" name="tbl_distancia[]" value="' . $distancia . '" class="soloDecimales" decimales="' . $decimales . '" maxlength="19"></td>';
                                        $html    .= '<td style="width: 15%;">' . $proceso_nom . '<input type="hidden" id="tbl_proceso_' . $correlativo_global . '" name="tbl_proceso[]" value="' . $proceso . '" readonly></td>';
                                        $html    .= '<td style="width: 25%;"><input type="text" id="tbl_observacion_' . $correlativo_global . '" name="tbl_observacion[]" value="' . $observacion . '" maxlength="100"></td>';
                                        $html    .= '<td style="width: 10%;">';
                                        $html    .= '<button type="button" class="btn btn-danger btn-mini btn_del_etapa" style="float:left; height:30px;width:50px;"><input type="hidden" value="6" id="txtest">Eliminar</button>';
                                        $html    .= '</td>';
                                        $html    .= '</tr>';
                                    }
                                }
                                echo $html;
                                ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="clear"></div>
                    <div class="form-actions" style="text-align: center;">
                        <button type="submit" class="btn btn-success" name="btnCrear" value="1"><span class="icon16 icomoon-icon-checkmark white"></span>Guardar</button>
                        <button type="submit" class="btn btn-success" name="btnCrear" value="2"><span class="icon16 icomoon-icon-checkmark white"></span>Guardar y volver a la lista</button>
                        <a href="proyectos/mantenimientos/articulo" class="btn btn-danger btn-cancelar" id=""><span class="icon16 icomoon-icon-cancel-2 white"></span>Cancelar</a>
                        <br><br>
                        Campos con asterisco en <font color='FE2E2E'>rojo</font> son requeridos
                    </div>
                </div>
            </div><!-- End .box -->
        </div><!-- End .span12 -->
    </div><!-- End .row-fluid -->
</form>
<script type="text/javascript" src="<?= base_url() ?>js/proyectos/mantenimientos/etapas_cursograma_analitico.js"></script>