<style type="text/css">.ui-datepicker-current { display: none; }</style>
<div class="row-fluid">
    <div class="span12">
        <div class="box" >
            <div class="title">
                <h4>
                    <span>Filtros</span>
                </h4>
            </div>
            <div class="content"> 
                <div class="form-row row-fluid">
                    <div class="span12">
                        <div class="row-fluid">
                            <label class="form-label span3">
                                <span>Estado del Empleada/o: </span>
                            </label>
                            <div class="span7 controls">
                                <div class="span4">
                                    <div class="span2">
                                        <input type="radio" id="rb_1" name="emp_estado" title="Filtrar solo empleados activos" class="tip slc_stado_emp nostyle" value="1" checked>
                                    </div>
                                    <span>Solo Activos</span>
                                </div>
                                <div class="span4">
                                    <div class="span2">
                                        <input type="radio" id="rb_0" name="emp_estado" title="Filtrar solo empleados inactivos" class="tip slc_stado_emp nostyle" value="0">
                                    </div>
                                    <span>Solo Inactivos</span>
                                </div>
                                <div class="span4">
                                    <div class="span2">
                                        <input type="radio" id="rb_2" name="emp_estado" title="Filtrar sobre todos los empleados" class="tip slc_stado_emp nostyle" value="2">
                                    </div>
                                    <span>Todos (Activos e Inactivos)</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-row row-fluid">
                    <div class="span12">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Ingresos base a: <b class="red">*</b></label>
                                <div class="span7 controls">
                                    <input type="text" name="txt_mes" id="txt_mes" class="datePicker" placeholder="mm-yyyy" readonly>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Empleada/o: </label>
                                <div class="span7 controls" id="contenedor_empleado">
                                    <select name="slcEmpleado" id="slcEmpleado" class="nostyle" placeholder="Seleccione">
                                        <option value=""></option>
                                        <?php echo $empleado; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-row row-fluid">
                    <div class="span12">
                        <div class="span6">
                            <div class="row-fluid">
                                <button type="button" class="btn btn-info" id="ver_detalle" style=""><span class="icon16  icomoon-icon-search-3 white"></span> Consultar</button>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid" style="text-align: right;">
                                <form name="frm-report" id="frm-report" method="POST" target="_blank" action="<?php echo base_url('personal/reportes/rpt_prom_com')?>">
                                    <input type="hidden" name="fecha_ref" id="fecha_ref">
                                    <input type="hidden" name="empleado" id="empleado"> 
                                    <div id="exportar" style="display: none;">
                                        <button type="submit" class="btn btn-info" id="tipo_reporte" name="tipo_reporte" value="pdf">
                                            <span class="icomoon-icon-file-pdf white"> Exportar a PDF</span>
                                        </button>
                                        <button type="submit" class="btn btn-info" id="tipo_reporte" name="tipo_reporte" value="excel">
                                            <span class="icomoon-icon-file-excel white"> Exportar a Excel</span>
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div> 
        </div>
        <div class="box gradient">
            <div class="title">
                <h4>
                    <span>Detalles</span>
                </h4>
            </div>
            <div class="content noPad clearfix" style="overflow: auto;">
                <div id="contenedor_consulta">
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        $('select').select2();
        var meses = {
            'Enero': '01', 
            'Febrero': '02', 
            'Marzo': '03', 
            'Abril': '04', 
            'Mayo': '05', 
            'Junio': '06', 
            'Julio': '07', 
            'Agosto': '08', 
            'Septiembre': '09', 
            'Octubre': '10',  
            'Noviembre': '11', 
            'Diciembre': '12'
        };

        $(".datePicker").datepicker({
            closeText: 'Seleccionar',
            prevText: '<Ant',
            nextText: 'Sig>',        
            monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
            monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
            changeMonth: true,
            changeYear: true,
            showButtonPanel: true,
            dateFormat: 'MM-yy',
            onClose: function(dateText, inst) {
                $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
            }
        });

        $(".datepicker").mask("mm-yyyy");
        $(".datePicker").focus(function () {
            $(".ui-datepicker-calendar").hide();
            $("#ui-datepicker-div").position({
                my: "center top",
                at: "center bottom",
                of: $(this)
            });
        });

        $("body").on("change", ".slc_stado_emp", function(event){
            var valor_estados = $(this).val();
            $.ajax({
                type: 'POST',
                url: urlj + 'personal/reportes/get_empleado_x_stado',
                data: {
                    estado: valor_estados
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $("#slcEmpleado").html(data);
                    $("#slcEmpleado").select2({placeholder: "Seleccione"});
                    wait.close();
                },
                error: function (xhr, status, error) {
                    wait.close();
                    console.log(xhr);
                    console.log(status);
                    console.log(error);
                    crear_alerta('error', 'Error', 'Hubo un problema al realizar la operación');
                }
            });
        });

        $("#ver_detalle").click(function (event){
            $("#exportar").hide();
            var txt_mes = $("#txt_mes").val();
            var emplado = $("#slcEmpleado").val();
            if (txt_mes == "") {
                crear_alerta('error', 'Período', 'Favor seleccionar un período');
                return false;
            }
            var fecha = txt_mes.split('-');
            var mes = meses[fecha[0]];
            var fecha_ini = fecha[1] + '-' + mes + '-01';
            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: urlj + 'personal/reportes/rpt_prom_com/1',
                data: {
                    tipo_reporte: "", 
                    fecha_ref: fecha_ini, 
                    empleado: emplado
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $("#contenedor_consulta").html(data.tabla);
                    if (data.filas > 0) {
                       $("#fecha_ref").val(fecha_ini);
                       $("#empleado").val(emplado);
                       $("#exportar").show();
                    }
                    wait.close();
                },
                error: function (xhr, status, error) {
                    wait.close();
                    crear_alerta('error', 'Error', 'Se interrumpio debido a un problema al realizar la operación');
                }
            });
        });
    });
</script>
<!-- <script type="text/javascript" src="<?php echo base_url(); ?>js/personal/rpt_ingresos_mensuales.js"></script> -->