<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if (isset($excel)) {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>
<style type="text/css">
    .tabla {
        font-weight: normal !important;
        font-family: 'Arial';
        border: 1px solid black;
    }

    .tabla th {
        border: 1px solid black;
        vertical-align: middle;
        text-align: center;
    }

    .tabla td {
        border: 1px solid black;
        vertical-align: middle;
        text-align: center;
    }

    .num {
        mso-number-format: General;
    }

    .text {
        mso-number-format: "\@";
    }
</style>

<?php
if ($excel != 1) {
    echo $header;
    $size = '10px';
} else {
    $size = '10px';
?>
    <table style="font-size:14px; text-align:center;">
        <tr>
            <td colspan="6" style="font-weight:bold;text-align:center;"><?php echo $titulo; ?></td>
        </tr>
        <?php if (isset($subtitulo)) : ?>
            <tr>
                <td colspan="6" style="font-weight:bold;text-align:center;"><?php echo $subtitulo; ?></td>
            </tr>
        <?php endif ?>
    </table>
    <br>
<?php
}
?>
<br>
<table class="responsive table table-bordered" border="1" cellpadding="3" style="font-size:<?= $size ?>">
    <thead>
        <tr nobr="true">
            <th width="4%" style="font-weight:bold;">N°</th>
            <th width="7%" style="font-weight:bold;">Código</th>
            <th width="32%" style="font-weight:bold;">Empleada/o</th>
            <th width="24%" style="font-weight:bold;">Nombre Descuento</th>
            <th width="11%" style="font-weight:bold;">Ingreso</th>
            <th width="11%" style="font-weight:bold;">Ingreso Afecto</th>
            <th width="11%" style="font-weight:bold;">Descuento Laboral</th>
        </tr>
    </thead>
    <tbody>
        <?php
        if (count($registros) > 0) {
            $i = 1;
            $total_ingreso = 0;
            $total_afecto = 0;
            $total_descuento = 0;
            foreach ($registros as $fila) {
        ?>
                <tr nobr="true">
                    <td width="4%"><?php echo $i; ?></td>
                    <td width="7%" style="text-align:left;"><?php echo $fila['emp_codigo']; ?></td>
                    <td width="32%" style="text-align:left;"><?php echo $fila['nombre']; ?></td>
                    <td width="24%" style="text-align:left;"><?php echo $fila['name_dsc']; ?></td>
                    <td width="11%" style="text-align:right;"><?= $simbolo ?><?php echo number_format($fila['ingreso'], 2, '.', ','); ?></td>
                    <td width="11%" style="text-align:right;"><?= $simbolo ?><?php echo number_format($fila['afecto'], 2, '.', ','); ?></td>
                    <td width="11%" style="text-align:right;"><?= $simbolo ?><?php echo number_format($fila['descuento'], 2, '.', ','); ?></td>
                </tr>
            <?php
                $i++;
                $total_ingreso += number_format($fila['ingreso'], 2, '.', '');
                $total_afecto += number_format($fila['afecto'], 2, '.', '');
                $total_descuento += number_format($fila['descuento'], 2, '.', '');
            }
            ?>
            <tr>
                <td colspan="6" style="font-weight:bold;text-align:right;"><b>Total Descuentos</b></td>
                <!-- <td style="font-weight:bold;text-align:right;"><b><?php echo number_format($total_ingreso, 2, '.', ','); ?></b></td> -->
                <!-- <td style="font-weight:bold;text-align:right;"><b><?php echo number_format($total_afecto, 2, '.', ','); ?></b></td> -->
                <td style="font-weight:bold;text-align:right;"><b><?= $simbolo ?><?php echo number_format($total_descuento, 2, '.', ','); ?></b></td>
            </tr>
        <?php
        } else {
        ?>
            <tr>
                <td colspan="7" style="text-align:center;">No se encontraron registros</td>
            </tr>
        <?php
        }
        ?>
    </tbody>
</table>