<?php
if ($es_excel) {
	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	header("content-disposition: attachment;filename=revision_isss.xls");
	header("Pragma: no-cache");
	header("Expires: 0");
}
$i = 0;
$tot_salario = 0;
$tot_adicion = 0;
$tot_vac_dia = 0;
$tot_vac_prm = 0;
$iss_patrono = 0;
$iss_emplead = 0;
$sal_min = $this->gsatelite->get_parametro('MONTO_SALARIO_MINIMO');
?>
<style type="text/css">
	.text{
		mso-number-format:"\@";/*force text*/
	}
</style>
<meta charset="utf-8" />
<table border="0" id="tabla_resultados" cellpadding="1" >
	<thead>
		<tr>
			<th <?= ($es_excel) ? '' : 'width="65%"'; ?> colspan="9" height="20px"><h2><?php echo $this->gsatelite->get_parametro('SYS_EMPRESA'); ?></h2></th>
			<th <?= ($es_excel) ? '' : 'width="35%"'; ?> colspan="4" style="text-align: right; font-size: 8pt; font-weight: bold;"><?php echo $this->gsatelite->get_parametro('SYS_DEPARTAMENTO') . ', ' . date('d-m-Y H:i:s a'); ?></th>
		</tr>
		<tr >
			<th colspan="9" height="15px" style="font-size:10pt">Planilla de revisión para el pago mensual al Seguro Social</th>
			<th colspan="4" style="text-align: right;"></th>
		</tr>
		<tr>
			<th colspan="13" style="border-bottom: solid 1px black;">Período de pago: <?php echo $periodo_text ?></th>
		</tr>
		<tr>
			<th <?= ($es_excel) ? '' : 'width="4%"'; ?> style="border-bottom: solid 1px black;">Corr.</th>
			<th <?= ($es_excel) ? '' : 'width="6%"'; ?> style="border-bottom: solid 1px black;">Tipo Doc.</th>
			<th <?= ($es_excel) ? '' : 'width="8%"'; ?> style="border-bottom: solid 1px black;">Número</th>
			<th <?= ($es_excel) ? '' : 'width="6%"'; ?> style="border-bottom: solid 1px black;">Código</th>
			<th <?= ($es_excel) ? '' : 'width="20%"'; ?> style="border-bottom: solid 1px black;">Nombre del Empleada/o</th>
			<th <?= ($es_excel) ? '' : 'width="4%"'; ?> style="border-bottom: solid 1px black; text-align: center;">Días Trab.</th>
			<th <?= ($es_excel) ? '' : 'width="8%"'; ?> style="border-bottom: solid 1px black;">Salario Devengado</th>
			<th <?= ($es_excel) ? '' : 'width="8%"'; ?> style="border-bottom: solid 1px black; text-align: center;">Pagos Adicionales</th>
			<th <?= ($es_excel) ? '' : 'width="8%"'; ?> style="border-bottom: solid 1px black; text-align: center;">Porc. Vacaciones</th>
			<th <?= ($es_excel) ? '' : 'width="8%"'; ?> style="border-bottom: solid 1px black; text-align: center;">Días Vacaciones</th>
			<th <?= ($es_excel) ? '' : 'width="8%"'; ?> style="border-bottom: solid 1px black; text-align: center;">INSS Empleador</th>
			<th <?= ($es_excel) ? '' : 'width="8%"'; ?> style="border-bottom: solid 1px black; text-align: center;">ISSS Empleada/o</th>
			<th <?= ($es_excel) ? '' : 'width="4%"'; ?> style="border-bottom: solid 1px black; text-align: center;">Cód Obs.</th>
		</tr>
	</thead>
	<tbody>
		<?php
		if (count($consulta) > 0) {
			foreach ($consulta as $key => $fila) {
				$i++;
				$dias = (floor($fila['dias_trabajados']) > $max_dias) ? $max_dias :  floor($fila['dias_trabajados']);
				if ($fila['permiso_sin_goce'] > 0) {
					$dias = $dias - $fila['permiso_sin_goce'];
				}
				if ($fila['incapacidades'] > 0) {
					$dias = $dias - $fila['incapacidades'];
				}
				$tot_salario += number_format($fila['salario'],2,'.','');
				$tot_adicion += number_format($fila['adicional'],2,'.','');
				$tot_vac_dia += number_format($fila['vacaciones'],2,'.','');
				$tot_vac_prm += number_format($fila['prima_vacaciones'],2,'.','');
				$iss_patrono += number_format($fila['total_patronal'],2,'.','');
				$iss_emplead += number_format($fila['total_valor'],2,'.','');				
				$obs_codigo = 0;//SIN CAMBIOS
				if (formatear_fecha('Ymd', $fila['emp_fecha_contrato']) >= formatear_fecha('Ymd', $fecha_ini) && formatear_fecha('Ymd', $fila['emp_fecha_contrato']) <= formatear_fecha('Ymd', $fecha_fin) && trim($fila['emp_fecha_retiro']) == '' ) {
					$obs_codigo = 7; //ENTRO A LA EMPRESA EN ESE PERIODO
				} elseif (trim($fila['emp_fecha_retiro']) != '' && formatear_fecha('Ymd', $fila['emp_fecha_retiro']) >= formatear_fecha('Ymd', $fecha_ini) && formatear_fecha('Ymd', $fila['emp_fecha_retiro']) <= formatear_fecha('Ymd', $fecha_fin)) {
					$obs_codigo = 6; //RETIRO DE LA EMPRESA EN ESE PERIODO
				} elseif ($fila['incapacidades'] > 0) {
					$obs_codigo = 5; //INCAPACIDADES
				} elseif ($fila['total_ingreso_afecto'] < $sal_min) {
					$obs_codigo = 2; //APRENDICES   SALARIO MENOR AL MINIMO
				} elseif ($fila['emp_es_jubilado'] > 0) {
					$obs_codigo = 3;
				} elseif ($fila['adicional'] > 0 && $fila['vacaciones'] == 0 && $fila['prima_vacaciones'] == 0) {
					$obs_codigo = 1; //SI SOLAMENTE POSEE PAGOS ADICIONALES MAS EL SALARIO
				} elseif ($fila['adicional'] == 0 && ($fila['vacaciones'] > 0 || $fila['prima_vacaciones'] > 0)) {
					$obs_codigo = 8; //SI SOLAMENTE POSEE PAGOS POR VACACION / PRIMA VACACION MAS EL SALARIO
				} elseif ($fila['adicional'] > 0 && $fila['vacaciones'] > 0 && $fila['prima_vacaciones'] > 0) {//////////CAMBIAR  SI POSEE PAGOS POR VACACION Y PAGOS ADICIONALES
					$obs_codigo = 9;
				}
				// PENDIENTES DE MOMENTO CODIGOS DEL 10 EN ADELANTE QUE SON TRABAJADORES INDEPENDIENTES O SALARIO MIXTO
				?>
				<tr nobr="true" style="text-align:left;">
					<td <?= ($es_excel) ? '' : 'width="4%"'; ?>><?php echo $i; ?></td>
					<td <?= ($es_excel) ? '' : 'width="6%"'; ?>><?php echo ($fila['emp_seguro'] != "") ? 'T. de Afil.' : 'DUI'; ?></td>
					<td <?= ($es_excel) ? '' : 'width="8%"'; ?>><?php echo ($fila['emp_seguro'] != "") ? $fila['emp_seguro'] : $fila['dui']; ?></td>
					<td <?= ($es_excel) ? '' : 'width="6%"'; ?>><?php echo $fila['emp_codigo']; ?></td><!-- 25 -->
					<td <?= ($es_excel) ? '' : 'width="20%"'; ?> ><?php echo trim($fila['emp_nombre']) . ' ' . trim($fila['emp_apellido']); ?></td>
					<td <?= ($es_excel) ? '' : 'width="4%"'; ?> style="text-align: right;"><?php echo $dias; ?></td>
					<td <?= ($es_excel) ? '' : 'width="8%"'; ?> style="text-align: right;"><?php echo number_format($fila['salario'], 2); ?></td>
					<td <?= ($es_excel) ? '' : 'width="8%"'; ?> style="text-align: right;"><?php echo number_format($fila['adicional'], 2); ?></td>
					<td <?= ($es_excel) ? '' : 'width="8%"'; ?> style="text-align: right;"><?php echo number_format($fila['prima_vacaciones'], 2); ?></td>
					<td <?= ($es_excel) ? '' : 'width="8%"'; ?> style="text-align: right;"><?php echo number_format($fila['vacaciones'], 2); ?></td>
					<td <?= ($es_excel) ? '' : 'width="8%"'; ?> style="text-align: right;"><?php echo number_format($fila['total_patronal'], 2); ?></td>
					<td <?= ($es_excel) ? '' : 'width="8%"'; ?> style="text-align: right;"><?php echo number_format($fila['total_valor'], 2); ?></td>
					<td <?= ($es_excel) ? '' : 'width="4%"'; ?> style="text-align: center;"><?php echo ($obs_codigo > 0) ? $obs_codigo : ""; ?></td>
				</tr>
				<?php
			} ?>			
			<tr>
				<th colspan="6" style="border-top: double 1px black;"></th>
				<th style="border-top: double 1px black; text-align: right; font-weight: bold;"><?php echo number_format($tot_salario, 2) ?></th>
				<th style="border-top: double 1px black; text-align: right;"><?php echo number_format($tot_adicion, 2) ?></th>
				<th style="border-top: double 1px black; text-align: right;"><?php echo number_format($tot_vac_prm, 2) ?></th>
				<th style="border-top: double 1px black; text-align: right;"><?php echo number_format($tot_vac_dia, 2) ?></th>
				<th style="border-top: double 1px black; text-align: right; font-weight: bold;"><?php echo number_format($iss_patrono, 2) ?></th>
				<th style="border-top: double 1px black; text-align: right; font-weight: bold;"><?php echo number_format($iss_emplead, 2) ?></th>
				<th style="border-top: double 1px black;"></th>
			</tr>
			<?php
		} else {
			?>
			<tr>
				<td colspan="13" style="text-align: center; font-weight: bold;">Sin Registros</td>
			</tr>
			<?php 
		} ?>
	</tbody>
</table>
