<?php
if ($es_excel) {
	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	header("content-disposition: attachment;filename=revision_afp.xls");
	header("Pragma: no-cache");
	header("Expires: 0");
}
$femeninos = $this->gsatelite->get_tabla('gen_genero', array('gen_nombre LIKE "F%"' => null));
$id_gen = (count($femeninos) > 0) ? array_column($femeninos, 'gen_id') : array(0);
$edades= array('FEMENINO' => 55, 'MASCULINO' => 60);
$sal_min = $this->gsatelite->get_parametro('MONTO_SALARIO_MINIMO');
?>
<style type="text/css">
	.lef {
		border-left: solid 1px black;
	}
	.rig {
		border-right: solid 1px black;
	}
	.text{
		mso-number-format:"\@";/*force text*/
	}
</style>
<meta charset="utf-8" />
<?php 
if (count($consulta) > 0) {
	$afp_actual = $consulta[0]['afp_id'];
	$are_actual = $consulta[0]['emp_id_are'];
	$nom_afp_actual = $consulta[0]['afp_nombre'];
	$nom_are_actual = $consulta[0]['area_nombre'];
	$personas = $salarios = 0;
	$personas_afp = $salarios_afp = 0;
	$total_personas = $total_salarios = 0;
	?>
	<table border="0" id="tabla_resultados" cellpadding="1" >
		<thead>
			<tr>
				<th <?= ($es_excel) ? '' : 'width="65%"'; ?> colspan="5" height="20px"><h2><?php echo $this->gsatelite->get_parametro('SYS_EMPRESA'); ?></h2></th>
				<th <?= ($es_excel) ? '' : 'width="35%"'; ?> colspan="10" style="text-align: right; font-size: 8pt; font-weight: bold;"><?php echo $this->gsatelite->get_parametro('SYS_DEPARTAMENTO') . ', ' . date('d-m-Y h:i:s a'); ?></th>
			</tr>
			<tr style="font-size:10pt" >
				<th colspan="6" height="15px">Planilla de revisión para el pago mensual de AFPs </th>
				<th colspan="9" style="text-align: right;"></th>
			</tr>
			<tr >
				<th colspan="15" style="border-bottom: solid 1px black;"><h3>AFP: <?php echo $nom_afp_actual ?></h3></th>
			</tr>
			<tr>
				<th <?= ($es_excel) ? '' : 'width="9%"'; ?> rowspan="2" style="border-bottom: solid 1px black;">Código</th>
				<th <?= ($es_excel) ? '' : 'width="10%"'; ?> rowspan="2" style="border-bottom: solid 1px black;">Tipo Documento</th>
				<th <?= ($es_excel) ? '' : 'width="14%"'; ?> rowspan="2" style="border-bottom: solid 1px black;">Número Documento</th>
				<th <?= ($es_excel) ? '' : 'width="33%"'; ?> rowspan="2" style="border-bottom: solid 1px black;">Nombre</th>
				<th <?= ($es_excel) ? '' : 'width="10%"'; ?> rowspan="2" style="border-bottom: solid 1px black;">Salario Devengado</th>
				<th <?= ($es_excel) ? '' : 'width="6%"'; ?> rowspan="2" style="border-bottom: solid 1px black;">Días</th>
				<th <?= ($es_excel) ? '' : 'width="18%"'; ?> colspan="9" style="text-align: center;">Código de Observación</th>
			</tr>
			<tr>
				<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">1</th>
				<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">2</th>
				<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">3</th>
				<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">4</th>
				<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">5</th>
				<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">6</th>
				<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">7</th>
				<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">8</th>
				<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">9</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td colspan="15" style="font-style: italic; font-weight: bold;"><?php echo $nom_are_actual ?></td>
			</tr>
			<?php
			foreach ($consulta as $key => $fila) {
				$dias = (floor($fila['dias_trabajados']) > $max_dias) ? $max_dias :  floor($fila['dias_trabajados']);
				if ($fila['permiso_sin_goce'] > 0) {
					$dias = $dias - $fila['permiso_sin_goce'];
				}
				if ($fila['incapacidades'] > 0) {
					$dias = $dias - $fila['incapacidades'];
				}
				$sex = (in_array($fila['gen_id'], $id_gen)) ? 'FEMENINO' : 'MASCULINO';
				$nacio = new DateTime($fila['emp_fecha_nac']);
				$hoy = new DateTime();
				$annos = $hoy->diff($nacio);
				$obs_codigo = 0;
				if (formatear_fecha('Ymd', $fila['emp_fecha_contrato']) >= formatear_fecha('Ymd', $fecha_ini) && formatear_fecha('Ymd', $fila['emp_fecha_contrato']) <= formatear_fecha('Ymd', $fecha_fin) && trim($fila['emp_fecha_retiro']) == '' ) {
					$obs_codigo = 1;
				} elseif (trim($fila['emp_fecha_retiro']) != '' && formatear_fecha('Ymd', $fila['emp_fecha_retiro']) >= formatear_fecha('Ymd', $fecha_ini) && formatear_fecha('Ymd', $fila['emp_fecha_retiro']) <= formatear_fecha('Ymd', $fecha_fin)) {
					$obs_codigo = 2;
				} elseif ($fila['incapacidades'] > 0) {
					$obs_codigo = 4;
				} elseif ($fila['total_ingreso_afecto'] < $sal_min) {
					$obs_codigo = 5;
				} elseif ($fila['emp_es_jubilado'] > 0) {
					$obs_codigo = 6;
				} elseif ($annos->y >= $edades[$sex] && $fila['emp_es_jubilado'] < 1) {
					$obs_codigo = 7;
				}
				if ($fila['afp_id'] == $afp_actual) {
					if ($fila['emp_id_are'] != $are_actual) {
						$nom_are_actual = $fila['area_nombre'];
						?>
						<tr>
							<td colspan="3" style="text-align: right;">TOTAL DE PERSONAS:&nbsp;</td>
							<td>&nbsp;<?php echo $personas; ?></td>
							<td style="text-align: right;"><?php echo number_format($salarios, 2); ?></td>
							<td colspan="10"></td>
						</tr>
						<tr><td colspan="15"></td></tr>
						<tr nobr="true" style="text-align:left;">
							<td colspan="15" style="font-style: italic; font-weight: bold;"><?php echo $nom_are_actual; ?></td>
						</tr>
						<?php
						$personas_afp += $personas;
						$salarios_afp += $salarios; 
						$personas = $salarios = 0;
						$are_actual = $fila['emp_id_are'];
					}
					$personas++;
					$salarios += number_format($fila['total_ingreso_afecto'],2,'.','');
					?>
					<tr nobr="true" style="text-align:left;">
						<td width="9%"><?php echo $fila['emp_codigo']; ?></td>
						<td width="10%">NUP</td>
						<td width="14%" style="mso-number-format:'0';"><?php echo $fila['emp_afp']; ?></td>
						<td width="33%"><?php echo trim($fila['emp_nombre']) . ' ' . trim($fila['emp_apellido']); ?></td>
						<td width="10%" style="text-align: right;"><?php echo number_format($fila['total_ingreso_afecto'], 2); ?></td>
						<td width="6%" style="text-align: right;"  class="rig"><?php echo $dias; ?></td>
						<td width="2%" style="text-align: center;" class="rig"><?php echo ($obs_codigo == 1) ? "X" : ""; ?></td>
						<td width="2%" style="text-align: center;" class="rig"><?php echo ($obs_codigo == 2) ? "X" : ""; ?></td>
						<td width="2%" style="text-align: center;" class="rig"><?php echo ($obs_codigo == 3) ? "X" : ""; ?></td>
						<td width="2%" style="text-align: center;" class="rig"><?php echo ($obs_codigo == 4) ? "X" : ""; ?></td>
						<td width="2%" style="text-align: center;" class="rig"><?php echo ($obs_codigo == 5) ? "X" : ""; ?></td>
						<td width="2%" style="text-align: center;" class="rig"><?php echo ($obs_codigo == 6) ? "X" : ""; ?></td>
						<td width="2%" style="text-align: center;" class="rig"><?php echo ($obs_codigo == 7) ? "X" : ""; ?></td>
						<td width="2%" style="text-align: center;" class="rig"><?php echo ($obs_codigo == 8) ? "X" : ""; ?></td>
						<td width="2%" style="text-align: center;" class="rig"><?php echo ($obs_codigo == 9) ? "X" : ""; ?></td>
					</tr>
					<?php
				} else {
					?>
							<tr>
								<td colspan="3" style="text-align: right;">TOTAL DE PERSONAS:&nbsp;</td>
								<td>&nbsp;<?php echo $personas; ?></td>
								<td style="text-align: right;"><?php echo number_format($salarios, 2); ?></td>
								<td colspan="10"></td>
							</tr>
							<?php
							$personas_afp += $personas;
							$salarios_afp += $salarios; 
							$personas = $salarios = 0;
							?>
							<tr>
								<th height="15px" colspan="3" style="border-top:solid 1px black;text-align:right;">TOTAL DE PERSONAS AFP <?= strtoupper($nom_afp_actual) ?>:&nbsp;</th>
								<th style="border-top: solid 1px black;">&nbsp;<?php echo $personas_afp; ?></th>
								<th style="border-top: solid 1px black; text-align: right;"><?php echo number_format($salarios_afp, 2) ?></th>
								<th colspan="10" style="border-top: solid 1px black;"></th>
							</tr>
						</tbody>
					</table>
					<?php 
					echo ($es_excel) ? '<br>' : '<br pagebreak="true"/>';
					$afp_actual = $fila['afp_id'];
					$are_actual = $fila['emp_id_are'];
					$nom_afp_actual = $fila['afp_nombre'];
					$nom_are_actual = $fila['area_nombre'];
					$total_personas += $personas_afp;
					$total_salarios += $salarios_afp;
					$personas_afp = $salarios_afp = 0;
					?>
					<table border="0" id="tabla_resultados" style="" >
						<thead>
							<?php if (!$es_excel) { ?>
								<tr>
									<th width="65%" colspan="5" height="20px"><h2><?php echo $this->gsatelite->get_parametro('SYS_EMPRESA'); ?></h2></th>
									<th width="35%" colspan="10" style="text-align: right; font-size: 8pt; font-weight: bold;"><?php echo $this->gsatelite->get_parametro('SYS_DEPARTAMENTO') . ', ' . date('d-m-Y h:i:s a'); ?></th>
								</tr>
								<tr style="font-size:10pt" >
									<th colspan="6" height="15px">Planilla de revisión para el pago mensual de AFPs </th>
									<th colspan="9" style="text-align: right;"></th>
								</tr>
							<?php } ?>
							<tr >
								<th colspan="15" style="border-bottom: solid 1px black;"><h3>AFP: <?php echo $nom_afp_actual ?></h3></th>
							</tr>
							<tr>
								<th <?= ($es_excel) ? '' : 'width="9%"'; ?> rowspan="2" style="border-bottom: solid 1px black;">Código</th>
								<th <?= ($es_excel) ? '' : 'width="10%"'; ?> rowspan="2" style="border-bottom: solid 1px black;">Tipo Documento</th>
								<th <?= ($es_excel) ? '' : 'width="14%"'; ?> rowspan="2" style="border-bottom: solid 1px black;">Número Documento</th>
								<th <?= ($es_excel) ? '' : 'width="33%"'; ?> rowspan="2" style="border-bottom: solid 1px black;">Nombre</th>
								<th <?= ($es_excel) ? '' : 'width="10%"'; ?> rowspan="2" style="border-bottom: solid 1px black;">Salario Devengado</th>
								<th <?= ($es_excel) ? '' : 'width="6%"'; ?> rowspan="2" style="border-bottom: solid 1px black;">Días</th>
								<th <?= ($es_excel) ? '' : 'width="18%"'; ?> colspan="9" style="text-align: center;">Código de Observación</th>
							</tr>
							<tr>
								<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">1</th>
								<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">2</th>
								<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">3</th>
								<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">4</th>
								<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">5</th>
								<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">6</th>
								<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">7</th>
								<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">8</th>
								<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">9</th>
							</tr>
						</thead>
						<tbody>
							<tr nobr="true" style="text-align:left;">
								<td colspan="15" style="font-style: italic; font-weight: bold;"><?php echo $nom_are_actual; ?></td>
							</tr>
							<tr nobr="true" style="text-align:left;">
								<td <?= ($es_excel) ? '' : 'width="9%"'; ?>><?php echo $fila['emp_codigo']; ?></td>
								<td <?= ($es_excel) ? '' : 'width="10%"'; ?>>NUP</td>
								<td <?= ($es_excel) ? '' : 'width="14%"'; ?> style="mso-number-format:'0';"><?php echo $fila['emp_afp']; ?></td>
								<td <?= ($es_excel) ? '' : 'width="33%"'; ?>><?php echo trim($fila['emp_nombre']) . ' ' . trim($fila['emp_apellido']); ?></td>
								<td <?= ($es_excel) ? '' : 'width="10%"'; ?> style="text-align: right;"><?php echo number_format($fila['emp_salario'], 2); ?></td>
								<td <?= ($es_excel) ? '' : 'width="6%"'; ?> style="text-align: right;"><?php echo $dias; ?></td>
								<td <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center;" class="lef rig"><?php echo ($obs_codigo == 1) ? "X" : ""; ?></td>
								<td <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center;" class="rig"><?php echo ($obs_codigo == 2) ? "X" : ""; ?></td>
								<td <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center;" class="rig"><?php echo ($obs_codigo == 3) ? "X" : ""; ?></td>
								<td <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center;" class="rig"><?php echo ($obs_codigo == 4) ? "X" : ""; ?></td>
								<td <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center;" class="rig"><?php echo ($obs_codigo == 5) ? "X" : ""; ?></td>
								<td <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center;" class="rig"><?php echo ($obs_codigo == 6) ? "X" : ""; ?></td>
								<td <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center;" class="rig"><?php echo ($obs_codigo == 7) ? "X" : ""; ?></td>
								<td <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center;" class="rig"><?php echo ($obs_codigo == 8) ? "X" : ""; ?></td>
								<td <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center;" class="rig"><?php echo ($obs_codigo == 9) ? "X" : ""; ?></td>
							</tr>
							<?php
							$personas++;
							$salarios += number_format($fila['total_ingreso_afecto'],2,'.','');
				}
			} ?>
			<tr>
				<td colspan="3" style="text-align: right;">TOTAL DE PERSONAS:&nbsp;</td>
				<td>&nbsp;<?php echo $personas; ?></td>
				<td style="text-align: right;"><?php echo number_format($salarios, 2); ?></td>
				<td colspan="10"></td>
			</tr>
			<?php
			$personas_afp += $personas;
			$salarios_afp += $salarios; 
			$total_personas += $personas_afp;
			$total_salarios += $salarios_afp;
			?>
			<tr>
				<th height="20px" colspan="3" style="border-top:solid 1px black;text-align:right;">TOTAL DE PERSONAS AFP <?= strtoupper($nom_afp_actual) ?>:&nbsp;</th>
				<th style="border-top: solid 1px black;">&nbsp;<?php echo $personas_afp; ?></th>
				<th style="border-top: solid 1px black; text-align: right;"><?php echo number_format($salarios_afp, 2) ?></th>
				<th colspan="10" style="border-top: solid 1px black;"></th>
			</tr>
			<tr>
				<th <?= ($es_excel) ? '' : 'width="33%"'; ?> colspan="3" style="border-top: double 1px black; text-align: right; font-weight: bold;">TOTAL DE PERSONAS:&nbsp;</th>
				<th <?= ($es_excel) ? '' : 'width="30%"'; ?> style="border-top: double 1px black; font-weight: bold;">&nbsp;<?php echo $total_personas; ?></th>
				<th <?= ($es_excel) ? '' : 'width="13%"'; ?> style="border-top: double 1px black; text-align: right; font-weight: bold;"><?php echo number_format($total_salarios, 2) ?></th>
				<th <?= ($es_excel) ? '' : 'width="24%"'; ?> colspan="10" style="border-top: double 1px black;"></th>
			</tr>
		</tbody>
	</table>
	<?php
} else {
	?>
	<table border="0" id="tabla_resultados" cellpadding="1" >
		<thead>
			<tr>
				<th <?= ($es_excel) ? '' : 'width="65%"'; ?> colspan="5" height="20px"><h2><?php echo $this->gsatelite->get_parametro('SYS_EMPRESA'); ?></h2></th>
				<th <?= ($es_excel) ? '' : 'width="35%"'; ?> colspan="10" style="text-align: right; font-size: 8pt; font-weight: bold;"><?php echo $this->gsatelite->get_parametro('SYS_DEPARTAMENTO') . ', ' . date('d-m-Y h:i:s a'); ?></th>
			</tr>
			<tr style="font-size:10pt" >
				<th colspan="6" height="15px">Planilla de revisión para el pago mensual de AFPs </th>
				<th colspan="9" style="text-align: right;"></th>
			</tr>
			<tr>
				<th <?= ($es_excel) ? '' : 'width="9%"'; ?> rowspan="2" style="border-bottom: solid 1px black;">Código</th>
				<th <?= ($es_excel) ? '' : 'width="10%"'; ?> rowspan="2" style="border-bottom: solid 1px black;">Tipo Documento</th>
				<th <?= ($es_excel) ? '' : 'width="14%"'; ?> rowspan="2" style="border-bottom: solid 1px black;">Número Documento</th>
				<th <?= ($es_excel) ? '' : 'width="33%"'; ?> rowspan="2" style="border-bottom: solid 1px black;">Nombre</th>
				<th <?= ($es_excel) ? '' : 'width="10%"'; ?> rowspan="2" style="border-bottom: solid 1px black;">Salario Devengado</th>
				<th <?= ($es_excel) ? '' : 'width="6%"'; ?> rowspan="2" style="border-bottom: solid 1px black;">Días</th>
				<th <?= ($es_excel) ? '' : 'width="18%"'; ?> colspan="9" style="text-align: center;">Código de Observación</th>
			</tr>
			<tr>
				<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">1</th>
				<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">2</th>
				<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">3</th>
				<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">4</th>
				<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">5</th>
				<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">6</th>
				<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">7</th>
				<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">8</th>
				<th <?= ($es_excel) ? '' : 'width="2%"'; ?> style="text-align: center; border: solid 1px black;">9</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td colspan="15" style="text-align: center; font-weight: bold;">Sin Registros</td>
			</tr>
		</tbody>
	</table>
	<?php 
} ?>
