<meta charset="utf-8" />
<script type="text/javascript">
  jQuery(document).ready(function($) {
    $("#accion_botones").hide();
    $("#emp_codigo, #emp_nombre, #emp_apellido, #fecha1, #fecha2").keypress(function(event) {
      key = event.keyCode || event.which;
      if (key == 13) {
        $("#consultar_datos").trigger("click");
      }
    });

    window.gSateliteWhite.jsSelect();
    $("input[name^='fecha']").mask('99-99-9999');
    $("input[name^='fecha']").datepicker({
      dateFormat: 'dd-mm-yy',
      changeMonth: true,
      changeYear: true
    });
    $("#tipo_filtro").change(function(event) {
      mostrarElemento($(this).val());
    });

    $("#consultar_datos").click(function(event) {

      if ($("#tipo_filtro").val() != "" && $("#tipo_filtro").val() != null) {
        tipo = $("#tipo_filtro").val();
        if ($("#" + tipo).is("input")) {
          if ($("#" + tipo).val() != "") {
            consultarAjax(tipo, $("#" + tipo).val());
          } else {
            $("#validar_valor").text('Campo requerido');
          }
        } else {
          if (tipo == 'emp_fecha_contrato') {
            if ($("#fecha1").val() != "" && $("#fecha2").val() != "") {
              var fechas = $("#fecha1").val() + "#" + $("#fecha2").val();
              consultarAjax(tipo, fechas);
            } else {
              $("#validar_valor").text('Campo requerido');
            }
          } else { //es un div con select
            if ($("#select_" + tipo).val() != "") {
              consultarAjax(tipo, $("#select_" + tipo).val());
            } else {
              $("#validar_valor").text('Campo requerido');
            }
          }
        }

      } else {
        $("#validar_filtro").text('Campo requerido');
      }

    });

  });

  function mostrarElemento(id_element) {
    if (id_element != "") {
      id_elemento = id_element;
    } else {
      id_elemento = 'nada';
    }
    var mostrar = "#" + id_elemento;
    var elementos = "#nada,#emp_codigo,#emp_nombre,#emp_apellido,#emp_fecha_contrato,#emp_id_suc,#emp_id_are,#emp_id_pto,#emp_id_gen,#tpl_id";
    var excluir = elementos.replace(mostrar, "#noexiste");
    $(excluir).hide('slow');
    $(mostrar).show('slow');
  }

  function consultarAjax(filtro, valor) {

    wait.start();
    $("#consultar_datos").attr('disabled', 'disabled');
    $("#accion_botones").hide('slow');
    $("#contenedorTabla").hide("slide", {
      direction: 'right'
    }, 400, function() { //despues de ocultar div enviar el ajax
      $.ajax({
        type: 'POST',
        dataType: 'json',
        url: window.gSateliteWhite.baseUrl('personal/reportes/filtro_reporte_empleado'),
        data: {
          'filtro': filtro,
          'valor': valor
        },
        success: function(data) {
          $("#filtro_hidden").val(filtro); //valor que será utilizado para el print y export
          $("#filtro_valor_hidden").val(valor); // valor que será utilizado para el print y export
          $("#contenedorTabla").html(data.resultado);
          wait.close();
          $("#consultar_datos").removeAttr('disabled');
          //  $("#tabla_consulta").dataTable();
          $("#accion_botones").show('slow');
          // $(".edit_ficha").tooltip();
          $("#contenedorTabla").show("slide", {
            direction: 'left'
          }, 500);
        }
      });
    });


  }
</script>
<div class="row-fluid">
  <div class="span12">
    <div class="box">
      <div class="title">
        <h4 style="text-align:center;">FILTRO PARA REPORTE DE EMPLEADAS/OS</h4>
      </div>
      <div class="content">
        <form method="post" id="consultaform" name="consultaform">
          <table class="responsive table table-bordered">
            <thead>
              <tr style="font-size:13px;">
                <th id="tdFiltro" width="32%">Buscar por</th>
                <th>Criterio de Búsqueda</th>
                <th width="25%">&nbsp;</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td style="vertical-align: top !important;">
                  <div>
                    <select name="tipo_filtro" id="tipo_filtro" onchange="$('#validar_filtro').text('');" class="nostyle" style="width:300px;" placeholder="Seleccionar filtro">
                      <option value=""></option>
                      <option value="emp_codigo">Por Código</option>
                      <option value="emp_nombre">Por Nombre</option>
                      <option value="emp_apellido">Por Apellido</option>
                      <option value="emp_fecha_contrato">Por Fecha Contrato</option>
                      <option value="emp_id_suc">Por Sucursal</option>
                      <option value="emp_id_are">Por Departamento</option>
                      <option value="emp_id_pto">Por Puesto</option>
                      <option value="emp_id_gen">Por Género</option>
                      <option value="tpl_id">Por Tipo Planilla</option>
                    </select>
                  </div>
                  <span id="validar_filtro" style="color:red;font-size:11px;"></span>
                </td>
                <td style="vertical-align: top !important;">
                  <div>
                    <input style="width:89%;" id="nada" name="nada" placeholder="Seleccione filtro" readonly type="text">
                  </div>
                  <div>
                    <input style="display:none; width:89%;" onkeyup="$('#validar_valor').text('');" id="emp_codigo" name="emp_codigo" placeholder="Código" type="text">
                    <input style="display:none; width:89%;" onkeyup="$('#validar_valor').text('');" id="emp_nombre" name="emp_nombre" placeholder="Nombres" type="text">
                    <input style="display:none; width:89%;" onkeyup="$('#validar_valor').text('');" id="emp_apellido" name="emp_apellido" placeholder="Apellidos" type="text">
                  </div>
                  <div style="display:none;" id="emp_fecha_contrato">
                    <input id="fecha1" name="fecha1" onchange="$('#validar_valor').text('');" style="width:44%;" placeholder="Fecha desde" type="text">
                    <input id="fecha2" name="fecha2" onchange="$('#validar_valor').text('');" style="width:44%;" placeholder="Fecha hasta" type="text">
                  </div>
                  <div id="emp_id_suc" style="display:none; width:100%;">
                    <select name="select_emp_id_suc" id="select_emp_id_suc" onchange="$('#validar_valor').text('');" class="nostyle" style="width:90%;" placeholder="Seleccione">
                      <option value=""></option>
                      <?php echo  $select_emp_id_suc; ?>
                    </select>
                  </div>
                  <div id="emp_id_are" style="display:none; width:100%;">
                    <select name="select_emp_id_are" id="select_emp_id_are" onchange="$('#validar_valor').text('');" class="nostyle" style="width:90%;" placeholder="Seleccione">
                      <option value=""></option>
                      <?php echo  $select_emp_id_are; ?>
                    </select>
                  </div>
                  <div id="emp_id_pto" style="display:none; width:100%;">
                    <select name="select_emp_id_pto" id="select_emp_id_pto" onchange="$('#validar_valor').text('');" class="nostyle" style="width:90%;" placeholder="Seleccione">
                      <option value=""></option>
                      <?php echo  $select_emp_id_pto; ?>
                    </select>
                  </div>
                  <div id="emp_id_gen" style="display:none; width:100%;">
                    <select name="select_emp_id_gen" id="select_emp_id_gen" onchange="$('#validar_valor').text('');" class="nostyle" style="width:90%;" placeholder="Seleccione">
                      <option value=""></option>
                      <?php echo  $select_emp_id_gen; ?>
                    </select>
                  </div>
                  <div id="tpl_id" style="display:none; width:100%;">
                    <select name="select_tpl_id" id="select_tpl_id" onchange="$('#validar_valor').text('');" class="nostyle" style="width:90%;" placeholder="Seleccione">
                      <option value=""></option>
                      <?php echo  $select_tpl_id; ?>
                    </select>
                  </div>
                  <br>
                  <span id="validar_valor" style="color:red;font-size:11px; position: absolute;top: 70%"></span>
                </td>
                <td style="vertical-align: top !important;">
                  <button class="btn btn-info" type="button" id="consultar_datos">
                    <span class="icomoon-icon-checkmark white"></span>
                    Consultar</button>
                </td>
              </tr>
            </tbody>
          </table>
        </form>

        <div class="box gradient">

          <div class="title">
            <h4>
              <span>Empleadas/os</span>
            </h4>
            <div id="accion_botones" style="float: right;margin-top: -33px; margin-right: 4px;">
              <button onclick="$('#tipo_accion').val('excel'); $('#print_export').submit();" class="btn btn-info" type="button" id="consultar_datos">
                <span class="entypo-icon-export white"></span>
                Exportar</button>
              <button onclick="$('#tipo_accion').val('pdf'); $('#print_export').submit();" class="btn btn-info" type="button" id="consultar_datos">
                <span class="icomoon-icon-printer white"></span>
                Print</button>
            </div>
          </div>
          <div class="content noPad clearfix">
            <form method="post" id="print_export" name="print_export" target="_blank">
              <div id="contenedorTabla" style="overflow-x: scroll;padding-top:1px;padding-left:1px;">
                <?php
                if (isset($html_consulta)) {
                  echo $html_consulta;
                } else {
                ?>
                  <table style="font-size:12px;" class="responsive table table-bordered">
                    <thead>
                      <tr>
                        <th>
                          Código
                        </th>
                        <th>
                          Nombre
                        </th>
                        <th>
                          Apellido
                        </th>
                        <th>
                          Estado Civil
                        </th>
                        <th>
                          Género
                        </th>
                        <th>
                          Dirección
                        </th>
                        <th>
                          Profesión
                        </th>
                        <th>
                          Departamento
                        </th>
                        <th>
                          Puesto
                        </th>
                        <th>
                          Tipo Planilla
                        </th>
                        <th>
                          Documentos
                        </th>
                        <th>
                          Teléfonos
                        </th>
                        <th>
                          AFP
                        </th>
                        <th>
                          Fecha <br /> Contratación
                        </th>
                      </tr>
                    </thead>
                    <tbody>
                      <tr>
                        <td colspan="14" style="text-align:center;">
                          Sin registros
                        </td>
                      </tr>
                    </tbody>
                  </table>
                <?php } ?>
              </div>
          </div>

          <input type="hidden" name="filtro_hidden" id="filtro_hidden" />
          <input type="hidden" name="filtro_valor_hidden" id="filtro_valor_hidden" />
          <input type="hidden" name="tipo_accion" id="tipo_accion" />
          </form>

        </div>
        <!--
<div id="formulario_print_export" >
 <form method="post" id="print_export" name="print_export" target="_blank" >
    <input type="hidden" name="filtro_hidden" id="filtro_hidden" />
    <input type="hidden" name="filtro_valor_hidden" id="filtro_valor_hidden" />
    <input type="hidden" name="tipo_accion" id="tipo_accion" />
</form>
</div> -->


      </div>
    </div>
  </div>
</div>