<style type="text/css">.ui-datepicker-current { display: none; }</style>
<div class="row-fluid">
	<div class="span12">
		<div class="box">
			<div class="title">
				<h4>
					<span>Planilla única previsional</span>
				</h4>
			</div>
			<div class="content">
				<div class="form-row row-fluid">
					<div class="span12">
						<div class="span6">
							<div class="row-fluid">
								<label class="form-label span3">Período <b style="color:red;">*</b></label>
								<div class="span7 controls">
									<input type="text" name="txt_mes" id="txt_mes" class="datePicker" placeholder="mm-yyyy" readonly onchange="$('#txt_mes_error').text('');">
									<input type="hidden" name="hdn_fecha" id="hdn_fecha" value="">
								</div>
							</div>
						</div>
						<div class="span6">
							<div class="row-fluid">
							</div>
						</div>
					</div>
				</div>
				<div class="form-row row-fluid">
					<div class="span12">
						<div class="span6">
							<div class="row-fluid">
								<button id="revision" class="btn btn-success" <?= ($permisos['permite_ver'])?'':'disabled'; ?> >
									<span class="icon16 icomoon-icon-checkmark white"> Mostrar</span>
								</button>
							</div>
						</div>
						<div class="span6">
							<div class="row-fluid">
								<div id="exportar" style="text-align: right;display: none;">
									<form id="frmenviar" method="POST" action="<?php echo base_url('personal/reportes/planilla_unica') ?>" target="_blank">
										<input type="hidden" name="fecha_filtro" id="fecha_filtro" value="">
										<button type="submit" class="btn btn-info" name="tipo_rep" value="pdf"><span class="icomoon-icon-file-pdf"> Generar PDF</span></button>
										<button type="submit" class="btn btn-info" name="tipo_rep" value="exc"><span class="icomoon-icon-file-excel"> Generar EXCEL</span></button>
										<button type="submit" class="btn btn-info" name="tipo_rep" value="csv"><span class=" icomoon-icon-file-xml"> Generar CSV</span></button>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="span12">
		<div class="box">
			<div class="title">
				<h4><span>&nbsp;</span></h4>
			</div>
			<div class="content noPad clearfix" id="dv_contenedor_listado" style="overflow: auto; width: 100%;">
			</div>
		</div>
	</div>
</div>

<script type="text/javascript">
	$(document).ready(function($) {
		var meses = {
			'Enero': '01', 
			'Febrero': '02', 
			'Marzo': '03', 
			'Abril': '04', 
			'Mayo': '05', 
			'Junio': '06', 
			'Julio': '07', 
			'Agosto': '08', 
			'Septiembre': '09', 
			'Octubre': '10',  
			'Noviembre': '11', 
			'Diciembre': '12'
		};

        $(".datePicker").datepicker({
        	closeText: 'Seleccionar',
        	prevText: '<Ant',
        	nextText: 'Sig>',        
        	monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        	monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
        	changeMonth: true,
        	changeYear: true,
        	showButtonPanel: true,
        	dateFormat: 'MM-yy',
        	onClose: function(dateText, inst) {
        		$(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
        		set_fecha();
        	}
        });

        $(".datepicker").mask("mm-yyyy");

        $(".datePicker").focus(function () {
        	$(".ui-datepicker-calendar").hide();
        	$("#ui-datepicker-div").position({
        		my: "center top",
        		at: "center bottom",
        		of: $(this)
        	});
        });

        $("#frmenviar").validate({
        	ignore: ".select2-container",
        	submitHandler: function (form) {
        		var fechaSend = $("#hdn_fecha_filtro").val();
        		if (fechaSend != ""){
        			form.submit();
        		} else {
        			crear_alerta('error', "Verifique los campos requeridos");
        			return false;
        		}
        	}
        });

        function set_fecha() {
        	var txt_mes = $("#txt_mes").val();            
            var fecha = txt_mes.split('-');
            var mes = meses[fecha[0]];
            var fecha_ini = fecha[1] + '-' + mes + '-01';
        	$("#hdn_fecha").val(fecha_ini);
        }

        $("#revision").click(function(e) {
        	e.preventDefault();
        	$('#exportar').hide();
        	var fecha = $("#hdn_fecha").val();
        	if (fecha != "") {
        		$.ajax({
        			url: urlj + "personal/reportes/planilla_unica/1",
        			type: 'POST',
        			dataType: 'json',
        			data: {
        				fecha_filtro: fecha,
        				tipo_rep: ""
        			},
        			beforeSend: function () {
        				wait.start();
        			},
        			error: function (xhr, status, error){
        				exportarError(xhr.responseText);
        				wait.close();
        			},
        			success: function (data) {
        				$('#dv_contenedor_listado').html(data.html);
        				if (data.filas >0) {
        					$('#exportar').show();
        					$('#fecha_filtro').val(fecha);
        				}
        				wait.close();
        			}
        		});
        	} else {
        		crear_alerta('error', "Verifique los campos requeridos");
        		return false;
        	}
        });

	});
</script>

