<?php
$femeninos = $this->gsatelite->get_tabla('gen_genero', array('gen_nombre LIKE "F%"' => null));
$id_gen = (count($femeninos) > 0) ? array_column($femeninos, 'gen_id') : array(0);
$edades= array('FEMENINO' => 55, 'MASCULINO' => 60);
$sal_min = $this->gsatelite->get_parametro('MONTO_SALARIO_MINIMO');
$es_alcaldia = (substr_count(mb_strtolower($this->gsatelite->get_parametro_emp('SYS_EMPRESA'),'UTF-8'),'municipal') > 0) ? 1 : 0;
?>
<style type="text/css">
	.num {
		mso-number-format:General;
	}
	.text{
		mso-number-format:"\@";/*force text*/
	}
</style>
<meta charset="utf-8" />
<?php if(isset($titulo_reporte_excel)) { echo $titulo_reporte_excel; } ?>
<table border="1" id="tabla_resultados" class="responsive table table-striped table-bordered table-condensed">
	<tr style="font-weight:bold;background-color:#D6D2D2;font-size:15px" >
		<th>PlanillaPeriodoDevengue</th>	
		<th>PlanillaCodigosObservacion</th>	
		<th>PlanillaIngresoBaseCotizacion</th>	
		<th>PlanillaHorasJornadaLaboral</th>	
		<th>PlanillaDiasCotizados</th>
		<th>PlanillaCotizacionVoluntariaAfiliado</th>	
		<th>PlanillaCotizacionVoluntariaEmpleador</th>
		<th>Nup</th>
		<th>InstitucionPrevisional</th>
		<th>PrimerNombre</th>
		<th>SegundoNombre</th>
		<th>PrimerApellido</th>
		<th>SegundoApellido</th>
		<th>ApellidoCasada</th>
		<th>ConocidoPor</th>
		<th>TipoDocumento</th>
		<th>NumeroDocumento</th>
		<th>Nit</th>
		<th>NumeroIsss</th>
		<th>NumeroInpep</th>
		<th>Genero</th>
		<th>Nacionalidad</th>
		<th>SalarioNominal</th>
		<th>PuestoTrabajo</th>
		<th>FechaNacimiento</th>
		<th>EstadoCivil</th>
		<th>Direccion</th>
		<th>Departamento</th>
		<th>Municipio</th>
		<th>NumeroTelefonico</th>
		<th>CorreoElectronico</th>
		<th>TipoEmpleado</th>
		<th>FechaIngreso</th>
		<th>FechaRetiro</th>
		<th>FechaFallecimiento</th>
	</tr>
	<?php foreach ($consulta as $fila) {
		// NOMBRE Y APELLIDOS
		$nomb = explode(" ", str_replace("  ", " ", trim($fila['emp_nombre'])), 3);
		$ape = explode(" ",  str_replace("  ", " ", trim($fila['emp_apellido'])), 3);
		if (isset($nomb[1])) {
			if (isset($nomb[2]) && strlen(trim($nomb[1])) < 4) {
				$nombre2 = $nomb[1] . " " . $nomb[2];
			} else {
				$nombre2 = $nomb[1];
			}
		} else {
			$nombre2 = "";
		}
		
		// EDAD Y GENERO
		$sex = (in_array($fila['gen_id'], $id_gen)) ? 'FEMENINO' : 'MASCULINO';
		$nacio = new DateTime($fila['emp_fecha_nac']);
		$hoy = new DateTime();
		$annos = $hoy->diff($nacio);
		// INCAPACIDADES
		$dias = (floor($fila['dias_trabajados']) > $max_dias) ? $max_dias :  floor($fila['dias_trabajados']);
		if ($fila['permiso_sin_goce'] > 0) {
			// SE DESCUENTAN LOS PERMISOS SIN GOCE DE SUELDO
			$dias = $dias - $fila['permiso_sin_goce'];
		}
		if ($fila['incapacidades'] > 0) {
			// DE LAS INCAPACIDADES GRANDES LOS 3 PRIMEROS DIAS LOS PAGA LA EMPRESA PERO YA VIENE DESCONTADO EN LA QUERY
			$dias = $dias - $fila['incapacidades'];
		}

		// CODIGOS DE OBSERVACIONES
		/* PDTE: CODIGO 3 LICENCIA / Cuando el trabajador reporta licencia no remunerada. Si el trabajador estuvo todo el mes que se declara o parte de él en licencia sin goce de sueldo. */
		if (formatear_fecha('Ymd', $fila['emp_fecha_contrato']) >= formatear_fecha('Ymd', $fecha_ini) && formatear_fecha('Ymd', $fila['emp_fecha_contrato']) <= formatear_fecha('Ymd', $fecha_fin) && trim($fila['emp_fecha_retiro']) == '' ) {
			// CODIGO 1 INGRESO / Cuando ingresa a laborar, independientemente de la Institución en la que este afiliado, Se debe usar en la planilla del primer mes de devengue
			$obs_codigo = "1";
		} elseif (trim($fila['emp_fecha_retiro']) != '' && formatear_fecha('Ymd', $fila['emp_fecha_retiro']) >= formatear_fecha('Ymd', $fecha_ini) && formatear_fecha('Ymd', $fila['emp_fecha_retiro']) <= formatear_fecha('Ymd', $fecha_fin)) {
			// CODIGO 2 RETIRO / Cuando deja de laborar. Se debe usar en la planilla del último devengue que aún se reporte salario. No presentar planillas con código 2 y el salario cero.
			$obs_codigo = "2";
		} elseif ($fila['incapacidades'] > 0) {
			// CODIGO 4 INCAPACIDAD / Cuando el ISSS determine un período de incapacidad, incluyendo el período de licencia por maternidad (tabla inc_incapacidad)
			$obs_codigo = "4";
		} elseif ($fila['total_ingreso_afecto'] < $sal_min) {
			// CODIGO 5 APRENDIZ / Recibe una remuneración base menor al salario mínimo. Si un trabajador labora a medio tiempo o menos de ocho horas también se le debe colocar este código
			$obs_codigo = "5";
		} elseif ($fila['emp_es_jubilado'] > 0) {
			// CODIGO 6 PENSIONADO O TRABAJADOR COTIZANTE QUE YA RECIBIO DEVOLUCIÓN DE SALDO POR VEJEZ
			$obs_codigo = "6";
		} elseif ($annos->y >= $edades[$sex] && $fila['emp_es_jubilado'] < 1) {
			// CODIGO 7 CON EDAD LEGAL DE VEJEZ / Cuando el trabajador continúe laborando a pesar de registrar la edad legal de vejez, sin ser pensionado o haber recibido devolución de saldo.
			$obs_codigo = "7";
		} else {
			$obs_codigo = "";
		}
		?>
		<tr style="text-align:left;">
			<td class="text"><?php echo formatear_fecha("Ym", $fila['pla_fecha_inicio']); //Planilla Periodo Devengue ?></td>
			<td class="text"><?php echo $obs_codigo; //Planilla Codigos Observacion ?></td>
			<td><?php echo number_format($fila['total_ingreso_afecto'], 2, '.', ''); ?></td><!-- Planilla Ingreso Base Cotizacion -->
			<td><?php echo $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA'); ?></td><!-- Planilla Horas Jornada Laboral -->
			<td><?php echo $dias; //cantidad de dias entre la fecha inicio y la fecha fin ?></td>
			<td><?php echo '0';//$fila['']; ?></td><!-- PlanillaCotizacionVoluntariaAfiliado -->
			<td><?php echo '0';//$fila['']; ?></td><!-- PlanillaCotizacionVoluntariaEmpleador -->
			<td style="mso-number-format:'0';"><?php echo $fila['emp_afp']; ?></td>
			<td><?php echo $fila['afp_codigo'] ;?></td>
			<td><?php echo (isset($nomb[0])) ? $nomb[0] : ''; ?></td>
			<td><?php echo $nombre2; ?></td>
			<td><?php echo (isset($ape[0])) ? $ape[0] : ''; ?></td>
			<td><?php echo (count($ape)==2) ? $ape[1] : ''; ?></td>
			<td><?php echo (count($ape)==3) ? $ape[2] : ''; ?></td>
			<td><!-- conocido por --></td>
			<td><?php echo $tipo_doc; ?></td>
			<td class="text"><?php echo $fila['dui']; ?></td>
			<td class="text"><?php echo $fila['nit']; ?></td>
			<td class="text"><?php echo $fila['emp_seguro']; ?></td>
			<td><!-- Numero Inpep --></td>
			<td><?php echo substr($fila['gen_nombre'],0,1); ?></td>
			<td class="text"><?php echo (trim($fila['pai_codigo']) != "") ? $fila['pai_codigo'] : '222'; ?></td><!-- 222 ES EL CODIGO DE EL SALVADOR EN EL MANUAL DE ELABORAR SEPP -->
			<td><?php echo number_format($fila['emp_salario'], 2, '.', ''); ?></td>
			<td><?php echo $fila['plz_nombre']; ?></td>
			<td><?php echo formatear_fecha('d/m/Y', $fila['emp_fecha_nac']); ?></td>
			<td><?php echo substr($fila['esc_nombre'],0,1); ?></td>
			<td><?php echo $fila['emp_direccion']; ?></td>
			<td class="text"><?php echo $fila['dep_codigo']; ?></td>
			<td class="text"><?php echo str_pad($fila['mun_codigo'], 4, "0", STR_PAD_LEFT); ?></td> 
			<td class="text"><?php echo str_replace('-', '', $fila['telefono']); ?></td>
			<td><?php echo $fila['correo']; ?></td>
			<td><?php echo ($es_alcaldia > 0) ? 'PA' : 'P';//$fila['']; ?></td><!-- PA=PUBLICO_ADMINISTRATIVO / P=PRIVADO -->
			<td><?php echo formatear_fecha('d/m/Y', $fila['emp_fecha_contrato']); ?></td>
			<td><?php echo formatear_fecha('d/m/Y', $fila['emp_fecha_retiro']); ?></td>
			<td></td>
		</tr>
		<?php 
	}
	if(count($consulta)<=0 and isset($esreporte)) { ?>
		<tr>
			<td colspan="9" style="text-align: center;">Sin Registros</td>
		</tr>
		<?php 
	}  ?>
</table>