<meta charset="utf-8" />
<?php if (isset($titulo_reporte_excel)) {
	echo $titulo_reporte_excel;
} ?>
<table border="1" id="tabla_resultados_NO" class="responsive table table-striped table-bordered table-condensed">
	<thead>
		<tr style="font-weight:bold;">
			<th width="15%">PLANILLA</th>
			<th width="10%">FECHA INGRESO</th>
			<th width="15%">AREA</th>
			<th width="10%">DUI</th>
			<th width="20%">NOMBRE</th>
			<th width="10%">SALARIO BASE</th>
			<th width="10%">AÑOS TRABAJADOS</th>
			<th width="10%">AGUINALDO</th>
		</tr>
	</thead>
	<tbody>
		<?php
		$areas_procesados = array(0);
		$sumatoria_salario = $sumatoria_salario_total = $sumatoria_years = $sumatoria_aguinaldo = $sumatoria_years_total = $sumatoria_aguinaldo_total = 0;
		$j = 0;
		$area_inicial = (count($consulta) > 0) ? $consulta[0]['emp_id_are'] : 0;
		foreach ($consulta as $fila) {
			//extraer todos los datos del empleado
			$datos_empleado = $this->planilla_model->get_empleados_reporte(array('emp_id' => $fila['ddi_id_emp']));
			$empleado = $datos_empleado[0];
			//extraer el dui y el nit del empleado
			$dui = '-';
			$doc = explode(',', $empleado['documentos_empleado']);
			for ($y = 0; $y < count($doc); $y++) {
				if (substr_count(strtolower($doc[$y]), 'dui') > 0) {
					$dui_ = explode('(', $doc[$y]);
					$dui = $dui_[0];
				}
			}
			$aguinaldo = $years_aguinaldo = '-';
			$aguinaldo = $fila['ddi_valor'];
			//se calculará el numero de años dependiendo la fecha del registro del detalle de ingreso
			$fecha1 = ($fila['emp_fecha_contrato']) ? date('Y-m-d', strtotime($fila['emp_fecha_contrato'])) : null;
			$fecha2 = ($fila['ddi_fecha_mod']) ? date('Y-m-d', strtotime($fila['ddi_fecha_mod'])) : null;
			$years_aguinaldo = $this->gsatelite->get_intervalo_dias($fecha1, $fecha2);
			// echo $aguinaldo; die();
			$years_aguinaldo = round(($years_aguinaldo / 360), 2);
			$s_aguinaldo = str_replace('-', '0', $aguinaldo);
			$s_years_aguinaldo = $years_aguinaldo; //calcular los años
			$sumatoria_aguinaldo_total += $s_aguinaldo;
			$sumatoria_years_total += $s_years_aguinaldo;
			$sumatoria_salario_total += $fila['emp_salario'];
			$tr_subtotalizacion = "";
			if ($area_inicial == $fila['emp_id_are']) {
				$sumatoria_aguinaldo += $s_aguinaldo;
				$sumatoria_years += $s_years_aguinaldo;
				$sumatoria_salario += $fila['emp_salario'];
				$area_inicial = $fila['emp_id_are'];
			} else {
				$sumatoria_aguinaldo = $s_aguinaldo;
				$sumatoria_years = $s_years_aguinaldo;
				$sumatoria_salario = $fila['emp_salario'];
				$area_inicial = $fila['emp_id_are'];
			}
			$nombre_area = $fila['are_nombre'];
			if (count($consulta) != ($j + 1)) {
				//que no sea el ultimo para adelantar la posición siguiente
				if ($consulta[($j + 1)]['emp_id_are'] != $fila['emp_id_are']) {
					//crear el tr del subtotal y al final crear una fila en blanco
					if (!$es_excel) {
						$tr_subtotalizacion = '<tr>
		 				<td colspan="5" align="right" ><b>TOTAL ' . mb_strtoupper($nombre_area, 'UTF-8') . '</b></td>
		 				<td align="right" style="font-weight:bold;">' . $simbolo . number_format($sumatoria_salario, 2) . ' </td>
		 				<td align="right"  style="font-weight:bold;"> ' . number_format($sumatoria_years, 2) . '  </td>
		 				<td align="right" style="font-weight:bold;"> ' . $simbolo . number_format($sumatoria_aguinaldo, 2) . '  </td>
		 				</tr><tr><td colspan="8"></td></tr>';
					}
				}
			} else {
				//si es el ultimo registro imprimir la totalización del area final
				if (!$es_excel) {
					$tr_subtotalizacion = '<tr>
		 			<td colspan="5" align="right" ><b>TOTAL ' . mb_strtoupper($nombre_area, 'UTF-8') . '</b></td>
		 			<td align="right" style="font-weight:bold;" > ' . $simbolo . number_format($sumatoria_salario, 2) . ' </td>
		 			<td align="right"  style="font-weight:bold;"> ' . number_format($sumatoria_years, 2) . ' </td>
		 			<td align="right" style="font-weight:bold;" > ' . $simbolo . number_format($sumatoria_aguinaldo, 2) . '  </td>
		 			</tr><tr><td colspan="8"></td></tr>';
				}
			}
			$j++; //incrementar la variable de control de flujo de los registros		 	
		?>
			<tr>
				<td width="15%"><?php echo $fila['pla_codigo']; ?></td>
				<td width="10%"> &nbsp; <?php echo ($fila['emp_fecha_contrato']) ? date("d-m-Y", strtotime($fila['emp_fecha_contrato'])) : '-'; ?></td>
				<td width="15%"><?php echo $empleado['are_nombre']; ?></td>
				<td width="10%"><?php echo $dui; ?></td>
				<td width="20%"><?php echo $fila['emp_nombre'] . ' ' . $fila['emp_apellido']; ?></td>
				<td width="10%" align="right"><?php echo $fila['emp_salario']; ?></td>
				<td width="10%" align="right"><span <?php echo (!$esreporte) ? 'title="' . $fecha1 . ' / ' . $fecha2 . '" class="tip_rango" ' : '';  ?>><?php echo $years_aguinaldo; ?></span></td>
				<td width="10%" align="right"><?php echo $aguinaldo; ?></td>
			</tr>
		<?php echo $tr_subtotalizacion;
		}
		if (count($consulta) > 0) {
			if (!$es_excel) {
				echo '<tr><td colspan="8"></td></tr>
				<tr><td colspan="5"><h4>TOTAL GENERAL</h4></td>
				<td align="right" ><h4> ' . $simbolo . number_format($sumatoria_salario_total, 2) . '</h4></td>
				<td align="right" ><h4> ' . number_format($sumatoria_years_total, 2) . '</h4></td>
				<td align="right" ><h4> ' . $simbolo . number_format($sumatoria_aguinaldo_total, 2) . '</h4></td>
				</tr>';
			}
		}
		if (count($consulta) <= 0) {
		?>
			<tr>
				<td colspan="8">Sin Registros</td>
			</tr>
		<?php }  ?>
	</tbody>
</table>