<meta charset="utf-8" />
<?php if (isset($titulo_reporte_excel)) {
	echo $titulo_reporte_excel;
} ?>
<table border="1" id="tabla_resultados_NO" class="responsive table table-striped table-bordered table-condensed">
	<thead>
		<tr style="font-weight:bold;">
			<th width="15%">PLANILLA</th>
			<th width="10%">FECHA INGRESO</th>
			<th width="15%">AREA</th>
			<th width="10%">DUI</th>
			<th width="20%">NOMBRE</th>
			<th width="10%">SALARIO BASE</th>
			<th width="10%">VACACIÓN</th>
			<th width="10%">PRIMA VACACIÓN</th>
		</tr>
	</thead>
	<tbody>
		<?php
		$areas_procesados = array(0);
		$sumatoria_salario = $sumatoria_salario_total = $sumatoria_vacacion = $sumatoria_prima = $sumatoria_vacacion_total = $sumatoria_prima_total = 0;
		$j = 0;
		$area_inicial = (count($consulta) > 0) ? $consulta[0]['emp_id_are'] : 0;
		foreach ($consulta as $fila) {
			//extraer todos los datos del empleado
			$datos_empleado = $this->planilla_model->get_empleados_reporte(array('emp_id' => $fila['ddi_id_emp']));
			$empleado = $datos_empleado[0];

			//extraer el dui y el nit del empleado
			$dui = '-';
			$doc = explode(',', $empleado['documentos_empleado']);
			for ($y = 0; $y < count($doc); $y++) {
				if (substr_count(strtolower($doc[$y]), 'dui') > 0) {
					$dui_ = explode('(', $doc[$y]);
					$dui = $dui_[0];
				}
			}

			$vacacion = $prima_vacacion = '-';
			if (substr_count($fila['vaca_ids'], '#')) {
				$idsv = explode('#', $fila['vaca_ids']);
				$valores = explode('#', $fila['vaca']);

				if ($idsv[0] == $id_vaca) {
					$indice_v = 0;
				} elseif ($idsv[1] == $id_vaca) {
					$indice_v = 1;
				}

				if ($idsv[0] == $id_prima_v) {
					$indice_prima = 0;
				} elseif ($idsv[1] == $id_prima_v) {
					$indice_prima = 1;
				}

				$vacacion = $valores[$indice_v];
				$prima_vacacion = $valores[$indice_prima];
			} else {
				if ($fila['vaca_ids'] == $id_vaca) {
					$vacacion = $fila['vaca'];
				} elseif ($fila['vaca_ids'] == $id_prima_v) {
					$prima_vacacion = $fila['vaca'];
				}
			}

			$s_vacacion = str_replace('-', '0', $vacacion);
			$s_prima_vacacion = str_replace('-', '0', $prima_vacacion);
			$sumatoria_vacacion_total += $s_vacacion;
			$sumatoria_prima_total += $s_prima_vacacion;
			$sumatoria_salario_total += $fila['emp_salario'];
			$tr_subtotalizacion = "";

			if (!in_array($fila['emp_id_are'], $areas_procesados)) {
				$areas_procesados[] = $fila['emp_id_are'];
			}

			if ($area_inicial == $fila['emp_id_are']) {
				$sumatoria_vacacion += $s_vacacion;
				$sumatoria_prima += $s_prima_vacacion;
				$sumatoria_salario += $fila['emp_salario'];
				$area_inicial = $fila['emp_id_are'];
			} else {
				$sumatoria_vacacion = $s_vacacion;
				$sumatoria_prima = $s_prima_vacacion;
				$sumatoria_salario = $fila['emp_salario'];
				$area_inicial = $fila['emp_id_are'];
			}

			$nombre_area = $fila['are_nombre']; // $empleado['are_nombre']; 
			if (count($consulta) != ($j + 1)) {
				//que no sea el ultimo para adelantar la posición siguiente
				if ($consulta[($j + 1)]['emp_id_are'] != $fila['emp_id_are']) {
					//crear el tr del subtotal y al final crear una fila en blanco
					if (!$es_excel) {
						$tr_subtotalizacion = '<tr>
		 				<td colspan="5" align="right" ><b>TOTAL ' . mb_strtoupper($nombre_area, 'UTF-8') . '</b></td>
		 				<td align="right" style="font-weight:bold;" > ' . $simbolo . number_format($sumatoria_salario, 2) . ' </td>
		 				<td align="right" style="font-weight:bold;" > ' . $simbolo . number_format($sumatoria_vacacion, 2) . '  </td>
		 				<td align="right"  style="font-weight:bold;"> ' . $simbolo . number_format($sumatoria_prima, 2) . '  </td>
		 				</tr><tr><td colspan="8"></td></tr>';
					}
				}
			} else { //si es el ultimo registro imprimir la totalización del area final
				if (!$es_excel) {
					$tr_subtotalizacion = '<tr>
		 			<td colspan="5" align="right" ><b>TOTAL ' . mb_strtoupper($nombre_area, 'UTF-8') . '</b></td>
		 			<td align="right" style="font-weight:bold;" > ' . $simbolo . number_format($sumatoria_salario, 2) . ' </td>
		 			<td align="right" style="font-weight:bold;" > ' . $simbolo . number_format($sumatoria_vacacion, 2) . '  </td>
		 			<td align="right"  style="font-weight:bold;"> ' . $simbolo . number_format($sumatoria_prima, 2) . ' </td>
		 			</tr><tr><td colspan="8"></td></tr>';
				}
			}

			$j++; //incrementar la variable de control de flujo de los registros

		?>
			<tr>
				<td width="15%"><?php echo $fila['pla_codigo']; ?></td>
				<td width="10%"> &nbsp;<?php echo ($fila['emp_fecha_contrato']) ? date("d-m-Y", strtotime($fila['emp_fecha_contrato'])) : '-'; ?></td>
				<td width="15%"><?php echo $empleado['are_nombre']; ?></td>
				<td width="10%"><?php echo $dui; ?></td>
				<td width="20%"><?php echo $fila['emp_nombre'] . ' ' . $fila['emp_apellido']; ?></td>
				<td width="10%" align="right"><?php echo $fila['emp_salario']; ?></td>
				<td width="10%" align="right"><?php echo $vacacion; ?></td>
				<td width="10%" align="right"><?php echo $prima_vacacion; ?></td>
			</tr>
			<?php echo $tr_subtotalizacion; ?>
		<?php }
		//DE LOS BANCO QUE FUERON SELECCIONADOS Y NO POSEEN REGISTROS CREAR UNA FILA QUE ME NOTIFIQUE

		/* for ($k=0; $k < count($bancos_seleccionados) ; $k++) { 
		 	if( ! in_array($bancos_seleccionados[$k], $bancos_procesados)) {
		 		$nombre_banco2 = $this->gsatelite->get_campo('ban_banco','ban_nombre',array('ban_id'=>$bancos_seleccionados[$k]));
		 		//echo "";
		 		echo '<tr>
		 		 <td colspan="6" align="right" ><b>TOTAL '. strtoupper($nombre_banco2).'</b> (sin registros)</td>
		 		 <td align="right" style="font-weight:bold;" >$ 0.00 </td>
		 		 <td align="right" style="font-weight:bold;" > </td>
		 		 <td align="right"  style="font-weight:bold;"> </td>
		 		 </tr><tr><td colspan="9"></td></tr>';
		 	}
		 } */

		if (count($consulta) > 0) {
			if (!$es_excel) {
				echo '<tr><td colspan="8"></td></tr>
				<tr><td colspan="5"><h4>TOTAL GENERAL</h4></td>
				<td align="right" ><h4> ' . $simbolo . number_format($sumatoria_salario_total, 2) . '</h4></td>
				<td align="right" ><h4> ' . $simbolo . number_format($sumatoria_vacacion_total, 2) . '</h4></td>
				<td align="right" ><h4> ' . $simbolo . number_format($sumatoria_prima_total, 2) . '</h4></td>
				</tr>';
			}
		}

		if (count($consulta) <= 0) { ?>
			<tr>
				<td colspan="8">Sin Registros</td>
			</tr>
		<?php }  ?>
	</tbody>
</table>