<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == "excel") {
	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	header("Content-Disposition: attachment;filename=Reporte_detalle_descuentos.xls");
	header("Pragma: no-cache");
	header("Expires: 0");
}
?>
<style type="text/css">
	.text {
		mso-number-format: "\@";
	}
</style>
<?php if ($tipo_reporte != "") { ?>
	<table border="0">
		<?php if ($tipo_reporte == "excel") { ?>
			<tr>
				<td style="text-align: center;" colspan="8">
					<h3>Reporte de Descuentos</h3>
				</td>
			</tr>
		<?php } ?>
		<tr>
			<td style="text-align: center;" colspan="8">Período(s) de planilla desde el <?= formatear_fecha('d-m-Y', $fecha_ini) ?> hasta el <?= formatear_fecha('d-m-Y', $fecha_fin) ?></td>
		</tr>
	</table>
<?php } ?>
<table border="1" id="tabla_resultados_afp" cellpadding="2" class="responsive table table-striped table-bordered table-condensed" <?= ($tipo_reporte == 'pdf') ? 'style="font-size:8px;"' : ""; ?>>
	<thead>
		<tr style="font-weight:bold;">
			<th width="12%">AFP</th>
			<th width="7%">Código</th>
			<th width="26%">Empleada/o</th>
			<th width="12%">Descuento</th>
			<th width="10%">Concepto</th>
			<th width="11%">Descuento<br /> Laboral</th>
			<th width="11%">Descuento<br /> Patronal</th>
			<th width="11%">Ingreso <br />Afecto</th>
		</tr>
	</thead>
	<tbody>
		<?php
		if (count($consulta) > 0) {
			$total_des = $c = $s1 = $s2 = $s3 = $j = 0;
			$afp_ini = $consulta[0]['emp_id_afp'];
			$afp_nombre = $consulta[0]['afp_nombre'];
			$area_inicial = $consulta[0]['emp_id_are'];
			// ----- Descuento ----------
			$sumatoria_descuento = $sumatoria_patronal = $sumatoria_afecto = 0;
			foreach ($consulta as $fila) {
				/******************************** SUBTOTALES SEGÚN AFP ****************************************/
				$s1 += $fila['suma_descuento'];
				$s2 += $fila['suma_patronal'];
				$s3 += $fila['suma_ingreso_afecto'];
				$c++;
				if ($afp_ini != $fila['emp_id_afp']) {
					$s1 = $s1 - $fila['suma_descuento'];
					$s2 = $s2 - $fila['suma_patronal'];
					$s3 = $s3 - $fila['suma_ingreso_afecto'];
					if ($tipo_reporte != "excel") {
						echo '<tr style="font-weight:bold;"><td colspan="5" style="text-align:right;">TOTAL ' . $afp_nombre . '</td>
						<td style="text-align:right;">' . $simbolo . number_format($s1, 2) . '</td><td style="text-align:right;">$' . number_format($s2, 2) . '</td>
						<td style="text-align:right;">' . $simbolo . number_format($s3, 2) . '</td></tr>';
					}
					$afp_ini = $fila['emp_id_afp'];
					$afp_nombre = $fila['afp_nombre'];
					$s1 = $fila['suma_descuento'];
					$s2 = $fila['suma_patronal'];
					$s3 = $fila['suma_ingreso_afecto'];
				}
				/******************************** SUBTOTALES SEGÚN ÁREA ****************************************/
				$nombre_area = '';
				$tr_subtotalizacion = "";
				if ($area_inicial == $fila['emp_id_are']) {
					$sumatoria_descuento += $fila['suma_descuento'];
					$sumatoria_patronal += $fila['suma_patronal'];
					$sumatoria_afecto += $fila['suma_ingreso_afecto'];
					$area_inicial = $fila['emp_id_are'];
				} else {
					$sumatoria_descuento = $fila['suma_descuento'];
					$sumatoria_patronal = $fila['suma_patronal'];
					$sumatoria_afecto = $fila['suma_ingreso_afecto'];
					$area_inicial = $fila['emp_id_are'];
				}
				$nombre_area = $fila['area_nombre'];
				if (count($consulta) != ($j + 1)) {
					// Que no sea el último para adelantar la posición siguiente
					if ($consulta[($j + 1)]['emp_id_are'] != $fila['emp_id_are']) {
						if ($tipo_reporte != "excel") {
							$tr_subtotalizacion = '<tr>
							<td colspan="5" style="text-align:left;"><b>TOTAL ' . mb_strtoupper($nombre_area, 'UTF-8') . '</b></td>
							<td style="font-weight:bold;text-align:right" >' . $simbolo . number_format($sumatoria_descuento, 2) . ' </td>
							<td style="font-weight:bold;text-align:right" >' . $simbolo . number_format($sumatoria_patronal, 2) . ' </td>
							<td style="font-weight:bold;text-align:right" >' . $simbolo . number_format($sumatoria_afecto, 2) . ' </td>
							</tr>';
						}
					}
				} else {
					// Si es el último registro imprimir la totalización del area final
					if ($tipo_reporte != "excel") {
						$tr_subtotalizacion = '<tr>
						<td colspan="5" style="text-align:left;"><b>TOTAL ' . mb_strtoupper($nombre_area, 'UTF-8') . '</b></td>
						<td style="font-weight:bold;text-align:right" >' . $simbolo . number_format($sumatoria_descuento, 2) . ' </td>
						<td style="font-weight:bold;text-align:right" >' . $simbolo . number_format($sumatoria_patronal, 2) . ' </td>
						<td style="font-weight:bold;text-align:right" >' . $simbolo . number_format($sumatoria_afecto, 2) . ' </td>
						</tr>';
					}
				}
		?>
				<tr nobr="true">
					<td width="12%"><?php echo $fila['afp_nombre']; ?></td>
					<td width="7%" class="text"><?php echo $fila['emp_codigo']; ?></td>
					<td width="26%"><?php echo $fila['emp_nombre'] . ' ' . $fila['emp_apellido']; ?></td>
					<td width="12%"><?php echo $fila['tdc_nombre']; ?></td>
					<td width="10%"><?php echo $fila['dss_motivo']; ?></td>
					<td width="11%" style="text-align: right;"><?= $simbolo ?><?php echo $fila['suma_descuento']; ?></td>
					<td width="11%" style="text-align: right;"><?= $simbolo ?><?php echo $fila['suma_patronal']; ?></td>
					<td width="11%" style="text-align: right;"><?= $simbolo ?><?php echo $fila['suma_ingreso_afecto']; ?></td>
				</tr>
				<?php
				echo $tr_subtotalizacion;
				if (count($consulta) == $c) {
					echo ($tipo_reporte == "excel") ? '' : '<tr style="font-weight:bold;"><td colspan="5" style="text-align:right;">TOTAL ' . $afp_nombre . $simbolo . ' </td><td style="text-align:right;">' . $simbolo . number_format($s1, 2) . '</td><td style="text-align:right;">' . $simbolo . number_format($s2, 2) . '</td><td style="text-align:right;">' . $simbolo . number_format($s3, 2) . '</td></tr>';
				}
				$total_des += (float)$fila['suma_descuento'];
				$j++; //incrementar la variable de control de flujo de los registros
			}
		}
		if (count($consulta) > 0) {
			if ($tipo_reporte != "excel") {
				?>
				<tr>
					<td colspan="5" align="right" style="font-weight:bold;">TOTAL GENERAL</td>
					<td style="font-weight:bold;text-align:right;"><?= $simbolo ?> <?php echo number_format($total_des, 2, '.', ','); ?></td>
					<td colspan="2" style="borle"></td>
				</tr>
			<?php
			}
		} else {
			?>
			<tr>
				<td colspan="8">
					<center>Sin Registros</center>
				</td>
			</tr>
		<?php }  ?>
	</tbody>
</table>