<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
$p = ($tipo_reporte == 'pdf') ? true : false;
if ($tipo_reporte == "excel") {
	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	header("Content-Disposition: attachment;filename=Reporte_detalle_descuentos.xls");
	header("Pragma: no-cache");
	header("Expires: 0");
}
?>
<style type="text/css">
	.text {
		mso-number-format: "\@";
	}
</style>
<?php if ($tipo_reporte != "") { ?>
	<table border="0">
		<?php if ($tipo_reporte == "excel") { ?>
			<tr>
				<td style="text-align: center;" colspan="13">
					<h3>Reporte de Descuentos</h3>
				</td>
			</tr>
		<?php } ?>
		<tr>
			<td style="text-align: center;" colspan="13">Período(s) de planilla desde el <?= formatear_fecha('d-m-Y', $fecha_ini) ?> hasta el <?= formatear_fecha('d-m-Y', $fecha_fin) ?></td>
		</tr>
	</table>
<?php } ?>
<table border="1" id="tabla_resultados" class="responsive table table-striped table-bordered table-condensed" cellpadding="1" <?= ($tipo_reporte == 'pdf') ? 'style="font-size:6px;"' : ""; ?>>
	<thead>
		<tr style="font-weight:bold;">
			<th <?=($p) ? 'width="4%"':'';?> >Código</th>
			<th <?=($p) ? 'width="16%"':'';?>>Empleada/o</th>
			<th <?=($p) ? 'width="10%"':'';?>>Descuento</th>
			<th <?=($p) ? 'width="6%"':'';?>>Fecha Desde</th>
			<th <?=($p) ? 'width="5%"':'';?>>Valor Cuota</th>
			<th <?=($p) ? 'width="5%"':'';?>>Cuotas</th>
			<th <?=($p) ? 'width="5%"':'';?>>Cuotas Pagadas</th>
			<th <?=($p) ? 'width="7%"':'';?>>Pago Acumulado </th>
			<th <?=($p) ? 'width="7%"':'';?>>Saldo Pendiente</th>
			<th <?=($p) ? 'width="8%"':'';?>>Concepto</th>
			<th <?=($p) ? 'width="6%"':'';?>>Referencia</th>
			<th <?=($p) ? 'width="7%"':'';?>>Descuento Laboral</th>
			<th <?=($p) ? 'width="7%"':'';?>>Descuento Patronal</th>
			<th <?=($p) ? 'width="7%"':'';?>>Ingreso Afecto</th>
		</tr>
	</thead>
	<tbody>
		<?php
		if (count($consulta) > 0) {
			$j = 0;
			$sumatoria_ingreso = $total_ing = 0;
			$area_inicial = $consulta[0]['emp_id_are'];
			foreach ($consulta as $fila) {
				$nombre_area = '';
				$tr_subtotalizacion = "";
				$saldo_pendiente = $saldo_acumulado = " - ";
				if ($area_inicial == $fila['emp_id_are']) {
					$sumatoria_ingreso += $fila['suma_descuento'];
					$area_inicial = $fila['emp_id_are'];
				} else {
					$sumatoria_ingreso = $fila['suma_descuento'];
					$area_inicial = $fila['emp_id_are'];
				}
				$nombre_area = $fila['area_nombre'];
				if (count($consulta) != ($j + 1)) {
					// Que no sea el último para adelantar la posición siguiente
					if ($consulta[($j + 1)]['emp_id_are'] != $fila['emp_id_are'] && $tipo_reporte != "excel") {
						//crear el tr del subtotal y al final crear una fila en blanco
						$tr_subtotalizacion = '<tr nobr="true"><td colspan="11" style="font-weight: bold; text-align: right;"><b>TOTAL ' . mb_strtoupper($nombre_area, 'UTF-8') . '</b></td>
						<td style="font-weight: bold; text-align: right;">' . $simbolo . number_format($sumatoria_ingreso, 2) . '</td><td colspan="2"></td></tr><tr><td colspan="12"></td></tr>';
					}
				} else {
					// Si es el último registro imprimir la totalización del area final
					if ($tipo_reporte != "excel") {
						$tr_subtotalizacion = '<tr nobr="true"><td colspan="11" style="font-weight: bold; text-align: right;"><b>TOTAL ' . mb_strtoupper($nombre_area, 'UTF-8') . '</b></td>
						<td style="font-weight: bold; text-align: right;">' . $simbolo . number_format($sumatoria_ingreso, 2) . '</td><td colspan="2"></td></tr><tr><td colspan="12"></td></tr>';
					}
				}
				if ($fila['permanente'] == 0) {
					if ($fila['promedio_cuotas'] > 0) {
						$saldo_acumulado = number_format(($fila['cuota_pagada'] * $fila['valor_cuota']), 2);
						$saldo_pendiente = number_format((($fila['promedio_cuotas'] - $fila['cuota_pagada']) * $fila['valor_cuota']), 2);
					}
				}
				?>
				<tr nobr="true">
					<td <?=($p)?'width="4%"':'';?> class="text"><?php echo $fila['emp_codigo']; ?></td>
					<td <?=($p)?'width="16%"':'';?>><?php echo $fila['emp_nombre'] . ' ' . $fila['emp_apellido']; ?></td>
					<td <?=($p)?'width="10%"':'';?>><?php echo $fila['tdc_nombre']; ?></td>
					<td <?=($p)?'width="6%"':'';?>><?php echo formatear_fecha('d-m-Y', $fila['fecha_inicio']); ?></td>
					<td <?=($p)?'width="5%"':'';?> style="text-align: right;"><?php echo ($fila['valor_cuota'] > 0) ? number_format($fila['valor_cuota'], 2) : ''; ?></td>
					<td <?=($p)?'width="5%"':'';?> class="text" style="text-align: center;"><?= ($fila['promedio_cuotas']>0)?number_format($fila['promedio_cuotas'], 2):'--';?></td>
					<td <?=($p)?'width="5%"':'';?> class="text" style="text-align: center;"><?= ($fila['promedio_cuotas']>0)?number_format($fila['cuota_pagada'],2):'--';?></td>
					<td <?=($p)?'width="7%"':'';?> style="text-align: right;"><?php echo $saldo_acumulado; ?></td>
					<td <?=($p)?'width="7%"':'';?> style="text-align: right;"><?php echo $saldo_pendiente; ?></td>
					<td <?=($p) ? 'width="8%"':'';?>><?php echo  $fila['dss_motivo']; ?></td>
					<td <?=($p) ? 'width="6%"':'';?>><?= $fila['referencia'] ?></td>
					<td <?=($p) ? 'width="7%"':'';?> style="text-align: right;"><?php echo $fila['suma_descuento']; ?></td>
					<td <?=($p) ? 'width="7%"':'';?> style="text-align: right;"><?php echo $fila['suma_patronal']; ?></td>
					<td <?=($p) ? 'width="7%"':'';?> style="text-align: right;"><?php echo $fila['suma_ingreso_afecto']; ?></td>
				</tr>
			<?php
				echo $tr_subtotalizacion;
				$total_ing += (float)$fila['suma_descuento'];
				$j++; //incrementar la variable de control de flujo de los registros
			}
			if ($tipo_reporte != "excel") {
			?>
				<tr nobr="true">
					<td colspan="11" style="font-weight: bold; text-align: right;">TOTAL GENERAL</td>
					<td style="font-weight: bold; text-align: right;"><?= $simbolo ?><?php echo number_format($total_ing, 2); ?></td>
					<td colspan="2"></td>
				</tr>
			<?php
			}
		} else {
			?>
			<tr>
				<td colspan="12" style="text-align:center">Sin Registros</td>
			</tr>
		<?php
		}  ?>
	</tbody>
</table>
<?php if ($tipo_reporte != "") {
	$f1 = $this->gsatelite->get_parametro_emp('SYS_TESORERO_EMPRESA');
	$f2 = $this->gsatelite->get_parametro_emp('SIS_JEFE_RRHH');
	$firma1 = explode(',', $f1);
	$firma2 = explode(',', $f2);
	$nombre1 = (isset($firma1[0])) ? $firma1[0] : "";
	$nombre2 = (isset($firma2[0])) ? $firma2[0] : "";
	$cargo1  = (isset($firma1[1])) ? $firma1[1] : "";
	$cargo2  = (isset($firma2[1])) ? $firma2[1] : "";
	if ($f1 != "" || $f2 != "") {
		?>
		<div class="clear"><br><br></div>
		<table border="0" align="center">
			<tr><td></td><td style="border-bottom:1px solid blak"></td><td></td><td style="border-bottom:1px solid blak"></td><td></td></tr>
			<tr><td></td><td><b><?= $nombre1 ?></b><br><?= $cargo1 ?></td><td></td><td><b><?= $nombre2 ?></b><br><?= $cargo2 ?></td><td></td></tr>
		</table>
		<?php 
	}
} ?>