<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', '');
$p = ($tipo_reporte == 'pdf') ? true : false;
if ($tipo_reporte == "excel") {
	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	header("Content-Disposition: attachment;filename=Detalle_ingresos_descuentos.xls");
	header("Pragma: no-cache");
	header("Expires: 0");
}
?>
<style type="text/css">
	.text {
		mso-number-format: "\@";
	}
</style>
<?php if ($tipo_reporte == "excel") { ?>
	<table border="0">
		<tr>
			<td style="text-align: center;" colspan="5">
				<h3>Detalle de Ingresos y Descuentos</h3>
			</td>
		</tr>
	</table>
<?php }
$total_ing = $total_des = 0;
?>
<table border="1" id="tabla_resultados" class="responsive table table-striped table-bordered table-condensed" cellpadding="1" <?= ($tipo_reporte == 'pdf') ? 'style="font-size:6px;"' : ""; ?>>
	<thead>
		<?php if (count($registros["ingreso"]) > 0) {
			?>
			<tr>
				<th <?=($p) ? 'width="50%"':'';?> colspan="2"><b>Código:</b> <?= $registros["ingreso"][0]['emp_codigo'] ?></th>
				<th <?=($p) ? 'width="50%"':'';?> colspan="2"><b>Empleado:</b> <?= $registros["ingreso"][0]['emp_nombre'] . ' ' . $registros["ingreso"][0]['emp_apellido'] ?></th>
			</tr>
		<?php } ?>
	</thead>
	<tbody>
		<?php if (count($registros["ingreso"]) > 0) {
			?>
			<tr nobr="true" style="font-weight:bold;">
				<th <?=($p) ? 'width="25%"':'';?>>Tipo Planilla</th>
				<th <?=($p) ? 'width="30%"':'';?>>Referencia</th>
				<th <?=($p) ? 'width="25%"':'';?>>Tipo Ingreso </th>
				<th <?=($p) ? 'width="20%"':'';?>>Valor <?= $simbolo ?></th>
			</tr>
			<?php 
			foreach ($registros["ingreso"] as $ki => $vi) {
				$total_ing += number_format($vi["ddi_valor"],2,'.','');
				?>
				<tr nobr="true">
					<td <?=($p)?'width="25%"':'';?>><?php echo $vi['tpl_nombre']; ?></td>
					<td <?=($p)?'width="30%"':'';?>><?php echo $vi['inn_referencia']; ?></td>
					<td <?=($p)?'width="25%"':'';?> class="text"><?php echo $vi['tig_nombre']; ?></td>
					<td <?=($p)?'width="20%"':'';?> style="text-align: right;"><?php echo number_format($vi['ddi_valor'], 2); ?></td>
				</tr>
				<?php 
			} ?>
			<tr nobr="true" style="font-weight:bold;">
				<th colspan="3" <?=($p) ? 'width="80%"':'';?> style="text-align: right;" >Total Ingresos <?= $simbolo ?></th>
				<th <?=($p) ? 'width="20%"':'';?> style="text-align: right;"><?php echo number_format($total_ing, 2); ?></th>
			</tr>
			<?php
		} 
		if (count($registros["descuento"]) > 0) {
			if (count($registros["ingreso"]) > 0) {
				?>
				<tr nobr="true" style="font-weight:bold;"><th colspan="4"></th></tr>
				<?php
			}
			?>
			<tr nobr="true" style="font-weight:bold;">
				<th <?=($p) ? 'width="25%"':'';?>>Tipo Planilla</th>
				<th <?=($p) ? 'width="30%"':'';?>>Referencia</th>
				<th <?=($p) ? 'width="25%"':'';?>>Tipo Descuento</th>
				<th <?=($p) ? 'width="20%"':'';?>>Valor <?= $simbolo ?></th>
			</tr>
			<?php 
			foreach ($registros["descuento"] as $kd => $vd) {
				$total_des += number_format($vd["ddd_valor"],2,'.','');
				?>
				<tr nobr="true">
					<td <?=($p)?'width="25%"':'';?>><?php echo $vd['tpl_nombre']; ?></td>
					<td <?=($p)?'width="30%"':'';?>><?php echo $vd['dss_referencia']; ?></td>
					<td <?=($p)?'width="25%"':'';?> class="text"><?php echo $vd['tdc_nombre']; ?></td>
					<td <?=($p)?'width="20%"':'';?> style="text-align: right;"><?php echo number_format($vd['ddd_valor'], 2); ?></td>
				</tr>
				<?php
			} ?>
			<tr nobr="true" style="font-weight:bold;">
				<th colspan="3" <?=($p) ? 'width="80%"':'';?> style="text-align: right;">Total Descuentos <?= $simbolo ?></th>
				<th <?=($p) ? 'width="20%"':'';?> style="text-align: right;"><?php echo number_format($total_des, 2); ?></th>
			</tr>
			<?php
		}
		if (count($registros["ingreso"]) > 0 || count($registros["descuento"]) > 0) {
			?>
			<tr nobr="true">
				<td colspan="3" style="font-weight: bold; text-align: right;">Valor Neto</td>
				<td style="font-weight: bold; text-align: right;"><?= $simbolo ?><?php echo number_format(($total_ing - $total_des), 2); ?></td>
			</tr>
			<?php
		} else {
			?>
			<tr>
				<td colspan="4" style="text-align:center">Sin Registros</td>
			</tr>
			<?php
		}
		?>
	</tbody>
</table>