<?php if(isset($excel)){
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}?>
<style type="text/css">
    .tabla{
        font-weight: normal !important;
        font-family: 'Arial';
        border:1px solid black;
    }
    .tabla th{
        border:1px solid black;
        vertical-align: middle;
        text-align: center;
    }
    .tabla td{
        border:1px solid black;
        vertical-align: middle;
        text-align: center;
    }
    .num {
        mso-number-format:General;
    }
    .text{
        mso-number-format:"\@";
    }
</style>

<?php
    if($excel!=1){
         echo $header;
    }

?>
<br>

<table class="responsive table table-bordered" id="cajas" border="1" cellpadding="2">
    <tr>
        <th style="font-weight:bold;" width="6%">Código </th>
        <th style="font-weight:bold;" width="15%">Empleada/o</th>
        <th style="font-weight:bold;" width="7%">Ingreso</th>
        <th style="font-weight:bold;" width="7%">Ingreso afecto</th>
        <th style="font-weight:bold;" width="5%">Enero</th>
        <th style="font-weight:bold;" width="5.5%">Febrero</th>
        <th style="font-weight:bold;" width="5%">Marzo</th>
        <th style="font-weight:bold;" width="4%">Abril</th>
        <th style="font-weight:bold;" width="4%">Mayo</th>
        <th style="font-weight:bold;" width="5%">Junio</th>
        <th style="font-weight:bold;" width="5%">Julio</th>
        <th style="font-weight:bold;" width="5%">Agosto</th>
        <th style="font-weight:bold;" width="7.5%">Septiembre</th>
        <th style="font-weight:bold;" width="5.5%">Octubre</th>
        <th style="font-weight:bold;" width="7%">Noviembre</th>
        <th style="font-weight:bold;" width="6.5%">Diciembre</th>
    </tr>

<?php
    if(count($empleados)>0){
        foreach ($empleados as $emp ) {
            $where['emp_id']=$emp['emp_id'];
            $detalles = $this->planilla_model->get_isr_planilla($where);

            $arr_isr_mes = array();
            foreach ($detalles as $dt) {
                $arr_isr_mes[$dt['mes']]=$dt['isr'];
            }
?>
    <tr>
        <td width="6%" style="text-align:left;"><?php echo $emp['emp_codigo']; ?></td>
        <td width="15%" style="text-align:left;"><?php echo $emp['empleado']; ?></td>
        <td style="text-align:right;" width="7%"><?php echo number_format($emp['total'],2); ?></td><!-- Ingreso total -->
        <td style="text-align:right;" width="7%"><?php echo number_format($emp['ingreso'],2); ?></td> <!-- Ingreso menos ISSS y AFP -->
        <?php
        for ($i=1; $i <= 12 ; $i++) { 
                if(array_key_exists($i,$arr_isr_mes)){
        ?>
            <td style="text-align:right;"><?php echo number_format($arr_isr_mes[$i],2); ?></td>
        <?php
                }else{
        ?>
            <td style="text-align:right;" ><?php echo '0.00'; ?></td>
        <?php
                }
        }
        ?>

    </tr>
<?php
        }
    }else{
?>
    <tr>
        <td colspan="10" style="text-align:center;">No se encontraron registros</td>
    </tr>
<?php    
    }
?>         
</table>