<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

?>
<table class="responsive table table-bordered">
    <thead>
        <tr>
            <th>Código</th>
            <th>Empleada/o</th>
            <th>Área</th>
            <th>Plaza</th>
            <th>Ingresos</th>
            <th>Desc. ISSS</th>
            <th>Desc. AFP</th>
            <th>Otros Desc.</th>
            <th>Monto Imponible</th>
            <th>Renta Aplicada</th>
            <th>Renta Determinada</th>
            <th>Diferencia Recálculo</th>
        </tr>
    </thead>
    <tbody>
        <?php
        if (count($detalle) > 0) {
            foreach ($detalle as $key => $value) {
                $imponible = (float)$value['total_ingreso'] - ((float)$value['descuento_isss'] + (float)$value['descuento_afp'] + (float)$value['otros_descuentos']);
                $aplicada = (float)$value['renta'] - (float)$value['recalculo'];
                $diferencia = ($value['recalculo'] > 0) ? $simbolo . number_format($value['renta'], 2) : '---';
        ?>
                <tr>
                    <td><?php echo $value['emp_codigo']; ?></td>
                    <td><?php echo $value['empleado']; ?></td>
                    <td><?php echo $value['area']; ?></td>
                    <td><?php echo $value['plaza']; ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($value['total_ingreso'], 2); ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($value['descuento_isss'], 2); ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($value['descuento_afp'], 2); ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($value['otros_descuentos'], 2); ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($imponible, 2); ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($aplicada, 2); ?></td>
                    <td style="text-align: right;"><?php echo $diferencia; ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($value['recalculo'], 2); ?></td>
                </tr>
            <?php
            }
        } else {
            ?>
            <tr>
                <td colspan="12" style="text-align:center;">No se encontraron registros</td>
            </tr>
        <?php
        }
        ?>
    </tbody>
</table>