<?php
$afp = $this->gsatelite->get_registro("tdc_tipo_descuento", array("tdc_id" => $this->gsatelite->get_parametro('DESCUENTO_AFP', 0)));
$iss = $this->gsatelite->get_registro("tdc_tipo_descuento", array("tdc_id" => $this->gsatelite->get_parametro('DESCUENTO_ISS', 0)));
$pdf = ($reporte == 'pdf') ? true : false;
if($reporte == 'excel'){
	header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    ?>
    <meta charset="utf-8" />
    <div class="head">
    	<table>
    		<tr>
    			<td align="center" colspan="6" >
    				<h4>
    					<?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?>
    					<br />
    					<span>Reporte de Ingresos Mensuales por Empleada/o</span>
    				</h4>
    				<span><?= $periode ?></span>
    			</td>
    		</tr>
    	</table>
    </div>
    <br>
    <?php
} 


if (count($registros) > 0) {
	$emp = $registros[0]['ddi_id_emp'];
	$ver_emp = true;
	$isse = $issp = $afpe = $afpp = $ings = 0;
	?>
	<table border="1" id="detalles" class="responsive table table-bordered table-condensed display" width="100%">
		<?php if ($ver_emp) { ?>
			<thead>
				<tr nobr="true">
					<th colspan="6"><?php echo $registros[0]['emp_codigo'] ?> - <?php echo $registros[0]['emp_nombre'] ?> <?php echo $registros[0]['emp_apellido'] ?></th>
				</tr>
				<tr nobr="true">
					<th <?=($pdf)?'width="30%"':'';?>>Tipo de Ingreso</th>
					<th <?=($pdf)?'width="14%"':'';?>>Monto del Ingreso</th>
					<th <?=($pdf)?'width="14%"':'';?>>ISSS Empleada/o</th>
					<th <?=($pdf)?'width="14%"':'';?>>ISSS Patronal</th>
					<th <?=($pdf)?'width="14%"':'';?>>AFP Empleada/o</th>
					<th <?=($pdf)?'width="14%"':'';?>>AFP Patronal</th>
				</tr>
			</thead>
			<tbody>
		<?php } 
		foreach ($registros as $k => $var) {
			if ($var['ddi_id_emp'] == $emp) {
				$isss_emp = ($var['ddi_valor'] * ($iss->tdc_porcentaje / 100));
				$isss_ptr = ($var['ddi_valor'] * ($iss->tdc_porcentaje_patronal / 100));
				$afp_emp = ($var['ddi_valor'] * ($afp->tdc_porcentaje / 100));
				$afp_ptr = ($var['ddi_valor'] * ($afp->tdc_porcentaje_patronal / 100));
				$ings += number_format($var['ddi_valor'],2,'.','');
				$isse += number_format($isss_emp,2,'.','');
				$issp += number_format($isss_ptr,2,'.','');
				$afpe += number_format($afp_emp,2,'.','');
				$afpp += number_format($afp_ptr,2,'.','');
				?>
				<tr nobr="true">
					<td <?=($pdf)?'width="30%"':'';?>><?php echo $var['tipo_inn'] ?></td>
					<td style="text-align: right;" <?=($pdf)?'width="14%"':'';?>><?php echo number_format($var['ddi_valor'], 2) ?></td>
					<td style="text-align: right;" <?=($pdf)?'width="14%"':'';?>><?php echo number_format($isss_emp, 2) ?></td>
					<td style="text-align: right;" <?=($pdf)?'width="14%"':'';?>><?php echo number_format($isss_ptr, 2) ?></td>
					<td style="text-align: right;" <?=($pdf)?'width="14%"':'';?>><?php echo number_format($afp_emp, 2) ?></td>
					<td style="text-align: right;" <?=($pdf)?'width="14%"':'';?>><?php echo number_format($afp_ptr, 2) ?></td>
				</tr>
				<?php
			} else {
				?>
					</tbody>
					<tfoot>
						<tr nobr="true">
							<td style="text-align: right;"><b>TOTAL</b></td>
							<td style="text-align: right;"><?php echo number_format($ings, 2); ?></td>
							<td style="text-align: right;"><?php echo number_format($isse, 2); ?></td>
							<td style="text-align: right;"><?php echo number_format($issp, 2); ?></td>
							<td style="text-align: right;"><?php echo number_format($afpe, 2); ?></td>
							<td style="text-align: right;"><?php echo number_format($afpp, 2); ?></td>
						</tr>
					</tfoot>
				</table>
				<?php
				$emp = $var['ddi_id_emp'];
				$isss_emp = ($var['ddi_valor'] * ($iss->tdc_porcentaje / 100));
				$isss_ptr = ($var['ddi_valor'] * ($iss->tdc_porcentaje_patronal / 100));
				$afp_emp = ($var['ddi_valor'] * ($afp->tdc_porcentaje / 100));
				$afp_ptr = ($var['ddi_valor'] * ($afp->tdc_porcentaje_patronal / 100));
				$ings = number_format($var['ddi_valor'],2,'.','');
				$isse = number_format($isss_emp,2,'.','');
				$issp = number_format($isss_ptr,2,'.','');
				$afpe = number_format($afp_emp,2,'.','');
				$afpp = number_format($afp_ptr,2,'.','');
				echo ($pdf) ? "<br><br>" : "<br>";
				?>
				<table border="1" id="detalles" class="responsive table table-bordered table-condensed display" width="100%">
					<thead>
						<tr nobr="true">
							<th colspan="6"><?php echo $var['emp_codigo'] ?> - <?php echo $var['emp_nombre'] ?> <?php echo $var['emp_apellido'] ?></th>
						</tr>
						<tr nobr="true">
							<th <?=($pdf)?'width="30%"':'';?>>Tipo de Ingreso</th>
							<th <?=($pdf)?'width="14%"':'';?>>Monto del Ingreso</th>
							<th <?=($pdf)?'width="14%"':'';?>>ISSS Empleada/o</th>
							<th <?=($pdf)?'width="14%"':'';?>>ISSS Patronal</th>
							<th <?=($pdf)?'width="14%"':'';?>>AFP Empleada/o</th>
							<th <?=($pdf)?'width="14%"':'';?>>AFP Patronal</th>
						</tr>
					</thead>
					<tbody>
						<tr nobr="true">
							<td <?=($pdf)?'width="30%"':'';?>><?php echo $var['tipo_inn'] ?></td>
							<td style="text-align: right;" <?=($pdf)?'width="14%"':'';?>><?php echo number_format($var['ddi_valor'], 2) ?></td>
							<td style="text-align: right;" <?=($pdf)?'width="14%"':'';?>><?php echo number_format($isss_emp, 2) ?></td>
							<td style="text-align: right;" <?=($pdf)?'width="14%"':'';?>><?php echo number_format($isss_ptr, 2) ?></td>
							<td style="text-align: right;" <?=($pdf)?'width="14%"':'';?>><?php echo number_format($afp_emp, 2) ?></td>
							<td style="text-align: right;" <?=($pdf)?'width="14%"':'';?>><?php echo number_format($afp_ptr, 2) ?></td>
						</tr>
					<?php
			}
		} ?>
		</tbody>
		<tfoot>
			<tr>
				<td style="text-align: right;"><b>TOTAL</b></td>
				<td style="text-align: right;"><?php echo number_format($ings, 2); ?></td>
				<td style="text-align: right;"><?php echo number_format($isse, 2); ?></td>
				<td style="text-align: right;"><?php echo number_format($issp, 2); ?></td>
				<td style="text-align: right;"><?php echo number_format($afpe, 2); ?></td>
				<td style="text-align: right;"><?php echo number_format($afpp, 2); ?></td>
			</tr>
		</tfoot>
	</table>
	<?php
} else {
	?>
	<table border="0" class="responsive table table-bordered table-condensed display" width="100%"><tr><td style="text-align: center;"><b>NO SE ENCONTRARON REGISTROS</b></td></tr></table>
	<?php 
} ?>

