<?php
$pdf = ($tipo_reporte == 'pdf') ? true : false;
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=rep_planilla_calculo_isr.xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
if ($tipo_reporte == 'excel') {
?>
    <meta charset="utf-8" />
    <div class="head">
        <table border="0">
            <tr>
                <td align="center" colspan="5">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte Consolidado de Planillas para Renta
                        <br />
                        Empleada/o: <?= $detalles['empleado'][0]['emp_codigo'] . ' - ' . $detalles['empleado'][0]['emp_nombre'] . ' ' . $detalles['empleado'][0]['emp_apellido'] ?>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php
}
$total_ingreso = $total_isss = $total_afp = $total_otr = $total_isr = $total_afc = 0;
?>
<table class="table table-bordered" cellpadding="1" width="100%" border="0">
    <thead>
        <tr style="text-align: center;">
            <th <?php echo ($pdf) ? 'width="12%"' : ''; ?> style="border: solid 1px black;"><b>Cod. Planilla</b></th>
            <th <?php echo ($pdf) ? 'width="10%"' : ''; ?> style="border: solid 1px black;"><b>Tipo</b></th>
            <th <?php echo ($pdf) ? 'width="16%"' : ''; ?> style="border: solid 1px black;"><b>Documento Empleada/o</b></th>
            <th <?php echo ($pdf) ? 'width="10%"' : ''; ?> style="border: solid 1px black;"><b>Ingresos</b></th>
            <th <?php echo ($pdf) ? 'width="10%"' : ''; ?> style="border: solid 1px black;"><b>ISSS</b></th>
            <th <?php echo ($pdf) ? 'width="10%"' : ''; ?> style="border: solid 1px black;"><b>AFP</b></th>
            <th <?php echo ($pdf) ? 'width="10%"' : ''; ?> style="border: solid 1px black;"><b>Otros Descuentos</b></th>
            <th <?php echo ($pdf) ? 'width="12%"' : ''; ?> style="border: solid 1px black;"><b>Ingresos Afectos</b></th>
            <th <?php echo ($pdf) ? 'width="10%"' : ''; ?> style="border: solid 1px black;"><b>Renta</b></th>
        </tr>
    </thead>
    <tbody>
        <?php if (count($detalles) > 0) {
            $monto = 0;
            foreach ($detalles['ingresos'] as $ky => $var) {
                $monto += array_sum(array_column($var, 'monto'));
            }
            if ($monto > 0) {
                $documento = ($detalles['empleado'][0]['emp_nit'] != "") ? $detalles['empleado'][0]['emp_nit'] : $detalles['empleado'][0]['emp_dui'];
                for ($i = 1; $i < 13; $i++) {
                    $val_isss = $val_afps = $val_otro = $val_isrs = array();
                    foreach ($detalles['descisss'][$i] as $k1 => $iss) {
                        $total_isss += $iss['monto'];
                        $val_isss[$iss['pla_codigo']] = $iss['monto'];
                    }
                    foreach ($detalles['descafps'][$i] as $k2 => $afp) {
                        $total_afp += $afp['monto'];
                        $val_afps[$afp['pla_codigo']] = $afp['monto'];
                    }
                    foreach ($detalles['otrosdes'][$i] as $k2 => $otr) {
                        $total_otr += $otr['monto'];
                        $val_otro[$otr['pla_codigo']] = $otr['monto'];
                    }
                    foreach ($detalles['rentaemp'][$i] as $k2 => $isr) {
                        $total_isr += $isr['monto'];
                        $val_isrs[$isr['pla_codigo']] = $isr['monto'];
                    }
                    foreach ($detalles['ingresos'][$i] as $k => $mes) {
                        $total_ingreso += $mes["monto"];
                        $afecto = $mes["monto"];
                        $afecto -= (isset($val_isss[$mes["pla_codigo"]])) ? number_format($val_isss[$mes["pla_codigo"]], 2) : 0;
                        $afecto -= (isset($val_afps[$mes["pla_codigo"]])) ? number_format($val_afps[$mes["pla_codigo"]], 2) : 0;
                        $afecto -= (isset($val_otro[$mes["pla_codigo"]])) ? number_format($val_otro[$mes["pla_codigo"]], 2) : 0;
                        $total_afc += $afecto;
        ?>
                        <tr nobr=true>
                            <td <?= ($pdf) ? 'width="12%"' : ''; ?>><?= $mes["pla_codigo"]; ?></td>
                            <td <?= ($pdf) ? 'width="10%"' : ''; ?>><?= ($mes["pla_sal"] > 0) ? 'Nomina' : 'Extras'; ?></td>
                            <td <?= ($pdf) ? 'width="16%"' : ''; ?>><?php echo $documento ?></td>
                            <td <?= ($pdf) ? 'width="10%"' : ''; ?> style="text-align: right;"><?= $simbolo ?><?= number_format($mes["monto"], 2) ?></td>
                            <td <?= ($pdf) ? 'width="10%"' : ''; ?> style="text-align: right;"><?= $simbolo ?><?= (isset($val_isss[$mes["pla_codigo"]])) ? number_format($val_isss[$mes["pla_codigo"]], 2) : number_format(0, 2); ?></td>
                            <td <?= ($pdf) ? 'width="10%"' : ''; ?> style="text-align: right;"><?= $simbolo ?><?php echo (isset($val_afps[$mes["pla_codigo"]])) ? number_format($val_afps[$mes["pla_codigo"]], 2) : number_format(0, 2); ?></td>
                            <td <?= ($pdf) ? 'width="10%"' : ''; ?> style="text-align: right;"><?= $simbolo ?><?= (isset($val_otro[$mes["pla_codigo"]])) ? number_format($val_otro[$mes["pla_codigo"]], 2) : number_format(0, 2); ?></td>
                            <td <?= ($pdf) ? 'width="12%"' : ''; ?> style="text-align: right;"><?= $simbolo ?><?= number_format($afecto, 2) ?></td>
                            <td <?= ($pdf) ? 'width="10%"' : ''; ?> style="text-align: right;"><?= $simbolo ?><?= (isset($val_isrs[$mes["pla_codigo"]])) ? number_format($val_isrs[$mes["pla_codigo"]], 2) : number_format(0, 2); ?></td>
                        </tr>
                <?php
                    }
                }
            } else {
                ?>
                <tr>
                    <td colspan="9" style="text-align: center;"><b>No se encontraron registros</b></td>
                </tr>
            <?php
            }
        } else {
            ?>
            <tr>
                <td colspan="9"><b>Ocurrio un error. Solicite soporte</b></td>
            </tr>
        <?php
        }
        ?>
    </tbody>
    <?php
    if (count($detalles) > 0) {
    ?>
        <tfoot>
            <tr>
                <th style="border-top: solid 1px black; text-align: right;" colspan="3"><b>Total</b></th>
                <th style="border-top: solid 1px black; text-align: right;"><?= $simbolo ?><?php echo number_format($total_ingreso, 2); ?></th>
                <th style="border-top: solid 1px black; text-align: right;"><?= $simbolo ?><?php echo number_format($total_isss, 2); ?></th>
                <th style="border-top: solid 1px black; text-align: right;"><?= $simbolo ?><?php echo number_format($total_afp, 2); ?></th>
                <th style="border-top: solid 1px black; text-align: right;"><?= $simbolo ?><?php echo number_format($total_otr, 2); ?></th>
                <th style="border-top: solid 1px black; text-align: right;"><?= $simbolo ?><?php echo number_format($total_afc, 2); ?></th>
                <th style="border-top: solid 1px black; text-align: right;"><?= $simbolo ?><?php echo number_format($total_isr, 2); ?></th>
            </tr>
        </tfoot>
    <?php
    }
    ?>
</table>