<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

$x = ($tipo_reporte == 'exc') ? true : false;
$p = ($tipo_reporte == 'pdf') ? true : false;
if ($x) {
	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	header("content-disposition: attachment;filename=detalle_plan_unica.xls");
	header("Pragma: no-cache");
	header("Expires: 0");
}
$tot_salario = 0;
$tot_adicion = 0;
$tot_vacacio = 0;
?>
<style type="text/css">
	.text {
		mso-number-format: "\@";
	}
</style>
<meta charset="utf-8" />
<table id="tabla_resultados" class="table" border="1">
	<thead>
		<?php if ($x) {
		?>
			<tr>
				<th colspan="7" style="text-align: left;" height="20px">
					<h2><?php echo $this->gsatelite->get_parametro('SYS_EMPRESA'); ?></h2>
				</th>
				<th colspan="3" style="text-align: right; font-size: 8pt; font-weight: bold;"><?= $this->gsatelite->get_parametro('SYS_DEPARTAMENTO') . ', ' . date('d-m-Y H:i:s a'); ?></th>
			</tr>
			<tr>
				<th colspan="7" height="15px" style="text-align: left;">
					<h3>Planilla Unica Previsional</h3>
				</th>
				<th colspan="3" style="text-align: right;"></th>
			</tr>
		<?php } ?>
		<tr>
			<th <?= ($p) ? 'width="8%"' : ''; ?>>Tipo Documento</th>
			<th <?= ($p) ? 'width="10%"' : ''; ?>>Número Documento</th>
			<th <?= ($p) ? 'width="8%"' : ''; ?>>Número ISSS</th>
			<th <?= ($p) ? 'width="8%"' : ''; ?>>Instituto Previsional</th>
			<th <?= ($p) ? 'width="25%"' : ''; ?>>Nombre del Empleada/o</th>
			<th <?= ($p) ? 'width="9%"' : ''; ?>>Salario Devengado</th>
			<th <?= ($p) ? 'width="9%"' : ''; ?>>Vacaciones</th>
			<th <?= ($p) ? 'width="9%"' : ''; ?>>Pagos Adicionales</th>
			<th <?= ($p) ? 'width="7%"' : ''; ?>>Días Trabajados</th>
			<th <?= ($p) ? 'width="7%"' : ''; ?>>Días Vacaciones</th>
		</tr>
	</thead>
	<tbody>
		<?php
		if (count($consulta) > 0) {
			foreach ($consulta as $key => $fila) {
				$doc_emp = explode('##', $fila['doc_emp']);
				$tot_salario += number_format($fila['sal_dev_no_vac'], 2, '.', '');
				$tot_adicion += number_format($fila['adicional'], 2, '.', '');
				$tot_vacacio += number_format(($fila['vacaciones'] + $fila['prima_vacaciones']), 2, '.', '');
				$dias = (floor($fila['dias_trabajados']) > $max_dias) ? $max_dias :  floor($fila['dias_trabajados']);
				if ($fila['permiso_sin_goce'] > 0) {
					$dias = $dias - $fila['permiso_sin_goce'];
				}
				if ($fila['incapacidades'] > 0) {
					$dias = $dias - $fila['incapacidades'];
				}
				if ($fila['vaca_dias'] > 0) {
					$dias = $dias - $fila['vaca_dias'];
				}
				$dias = ($dias > 0) ? $dias : 0;
		?>
				<tr nobr="true" style="text-align:left;">
					<td <?= ($p) ? 'width="8%"' : ''; ?>><?php echo $doc_emp[1]; ?></td>
					<td <?= ($p) ? 'width="10%"' : ''; ?>><?php echo $doc_emp[2]; ?></td>
					<td <?= ($p) ? 'width="8%"' : ''; ?>><?php echo $fila['emp_seguro']; ?></td>
					<td <?= ($p) ? 'width="8%"' : ''; ?>><?php echo $fila['afp_codigo']; ?></td>
					<td <?= ($p) ? 'width="25%"' : ''; ?>><?php echo trim($fila['emp_nombre']) . ' ' . trim($fila['emp_apellido']); ?></td>
					<td <?= ($p) ? 'width="9%"' : ''; ?> style="text-align: right;"><?= $simbolo ?><?php echo number_format($fila['sal_dev_no_vac'], 2); ?></td>
					<td <?= ($p) ? 'width="9%"' : ''; ?> style="text-align: right;"><?= $simbolo ?><?php echo number_format(($fila['vacaciones'] + $fila['prima_vacaciones']), 2); ?></td>
					<td <?= ($p) ? 'width="9%"' : ''; ?> style="text-align: right;"><?php echo number_format($fila['adicional'], 2); ?></td>
					<td <?= ($p) ? 'width="7%"' : ''; ?> style="text-align: right;"><?php echo $dias; ?></td>
					<td <?= ($p) ? 'width="7%"' : ''; ?> style="text-align: right;"><?php echo $fila['vaca_dias']; ?></td>
				</tr>
			<?php
			}
		} else {
			if ($tipo_reporte != "") {
			?>
				<tr>
					<td colspan="13" style="text-align: center; font-weight: bold;">Sin Registros</td>
				</tr>
		<?php
			}
		} ?>
	</tbody>
	<?php if (count($consulta) > 0) {
	?>
		<tfoot>
			<tr>
				<th colspan="5" style="text-align: right;">Totales</th>
				<th style="text-align: right;"><?= $simbolo ?><?php echo number_format($tot_salario, 2) ?></th>
				<th style="text-align: right;"><?= $simbolo ?><?php echo number_format($tot_vacacio, 2) ?></th>
				<th style="text-align: right;"><?= $simbolo ?><?php echo number_format($tot_adicion, 2) ?></th>
				<th colspan="2"></th>
			</tr>
		</tfoot>
	<?php
	} ?>
</table>
<?php if ($tipo_reporte == "") {
?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('#tabla_resultados').dataTable({
				"sPaginationType": "full_numbers",
				"bJQueryUI": false,
				"bAutoWidth": true,
				"iDisplayLength": 10,
				"bLengthChange": true,
				"bDestroy": true,
				"fnInitComplete": function(oSettings, json) {
					$('.dataTables_filter>label>input').attr('id', 'search');
				}
			});
		});
	</script>
<?php
} ?>