<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

$pdf = ($reporte == 'pdf') ? true : false;
if ($reporte == 'excel') {
	header("Content-Type: application/vnd.ms-excel");
	header("Expires: 0");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("content-disposition: attachment;filename=" . $filename . ".xls");

?>
	<meta charset="utf-8" />
	<div class="head">
		<table>
			<tr>
				<td align="center" colspan="6">
					<h4>
						<?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?>
						<br />
						<span>Reporte de Otros Descuentos por Empleada/o en Planilla: <?= $tipo_plan ?></span>
					</h4>
					<span><?= (count($registros) > 0) ? "Desde " . formatear_fecha('d/m/Y', $registros[0]['desde']) . " Hasta " . formatear_fecha('d/m/Y', $registros[0]['hasta']) : ""; ?></span>
				</td>
			</tr>
		</table>
	</div>
	<br>
<?php
} ?>
<table border="1" id="detalles" class="responsive table table-bordered table-condensed">
	<thead>
		<tr style="font-weight:bold;">
			<th <?= ($pdf) ? 'width="10%"' : ''; ?>>Código</th>
			<th <?= ($pdf) ? 'width="30%"' : ''; ?>>Empleada/o</th>
			<th <?= ($pdf) ? 'width="25%"' : ''; ?>>Concepto</th>
			<th <?= ($pdf) ? 'width="20%"' : ''; ?>>Observaciones</th>
			<th <?= ($pdf) ? 'width="15%"' : ''; ?>>Monto</th>
		</tr>
	</thead>
	<tbody>
		<?php
		$total_ingresos = 0;
		if (count($registros) > 0) {
			foreach ($registros as $key => $fila) {
				$total_ingresos += number_format($fila['ddd_valor'], 2, '.', '');
		?>
				<tr nobr="true">
					<td <?= ($pdf) ? 'width="10%"' : ''; ?>><?php echo $fila['emp_codigo']; ?></td>
					<td <?= ($pdf) ? 'width="30%"' : ''; ?>><?php echo $fila['emp_nombre'] . ' ' . $fila['emp_apellido']; ?></td>
					<td <?= ($pdf) ? 'width="25%"' : ''; ?>><?php echo $fila['tdc_nombre']; ?></td>
					<td <?= ($pdf) ? 'width="20%"' : ''; ?>><?php echo $fila['dss_motivo']; ?></td>
					<td <?= ($pdf) ? 'width="15%"' : ''; ?> style="text-align:right;"><?= $simbolo ?><?php echo number_format($fila['ddd_valor'], 2); ?></td>
				</tr>
			<?php
			}
		} else {
			if ($reporte != '') {
			?>
				<tr>
					<td colspan="5" style="text-align: center;"><b>No se encontraron Registros</b></td>
				</tr>
		<?php
			}
		}
		?>
	</tbody>
	<?php if (count($registros) > 0) { ?>
		<tfoot>
			<tr>
				<td colspan="4" style="text-align: right;"><b>Total</b></td>
				<td style="text-align:right;"><b><?= $simbolo ?><?php echo number_format($total_ingresos, 2, '.', ','); ?></b></td>
			</tr>
		</tfoot>
	<?php } ?>
</table>
<?php if ($reporte == '') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#detalles").dataTable();
		});
	</script>
<?php } ?>