<?php
function vvalid($var)
{
	return $var > 0;
} //solo deja los meses que tienen ingresos
$dias = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES', 30);
$mesA = array(1 => 'ENE', 2 => 'FEB', 3 => 'MAR', 4 => 'ABR', 5 => 'MAY', 6 => 'JUN', 7 => 'JUL', 8 => 'AGO', 9 => 'SEP', 10 => 'OCT', 11 => 'NOV', 12 => 'DIC');
$m_v = array(1 => 0, 2 => 0, 3 => 0, 4 => 0, 5 => 0, 6 => 0, 7 => 0, 8 => 0, 9 => 0, 10 => 0, 11 => 0, 12 => 0);
$pdf = ($reporte == 'pdf') ? true : false;
if ($reporte == 'excel') {
	header("Content-Type: application/vnd.ms-excel");
	header("Expires: 0");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("content-disposition: attachment;filename=" . $filename . ".xls");
?>
	<meta charset="utf-8" />
	<div class="head">
		<table>
			<tr>
				<td align="center" colspan="6">
					<h4>
						<?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?>
						<br />
						<span>Reporte Anual de Ingresos Mensuales por Empleada/o</span> <span><?= $periode ?></span>
					</h4>
				</td>
			</tr>
		</table>
	</div>
	<div>
		<table>
			<tr>
				<td style="border: 1px solid black;" colspan="2"><strong>Ingresos Seleccionados:</strong></td>
				<td style="border: 1px solid black; width: 20%; text-align: center;" colspan="4"><?php echo ($ingresos != '') ? $ingresos : "(TODOS)"; ?></td>
			</tr>
		</table>
	</div>
	<div>
		<table>
			<tr>
				<td style="border: 1px solid black;" colspan="2"><strong>Tipos de Planillas Seleccionadas:</strong></td>
				<td style="border: 1px solid black; width: 20%; text-align: center;" colspan="4"><?php echo ($tip_plan != '') ? $tip_plan : "(TODAS)"; ?></td>
			</tr>
		</table>
	</div>
	<br>
<?php
}
if ($reporte == 'pdf') {
?>
	<table width="100%" border="1" style="font-size: 6;">
		<tr>
			<td width="20%"><strong>Ingresos Seleccionados: </strong></td>
			<td width="80%"><?php echo ($ingresos != '') ? $ingresos : "(TODOS)"; ?>.</td>
		</tr>
		<tr>
			<td width="20%"><strong>Tipos de Planillas Seleccionadas: </strong></td>
			<td width="80%"><?php echo ($tip_plan != '') ? $tip_plan : "(TODAS)"; ?>.</td>
		</tr>
	</table>
<?php
}
?><br><br>
<table border="1" id="detalles" class="responsive table table-bordered table-condensed" style="font-size: <?= ($pdf) ? 5 : 11; ?>;">
	<thead>
		<tr nobr="true">
			<th rowspan="2" style="text-align: center; vertical-align: middle; <?= ($pdf) ? 'width: 4%;' : ''; ?>">Código</th>
			<th rowspan="2" style="text-align: center; vertical-align: middle; <?= ($pdf) ? 'width: 5%;' : ''; ?>">Empleada/o</th>
			<th rowspan="2" style="text-align: center; vertical-align: middle; <?= ($pdf) ? 'width: 5%;' : ''; ?>">Área</th>
			<th rowspan="2" style="text-align: center; vertical-align: middle; <?= ($pdf) ? 'width: 5%;' : ''; ?>">Cargo</th>
			<th rowspan="2" style="text-align: center; vertical-align: middle; <?= ($pdf) ? 'width: 5%;' : ''; ?>">Tipo Planilla</th>
			<th rowspan="2" style="text-align: center; vertical-align: middle; <?= ($pdf) ? 'width: 4%;' : ''; ?>">Salario</th>
			<th rowspan="2" style="text-align: center; vertical-align: middle; <?= ($pdf) ? 'width: 5%;' : ''; ?>">Fecha Contrato</th>
			<th rowspan="2" style="text-align: center; vertical-align: middle; <?= ($pdf) ? 'width: 5%;' : ''; ?>">Fecha Antigüedad</th>
			<th rowspan="2" style="text-align: center; vertical-align: middle; <?= ($pdf) ? 'width: 4%;' : ''; ?>">Tipo Contrato</th>
			<th colspan="12" style="text-align: center; <?= ($reporte != "") ? '' : 'color: white; background: #0167B1;'; ?><?= ($pdf) ? 'width: 48%' : ''; ?>">Detalle Mensual</th>
			<th rowspan="2" style="text-align: center; vertical-align: middle; <?= ($pdf) ? 'width: 6%;' : ''; ?>">Total</th>
			<th rowspan="2" style="text-align: center; vertical-align: middle; <?= ($pdf) ? 'width: 4%;' : ''; ?>">Promedio<?= ($dias_mes != "") ? '<br>(' . $dias_mes . ' días)' : ''; ?></th>
		</tr>
		<tr style="text-align: center;">
			<?php foreach ($mesA as $k => $var) {
			?><th style="text-align: center; <?= ($pdf) ? 'width: 4%;' : ''; ?>"><?= $var ?><?= ($det_dias[$k] != "") ? '<br>(' . $det_dias[$k] . ' días)' : ''; ?></th><?php
																																									} ?>
		</tr>
	</thead>
	<tbody>
		<?php
		$total_general = $mesesprom = 0;
		if (count($registros) > 0) {
			foreach ($registros as $key => $v) {
				$dias_promedio = ($v['salario_promediado'] > 0 && $dias_mes > 0) ? ($dias / $dias_mes) : 0;
				$emp_anual_ingresos = $v['ingresos'];
				$suma_empleado = array_sum($emp_anual_ingresos);
				$meses_ins = count(array_filter($emp_anual_ingresos, "vvalid"));
				$prom_empleado = ($dias_promedio > 0) ? ($suma_empleado * $dias_promedio) : $suma_empleado / $meses_ins;
				$total_general += $suma_empleado;
				if ($suma_empleado > 0) {
		?>
					<tr nobr="true">
						<td style="<?= ($pdf) ? 'width: 4%;' : ''; ?>"><?php echo $v['emp_codigo']; ?></td>
						<td style="<?= ($pdf) ? 'width: 5%;' : ''; ?>"><?php echo $v['emp_nombre'] . ' ' . $v['emp_apellido']; ?></td>
						<td style="<?= ($pdf) ? 'width: 5%;' : ''; ?>"><?php echo $v['are_nombre']; ?></td>
						<td style="<?= ($pdf) ? 'width: 5%;' : ''; ?>"><?php echo $v['plz_nombre']; ?></td>
						<td style="<?= ($pdf) ? 'width: 5%;' : ''; ?>"><?php echo $v['all_tpls']; ?></td>
						<td style="text-align: right; <?= ($pdf) ? 'width: 4%;' : ''; ?>"><?= $simbolo ?><?php echo $v['emp_salario']; ?></td>
						<td style="<?= ($pdf) ? 'width: 5%;' : ''; ?>"><?php echo formatear_fecha('d-m-Y', $v['emp_fecha_contrato']); ?></td>
						<td style="<?= ($pdf) ? 'width: 5%;' : ''; ?>"><?php echo formatear_fecha('d-m-Y', $v['emp_fecha_antiguedad']); ?></td>
						<td style="<?= ($pdf) ? 'width: 4%;' : ''; ?>"><?php echo $v['tic_nombre']; ?></td>
						<?php for ($i = 1; $i <= 12; $i++) {
							$m_v[$i] += $emp_anual_ingresos[$i];
						?><td style="text-align: right; <?= ($pdf) ? 'width: 4%;' : ''; ?>"><?php echo $simbolo . number_format($emp_anual_ingresos[$i], 2); ?></td><?php
																																								} ?>
						<td style="text-align:right; <?= ($pdf) ? 'width: 6%;' : ''; ?>"><?= $simbolo ?><?php echo number_format($suma_empleado, 2); ?></td>
						<td style="text-align:right; <?= ($pdf) ? 'width: 4%;' : ''; ?>"><?= $simbolo ?><?php echo number_format($prom_empleado, 2); ?></td>
					</tr>
				<?php
				}
			}
		} else {
			if ($reporte != '') {
				?>
				<tr>
					<td colspan="23" style="text-align: center;"><b>No se encontraron Registros</b></td>
				</tr>
		<?php
			}
		}
		?>
	</tbody>
	<?php if (count($registros) > 0) { ?>
		<tfoot>
			<tr>
				<td colspan="9" style="text-align: right;"><b>Totales</b></td>
				<?php for ($i = 1; $i <= 12; $i++) { ?>
					<td style="text-align: right;"><?php echo number_format($m_v[$i], 2); ?></td>
				<?php } ?>
				<td style="text-align:right;"><b><?= $simbolo ?><?php echo number_format($total_general, 2); ?></b></td>
				<td></td>
			</tr>
		</tfoot>
	<?php } ?>
</table>
<?php if ($reporte == '') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#detalles").dataTable();
		});
	</script>
<?php } ?>