<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
$pdf = ($tipo_reporte == 'pdf') ? true : false;
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

if ($tipo_reporte == 'excel') {
?>
    <meta charset="utf-8" />
    <div class="head">
        <table border="0">
            <tr>
                <td align="center" colspan="5">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Descuento por Empleada/o
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php
}

if (count($detalles) > 0) {
?>
    <table class="table table-bordered" cellpadding="1" width="100%" border="0">
        <tr>
            <th <?php echo ($pdf) ? 'width="15%"' : ''; ?>><b>Empleada/o:</b></th>
            <td <?php echo ($pdf) ? 'width="40%"' : ''; ?>><?php echo $detalles[0]['emp_nombre'] . ' ' . $detalles[0]['emp_apellido']; ?></td>
            <th <?php echo ($pdf) ? 'width="15%"' : ''; ?>><b>Tipo Descuento:</b></th>
            <td <?php echo ($pdf) ? 'width="30%"' : ''; ?>><?php echo ($detalles[0]['dss_permanente'] > 0) ? "Periódico" : "Único"; ?></td>
        </tr>
        <tr>
            <th><b>Descuento:</b></th>
            <td><?php echo $detalles[0]['tdc_nombre']; ?></td>
            <th><b>Referencia:</b></th>
            <td><?php echo $detalles[0]['dss_referencia']; ?></td>
        </tr>
        <tr>
            <th><b>Fecha Inicio:</b></th>
            <td><?php echo formatear_fecha('d-m-Y', $detalles[0]['dss_fecha_desde']); ?></td>
            <th><b>Concepto:</b></th>
            <td><?php echo $detalles[0]['dss_motivo']; ?></td>
        </tr>
        <tr>
            <th><b>Valor Cuota:</b></th>
            <td><?= $simbolo ?><?php echo number_format($detalles[0]['dss_valor'], 2); ?></td>
            <th><b>Cuotas:</b></th>
            <td><?php echo ($detalles[0]['dss_cuota'] > 0) ? $detalles[0]['dss_cuota'] : 'No definido'; ?></td>
        </tr>
    </table>
<?php
}
?>
<table class="table table-bordered" cellpadding="1" width="100%" border="<?php echo ($tipo_reporte != '') ? 1 : 0; ?>">
    <thead>
        <tr style="text-align: center;">
            <th <?php echo ($pdf) ? 'width="10%"' : ''; ?>><b>Cuota #</b></th>
            <th <?php echo ($pdf) ? 'width="40%"' : ''; ?>><b>Tipo de planilla</b></th>
            <th <?php echo ($pdf) ? 'width="15%"' : ''; ?>><b>Inicio de planilla</b></th>
            <th <?php echo ($pdf) ? 'width="15%"' : ''; ?>><b>Fin de planilla</b></th>
            <th><b>Monto</b></th>
        </tr>
    </thead>
    <tbody>
        <?php
        if (count($detalles) > 0) {
            $total = 0;
            foreach ($detalles as $key => $val) {
                $total += number_format($val['ddd_valor'], 2, '.', '');
        ?>
                <tr>
                    <td <?php echo ($pdf) ? 'width="10%"' : ''; ?>><?php echo ($key + 1); ?></td>
                    <td <?php echo ($pdf) ? 'width="40%"' : ''; ?>><?php echo $val['pla_codigo'] . ' - ' . $val['tpl_nombre']; ?></td>
                    <td <?php echo ($pdf) ? 'width="15%"' : ''; ?>><?php echo formatear_fecha('d-m-Y', $val['pla_fecha_inicio']); ?></td>
                    <td <?php echo ($pdf) ? 'width="15%"' : ''; ?>><?php echo formatear_fecha('d-m-Y', $val['pla_fecha_fin']); ?></td>
                    <td style="text-align: right;"><?= $simbolo ?><?php echo number_format($val['ddd_valor'], 2) ?></td>
                </tr>
            <?php
            }
        } else {
            ?>
            <tr>
                <td colspan="5" style="text-align:center;"><b>No se encontraron registros con los filtros seleccionados</b></td>
            </tr>
        <?php
        }
        ?>
    </tbody>
    <?php
    if (count($detalles) > 0) {
    ?>
        <tfoot>
            <tr>
                <th style="text-align: right;" colspan="4"><b>Total</b></th>
                <th style="text-align: right;"><?= $simbolo ?><?php echo number_format($total, 2); ?></th>
            </tr>
        </tfoot>
    <?php
    }
    ?>
</table>