<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

$pdf = ($reporte == 'pdf') ? true : false;
if ($reporte == 'excel') {
	header("Content-Type: application/vnd.ms-excel");
	header("Expires: 0");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("content-disposition: attachment;filename=prom_comisiones.xls");
?>
	<meta charset="utf-8" />
	<div class="head">
		<table>
			<tr>
				<td align="center" colspan="6">
					<h4>
						<?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?>
						<br />
						<span>Reporte de Promedio de Ingresos por Comisiones por Empleada/o</span>
					</h4>
				</td>
			</tr>
		</table>
	</div>
	<br>
<?php
}
$mes = array('01' => 'Ene', '02' => 'Feb', '03' => 'Mar', '04' => 'Abr', '05' => 'May', '06' => 'Jun', '07' => 'Jul', '08' => 'Ago', '09' => 'Sep', '10' => 'Oct', '11' => 'Nov', '12' => 'Dic');
$meses = (count($registros) > 0) ? $registros[0] : array();
$periodos = array();
$cols = 5;
if (count($meses) > 0) {
	$cols += $meses['rows'];
	for ($i = 1; $i <= $meses['rows']; $i++) {
		$n = 'pm' . $i;
		$periodos[$i] = str_split($meses[$n], 4);
	}
} ?>
<table border="1" id="detalles" class="responsive table table-bordered table-condensed">
	<thead>
		<tr style="font-weight:bold;">
			<th <?= ($pdf) ? 'width="5%"' : ''; ?>>Código</th>
			<th <?= ($pdf) ? 'width="20%"' : ''; ?>>Empleada/o</th>
			<?php foreach ($periodos as $key => $value) { ?>
				<th <?= ($pdf) ? 'width="8%"' : ''; ?>><?php echo $mes[$value[1]] ?> - <?php echo $value[0] ?></th>
			<?php } ?>
			<th <?= ($pdf) ? 'width="9%"' : ''; ?>>Total Ingresos</th>
			<th <?= ($pdf) ? 'width="9%"' : ''; ?>>Dias Promedio</th>
			<th <?= ($pdf) ? 'width="9%"' : ''; ?>>Monto Promedio</th>
		</tr>
	</thead>
	<tbody>
		<?php
		// $total_mensual = array();
		if (count($registros) > 0) {
			foreach ($registros as $key => $fila) {
				$com_promedio = ($fila['total_ingreso'] / $fila['total_dias']) * 30;
				// $total_ingresos += number_format($fila['ddd_valor'], 2, '.', '');
		?>
				<tr nobr="true">
					<td <?= ($pdf) ? 'width="5%"' : ''; ?>><?php echo $fila['emp_codigo']; ?></td>
					<td <?= ($pdf) ? 'width="20%"' : ''; ?>><?php echo $fila['emp_nombre'] . ' ' . $fila['emp_apellido']; ?></td>
					<?php foreach ($periodos as $k => $value) { ?>
						<td <?= ($pdf) ? 'width="8%"' : ''; ?> style="text-align:right;"><?= $simbolo ?><?php echo number_format($fila['m' . $k], 2); ?></td>
					<?php } ?>
					<td <?= ($pdf) ? 'width="9%"' : ''; ?> style="text-align:right;"><?= $simbolo ?><?php echo $fila['total_ingreso']; ?></td>
					<td <?= ($pdf) ? 'width="9%"' : ''; ?> style="text-align:right;"><?php echo $fila['total_dias']; ?></td>
					<td <?= ($pdf) ? 'width="9%"' : ''; ?> style="text-align:right;"><?= $simbolo ?><?php echo number_format($com_promedio, 2); ?></td>
				</tr>
			<?php
			}
		} else {
			if ($reporte != '') {
			?>
				<tr>
					<td colspan="<?php echo $cols ?>" style="text-align: center;"><b>No se encontraron Registros</b></td>
				</tr>
		<?php
			}
		}
		?>
	</tbody>
	<?php if (false && count($registros) > 0) { ?>
		<tfoot>
			<tr>
				<td colspan="4" style="text-align: right;"><b>Total</b></td>
				<td style="text-align:right;"><b><?= $simbolo ?><?php echo number_format($total_ingresos, 2, '.', ','); ?></b></td>
			</tr>
		</tfoot>
	<?php } ?>
</table>
<?php if ($reporte == '') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#detalles").dataTable();
		});
	</script>
<?php } ?>