<?php
$unipre = $lintra = $codpre = '-';
$siglas = $this->gsatelite->get_parametro('SYS_SIGLAS', '');
$empresa = $this->gsatelite->get_parametro('SYS_EMPRESA', '');
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', '');
$cargo_firma = $this->gsatelite->get_parametro_emp('SYS_FIRMA_CONSTANCIA', '');
$image_firma_sbase = file_exists('media/acciones_personal/firma_constancias.png');
$image_firma_cbase = file_exists(base_url().'media/acciones_personal/firma_constancias.png');
$hay_firma = ($image_firma_cbase) ? $image_firma_cbase : $image_firma_sbase;
$meses = array('',  'enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre');
$nombre = $cons_trabajo[0]['emp_nombre'] . " " . $cons_trabajo[0]['emp_apellido'];
$dia_contrato = formatear_fecha('d', $cons_trabajo[0]['emp_fecha_contrato']);
$mes_contrato = formatear_fecha('n', $cons_trabajo[0]['emp_fecha_contrato']);
$ano_contrato = formatear_fecha('Y', $cons_trabajo[0]['emp_fecha_contrato']);
$dia_contrato_letra = ($cons_trabajo[0]['emp_fecha_contrato'] != "") ? strtolower($this->enletras->num2letras($dia_contrato)) : '-';
$mes_contrato_letra = ($cons_trabajo[0]['emp_fecha_contrato'] != "") ? $meses[$mes_contrato] : '-';
$ano_contrato_letra = ($cons_trabajo[0]['emp_fecha_contrato'] != "") ? strtolower($this->enletras->num2letras($ano_contrato)) : '-';
if (trim($cons_trabajo[0]['plz_nombre']) != '') {
	$plaza = $cons_trabajo[0]['plz_nombre'];
} elseif (trim($cons_trabajo[0]['pto_nombre']) != '') {
	$plaza = $cons_trabajo[0]['pto_nombre'];
} else {
	$plaza = '-';
}
$tipo_salario = ($cons_trabajo[0]['plz_forma_pagos'] > 0) ?  "Ley de Salarios" : "Contrato";
if ($cons_trabajo[0]['plz_id_unp'] > 0) {
	$unprow = $this->gsatelite->get_registro("unp_unidad_presupuestaria", array("unp_id" => $cons_trabajo[0]['plz_id_unp']));
	$unipre = $unprow->unp_codigo . ' ' . mb_strtolower($unprow->unp_nombre, 'UTF-8');
}
if ($cons_trabajo[0]['plz_id_lnt'] > 0) {
	$lntrow = $this->gsatelite->get_registro("lnt_linea_trabajo", array("lnt_id" => $cons_trabajo[0]['plz_id_lnt']));
	$lintra = $lntrow->lnt_codigo . ' ' . mb_strtolower($lntrow->lnt_nombre, 'UTF-8');
}
if ($cons_trabajo[0]['plz_id_cip'] > 0) {
	$ciprow = $this->gsatelite->get_registro("cip_cifrado_presupuestario", array("cip_id" => $cons_trabajo[0]['plz_id_cip']));
	$codpre = mb_strtolower($ciprow->cip_nombre, 'UTF-8');
}
$hoy = date('d');
switch ($hoy) {
	case 1: $dia_act = 'un'; break;
	case 21: $dia_act = 'veintiún'; break;
	case 31: $dia_act = 'treinta y un'; break;
	default: $dia_act = strtolower($this->enletras->num2letras($hoy)); break;
}
$mes_act = $meses[date('n')];
$ano_act = strtolower($this->enletras->num2letras(date('Y')));
$salario_ficha = number_format($cons_trabajo[0]['emp_salario'], 2);
$city_instituc = (trim($cons_trabajo[0]['mun_rh']) != "") ? trim($cons_trabajo[0]['mun_rh']) : "San Salvador";
$sueldo = ($sueldo_base > 0) ? $sueldo_base : $salario_ficha;
$salario_array = explode(".", number_format($sueldo, 2, '.',''));
$salario_letra = strtolower($this->enletras->num2letras($salario_array[0]));
$dec = $salario_array[1];
// var_dump($salario_letra);die();
echo $header;
?>
<style type="text/css">
	.encabeza{
		text-align: left;
		line-height: 1.4;
	}
	.consta{
		text-align: left; 
		font-weight: bold !important;
	}
	.cuerpo{
		text-indent: 40px; 
		line-height: 1.4;
		text-align: justify;
	}
	.emite{
		text-indent: 40px; 
		line-height: 1.4;
		text-align: justify;
	}
	div.Section1 {
		font-size: 9pt !important;
	}
</style>
<table border="0" style="font-family: 'Arial', serif; font-size:11px;" >
	<?php if ($dirigidoa != "") {
		?>
		<tr>
			<td>
				<p style="text-align: left;font-family: 'Arial', serif; font-size:11pt;"><br><br>
					SEÑORES<br><b><?php echo mb_strtoupper($dirigidoa, 'UTF-8') . ':'; ?></b>
				</p>
			</td>
		</tr>
		<?php
	} ?>
	<tr>
		<td>
			<p class="encabeza"><br><br>
				La Infrascrita Jefa de la Unidad de Talento Humano del <?= $empresa ?> - <?= $siglas ?>:
			</p>
		</td>
	</tr>
	<tr>
		<td>
			<p class="consta"><br><br>
				<b>HACE CONSTAR:</b><br>
			</p>
		</td>
	</tr>
	<tr>
		<td height="120px">
			<p class="cuerpo">
				Que la empleada <?= mb_convert_case($nombre, MB_CASE_TITLE, "UTF-8") ?> labora en esta institución desde el <?= $dia_contrato_letra ?> de <?= $mes_contrato_letra ?> 
				del año <?= $ano_contrato_letra ?> hasta la fecha, desempeñándose en la Plaza de <?= $plaza ?>, en la Unidad Presupuestaria: 
				<?= mb_substr($unipre, 0, null, "UTF-8") ?>, Línea de Trabajo: <?= mb_substr($lintra, 0, null, "UTF-8") ?>, Código Presupuestario 
				<?= mb_substr($codpre, 0, null, "UTF-8") ?>, por <?= $tipo_salario ?>, devengando un salario mensual de <?= mb_strtolower($salario_letra, 'UTF-8') ?> 
				<?= $dec ?>/100 dólares (<?= $simbolo ?> <?= number_format($sueldo, 2) ?>).
			</p>
		</td>
	</tr>
	<tr>
		<td height="60px">
			<p class="emite">
				Y a solicitud de la empleada <?= mb_convert_case($nombre, MB_CASE_TITLE, "UTF-8") ?>, se firma y sella la presente en 
				<?= mb_convert_case($city_instituc, MB_CASE_TITLE, "UTF-8") ?>, a los <?= $dia_act ?> días del mes de <?= $mes_act ?> de <?= $ano_act ?>.
			</p>
		</td>
	</tr>
	<tr>
		<td style="text-align: center;">
			<div style="font-size:10pt;float:center;">
				<?php
				if ($tipo_descarga > 0 && $hay_firma) {
					$base = (!$image_firma_cbase && $image_firma_sbase) ? '' : base_url();
					?>
					<table border="0">
						<tr>
							<td style="text-align:center;"><br><br>
								<img height="100" width="150" src="<?= $base . 'media/acciones_personal/firma_constancias.png'; ?>">
							</td>
						</tr>
						<tr>
							<td>
								<?php
							} ?>
							<p style="float:center;">F._____________________________________<br>
								<?= $this->gsatelite->get_parametro_emp('SIS_JEFE_RRHH'); ?><br>
								<?= $this->gsatelite->get_parametro_emp('SYS_FIRMA_CONSTANCIA'); ?>
							</p>
							<?php if ($tipo_descarga > 0 && $hay_firma) {
								?>
							</td>
						</tr>
					</table>
				<?php } ?>
			</div>
		</td>
	</tr>
	<tr>
		<td height="40px">
		</td>
	</tr>
</table>
<div class="Section1">
	<table id='hrdftrtbl' width="100%" height="1%" border='0' cellspacing='0' cellpadding='0'>
		<div style='mso-element:footer' id=f1>
			<div style="text-align: center; font-family: 'Arial', serif; ">
				<?php echo $this->gsatelite->get_parametro_emp('SYS_DOMICILIO', ''); ?><br>
				Teléfono <?php echo $this->gsatelite->get_parametro_emp('SYS_TEL'); ?><br>
				<?php echo $this->gsatelite->get_parametro_emp('SYS_DEPARTAMENTO'); ?>
				<?php echo $this->gsatelite->get_parametro_emp('SYS_PAIS'); ?><br>
			</div>
		</div>
	</table>
</div>