<script type="text/javascript">
    $(document).ready(function(){
        $("a").addClass("tipB");
        var pathArray = window.location.pathname.split( '/' );
        var urlj=url_base_proyecto;
        $('#tabla').dataTable();
        $('#tabla').css('margin-top','2px');
        $('#crear_empleado').click(function(){
            $(location).attr('href', urlj + "personal/empleado/agregar_empleado");
        });
        $("#slcEstado").select2();

        $("#frmConsultaform").validate({
            ignore: "",
            rules: {
                slcEstado: { required: true}
            },
            messages: {
                slcEstado: "Campo requerido"
            },
            ignore: ".select2-container",
            errorPlacement: function (error, element) {
                if (element.is('select')){
                    $(element).next().append(error);
                } else { 
                    error.insertAfter(element);
                }
            },
            submitHandler: function (form) {
                wait.start();
                form.submit();
            }
        });

    });
</script>
<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4>Filtrar</h4>
            </div>
            <div class="content">
                <form method="POST" id="frmConsultaform" name="frmConsultaform">
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="span8">
                                <div class="row-fluid">
                                    <label class="form-label span4" for="normal" style="margin-right: 5px;">Estado:<span style="color:red;">*</span></label>
                                    <div class="span4">
                                        <select id="slcEstado" name="slcEstado" required placeholder="Seleccione" style="width: 100%" class="nostyle">
                                            <option value=""></option>
                                            <option value="1" <?php echo ($estado_emp == 1)? "selected":""; ?> >Activos</option>
                                            <option value="0" <?php echo ($estado_emp == 0)? "selected":""; ?> >Inactivos</option>
                                        </select>
                                        <span id="error_slcEstado"></span>
                                    </div>
                                    <div class="span1"></div>
                                    <div class="span3">
                                        <button class="btn btn-info" id="btnConsultar" name="btnConsultar" type="submit"><span class="icon16 icomoon-icon-search-3 white"></span> Consultar</button>
                                    </div>
                                </div>
                            </div>
                            <div class="span4">&nbsp;</div>
                        </div>
                    </div>
                </form><!-- Fin formulario filtrar --> 
            </div> <!-- Fin content -->
        </div><!-- End .box -->
    </div>
</div>
<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4>
                    <span></span>
                </h4>
            </div>
            <div class="content noPad clearfix">
                <table id="tabla"cellpadding="0" cellspacing="0" border="0" class="responsive table table-bordered" width="100%">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Código</th>
                            <th>Nombres</th>   
                            <th>Apellidos</th>                        
                            <th>Plaza</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($total_empleados){
                            $numero_fila = 1;
                            foreach ($total_empleados as $emp) { ?>
                                <tr >
                                    <td><?= $emp['emp_id'] ?></td>
                                    <td><?= $emp['emp_codigo'] ?></td>
                                    <td><?= $emp['emp_nombre'] ?></td>
                                    <td><?= $emp['emp_apellido'] ?></td>                            
                                    <td><?= $emp['plz_nombre'] ?></td>
                                    <td><?= ($emp['emp_estado'] ==1) ? 'Activo' : 'Inactivo'; ?></td>
                                    <?php if($emp['emp_estado']==1){ ?>
                                        <td>
                                            <div class="controls center">
                                                <a class="btn btn-info tipB" title="Gestionar Ingresos y descuentos" href="<?=base_url('personal/planilla/ingreso_descuento_empleado/'.$emp['emp_id'])?>" >
                                                    <span aria-hidden="true" class="icomoon-icon-bars"></span>
                                                </a>
                                                <!-- <span class="btn btn-info tipB icomoon-icon-bars" title="Gestionar Ingresos y descuentos" data-href="<?=base_url('personal/planilla/ingreso_descuento_empleado/'.$emp['emp_id'])?>" >
                                                </span> -->
                                            </div>
                                        </td>
                                    <?php } else {?>
                                        <td>
                                            <div class="controls center">
                                                <a class="btn btn-default tipB" title="Ver Historial Ingresos y descuentos" href="<?=base_url('personal/planilla/ingreso_descuento_empleado/'.$emp['emp_id'])?>" >
                                                    <span aria-hidden="true" class="icomoon-icon-bars"></span>
                                                </a>
                                                <!-- <span class="btn btn-default tipB icomoon-icon-bars" title="Ver Historial Ingresos y descuentos" data-href="<?=base_url('personal/planilla/ingreso_descuento_empleado/'.$emp['emp_id'])?>" >
                                                </span> -->
                                            </div>
                                        </td>
                                    <?php } ?>
                                </tr>
                            <?php } // endforeach
                        } else { ?>
                            <tr>
                                <td>0</td>
                                <td>Cero registros encontrados</td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                        <?php } //endif  ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

