<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        <?php echo "Reporte " . $titulo; ?>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<style type="text/css">
    .totales {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }

    .titulo {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }
</style>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla td {
            vertical-align: middle;
            text-align: center;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
            font-size: 10;
        }
    </style>
<?php } ?>

<?php if ($tipo_reporte != '') { ?>
    <table border="1" class="tabla">
    <?php } else { ?>
        <table class="responsive display table table-bordered dataTable" id="tbl_table" name="tbl_table" border="0" style="margin-left: 4px; width: 99%; font-size:12px;">
        <?php } ?>
        <thead>
            <tr>
                <th>Codigo</th>
                <th>Nombre</th>
                <th>Presupuesto Total (<?= $simbolo ?>)</th>
                <th>Presupuesto Actividades (<?= $simbolo ?>)</th>
                <th>Monto Ejecutado (<?= $simbolo ?>)</th>
                <th>Monto Por Ejecutar (<?= $simbolo ?>)</th>
                <th>F. Desde</th>
                <th>F. Hasta</th>
                <th>Estado</th>
            </tr>
        </thead>
        <tbody id="tbl_contenedor">
            <?php
            if (count($consulta) > 0) {
                //declaracion de variables
                foreach ($consulta as $key => $value) {
                    $estado = '';
                    switch ($value['psp_estado_prespuesto']) {
                        case 1:
                            $estado = 'Creado';
                            break;
                        case 2:
                            $estado = 'Aprobada';
                            break;
                        case 3:
                            $estado = 'Rechazada';
                            break;
                    }
            ?>
                    <tr>
                        <td><?php echo $value['psp_codigo']; ?></td>
                        <td><?php echo $value['psp_nombre']; ?></td>
                        <td><?php echo number_format($value['psp_total'], $cantidad_decimales, ".", ","); ?></td>
                        <td><?php echo number_format($value['pres_actividades'], $cantidad_decimales, ".", ","); ?></td>
                        <td><?php echo number_format($value['monto_ejecutado'], $cantidad_decimales, ".", ","); ?></td>
                        <td><?php echo number_format($value['monto_ejecutar'], $cantidad_decimales, ".", ","); ?></td>
                        <td><?php echo formatear_fecha("d-m-Y", $value['psp_fecha_desde']); ?></td>
                        <td><?php echo formatear_fecha("d-m-Y", $value['psp_fecha_hasta']); ?></td>
                        <td><?php echo $estado; ?></td>
                    </tr>
            <?php
                }
            }
            ?>
        </tbody>
        </table>