<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        <?php echo "Reporte " . $titulo; ?>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<style type="text/css">
    .totales {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }

    .titulo {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }
</style>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla td {
            vertical-align: middle;
            text-align: center;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
            font-size: 10;
        }
    </style>
<?php } ?>

<?php if ($tipo_reporte != '') { ?>
    <table border="1" class="tabla">
    <?php } else { ?>
        <table class="responsive display table table-bordered dataTable" id="tbl_table" name="tbl_table" border="0" style="margin-left: 4px; width: 99%; font-size:12px;">
        <?php } ?>
        <thead>
            <tr>
                <th>Actividad General</th>
                <?php
                $meses = array_unique(array_column($info, 'anios'));
                foreach ($meses as $key => $val) {
                    echo '<th>Presupuesto ' . $val . '</th><th>Real ' . $val . '</th>';
                }
                ?>
            </tr>
        </thead>
        <tbody id="tbl_contenedor">
            <?php
            if (count($info) > 0) {
                $sum_p = 0;
                $sum_r = 0;
                $anios = array_unique(array_column($info, 'anios'));
                $act   =  array_unique(array_column($info, 'actividad'));
                foreach ($info as $key2 => $data) {
                    echo '<tr>';
                    if ($tipo_reporte != 'excel') {
                        echo '<td style="display:none">' . $key2 . '</td>';
                    }
                    echo '<td>' . $data['nombre'] . '</td>';
                    foreach ($anios as $key => $val) {
                        if ($data['anios'] == $val) {
                            $datos[$val][$key2]  = ($data['presupuesto'] != '') ? $data['presupuesto'] : 0;
                            $datos2[$val][$key2] = ($data['p_real'] != '') ? $data['p_real'] : 0;
                            echo '<td>' . $simbolo . number_format($data['presupuesto'], $decimales, '.', '') . '</td>';
                            echo '<td>' . $simbolo . number_format($data['p_real'], $decimales, '.', '') . '</td>';
                        } else {
                            echo '<td></td><td></td>';
                        }
                    }
                    echo '</tr>';
                }
                echo '<tr><td style="font-weight:bold">Totales: </td>';
                foreach ($anios as $key => $sumas) {
                    echo '<td>' . $simbolo . number_format(array_sum($datos[$sumas]), $decimales, '.', '') . '</td>';
                    echo '<td>' . $simbolo . number_format(array_sum($datos2[$sumas]), $decimales, '.', '') . '</td>';
                }
                echo '</tr>';
            }
            ?>
        </tbody>
        </table>