<?php
    if ($tipo_reporte == 'excel') {
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header("content-disposition: attachment;filename=" . $filename . ".xls");
        header("Pragma: no-cache");
        header("Expires: 0");
    }
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                      <?php echo "Reporte " . $titulo;?>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<style type="text/css">
    .totales td{
        vertical-align: middle;
        text-align: center;
        font-weight:bold;
      
    }
    .titulo th{
        vertical-align: middle;
        text-align: center;
        font-weight:bold;
       
    }
    
</style>

<!-- Encabezado -->
<?php if ($tipo_reporte != '') { ?>
    <table>
    
        <tr>
            <td width="50%"><b>Proyecto: </b> <?php echo (count($consulta)  > 0 )?$consulta[0]["pcl_nombre"]:""; ?></td>
            <td width="50%"><b>Presupuesto: </b> <?php echo (count($consulta)  > 0 )?$consulta[0]["psp_nombre"]:""; ?></td>
        </tr>
        <tr>
        	<td></td>
        	<td></td>
        </tr>
        
    </table>
<?php } ?>
<!-- Encabezado -->
<!-- Tabla-->
<?php if ($tipo_reporte != '') { ?>
    <table border="1" class="tabla">
<?php } else { ?>
    <div class="table-responsive">
    <table class="responsive dynamicTable display table table-bordered dataTable" id="tbl_table" name="tbl_table" border="0" style="margin-left: 4px; width: 99%; font-size:12px;">
<?php } ?>
<thead>
        <tr>
            <th style="text-align:center;">Actividad General</th>
            <th style="text-align:center;">Pda. Presup. / Rubro</th>     
            <th style="text-align:center;">PAC</th>     
            <th style="text-align:center;">Ejecutado</th>  
            <th style="text-align:center;">Comprometido</th>     
            <th style="text-align:center;">Total Ejecución</th>     
            <th style="text-align:center;">% Ejecución</th> 
        </tr>
    </thead>
    <tbody>
        <?php $i = 0; ?>
        <?php foreach ($consulta as $key) {?>
    <tr>
        <td style="text-align:center;"><?php echo $key['acg_codigo'].'-'.$key['acg_nombre']; ?></td>
        <td style="text-align:center;"><?php echo $key['ace_codigo'].'-'.$key['ace_nombre']; ?></td>
        <td style="text-align:center;"><?php echo ($key['PAC'] != '')? number_format($key['PAC'],2) : number_format(0,2); ?></td>
        <td style="text-align:center;"><?php echo ($key['ejecutado'] != '')? number_format($key['ejecutado'],2) : number_format(0,2); ?></td>
        <td style="text-align:center;"><?php echo ($key['comprometido'] != '')? number_format($key['comprometido'],2) : number_format(0,2); ?></td>
        <td style="text-align:center;"><?php $total = $key['ejecutado'] + $key['comprometido']; echo number_format($total,2); ?></td>
        <td style="text-align:center;"><?php $porcentaje = ($total / $key['PAC'])*100; echo '%'.number_format($porcentaje,2)  ?></td>
    </tr><?php 
    $PAC += $key['PAC']; 
    $ejecutado += $key['ejecutado'];
    $comprometido +=  $key['comprometido'];
    $i ++; 
    $totales += 
    $total; 
    $porcentajes += $porcentaje;   ?>
        <?php } ?>
    <tfoot>
        <tr class="totales">
            <td style="text-align: right;" colspan="2"><b>Totales</b></td>
            <td style="text-align:center;"><?php echo number_format($PAC,2); ?></td>
            <td style="text-align:center;"><?php echo number_format($ejecutado,2); ?></td>
            <td style="text-align:center;"><?php echo number_format($comprometido,2); ?></td>
            <td style="text-align:center;"><?php echo number_format($totales,2); ?></td>
            <td style="text-align:center;"><?php echo '%'.number_format(($porcentajes/$i),2); ?></td>
        </tr>
        </tfoot>
    </tbody>
</table>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        $("#tbl_table").dataTable();
    });
</script>
<!-- Fin tabla-->

