<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        <?php echo "Reporte " . $titulo; ?>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<style type="text/css">
    .totales td {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }

    .titulo th {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }
</style>

<!-- Encabezado -->
<?php if ($tipo_reporte != '') { ?>
    <table>

        <tr>
            <td width="50%"><b>Hasta: </b> <?php echo $fecha; ?></td>
            <td width="50%"><b>Proyecto: </b> <?php echo (count($consulta)  > 0) ? $consulta[0]["pcl_nombre"] : ""; ?></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
        </tr>

    </table>
<?php } ?>
<!-- Encabezado -->
<!-- Tabla-->
<?php if ($tipo_reporte != '') { ?>
    <table border="1" class="tabla">
    <?php } else { ?>
        <table class="responsive display table table-bordered dataTable" id="tbl_table" name="tbl_table" border="0" style="margin-left: 4px; width: 99%; font-size:12px;">
        <?php } ?>
        <thead>
            <tr class="titulo">
                <th>Proyecto</th>
                <th>Presupuesto</th>
                <th>Actividad general</th>
                <th>Pda. Presup. / Rubro</th>
                <th>Presupuesto Pda. Presup. / Rubro</th>
                <th>Monto Ejecutado</th>
                <th>Monto por ejecutar</th>
                <th>Monto comprometido</th>
                <th>Disponible al ejecutar gasto</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $tabla = "";
            $puesupuesto_actividad  = 0;
            $monto_ejecutado        = 0;
            $total_monto_x_ejecutar = 0;
            $disponible             = 0;
            $comprometido           = 0;
            if (count($consulta) > 0) {
                foreach ($consulta as $key => $value) {
                    $monto_x_ejecutar       = 0;
                    $puesupuesto_actividad  += $value['presupuesto_actividad'];
                    $monto_ejecutado        += $value['monto_ejecutado'];
                    $monto_x_ejecutar        = $value['presupuesto_actividad'] - $value['monto_ejecutado'];
                    $total_monto_x_ejecutar += $monto_x_ejecutar;
                    $disponible             += ($monto_x_ejecutar - $value['monto_comprometido']);
                    $comprometido           += $value['monto_comprometido'];
                    $tabla .= '<tr>';
                    $tabla .= '<td style="text-align:center;">' . $value['pcl_nombre'] . '</td>';
                    $tabla .= '<td style="text-align:center;">' . $value['psp_nombre'] . '</td>';
                    $tabla .= '<td style="text-align:center;">' . $value['acg_nombre'] . '</td>';
                    $tabla .= '<td style="text-align:center;">' . $value['ace_nombre'] . '</td>';
                    $tabla .= '<td style="text-align:center;">' . number_format($value['presupuesto_actividad'], 2, ".", ",") . '</td>';
                    $tabla .= '<td style="text-align:center;">' . number_format($value['monto_ejecutado'], 2, ".", ",") . '</td>';
                    $tabla .= '<td style="text-align:center;">' . number_format($monto_x_ejecutar, 2, ".", ",") . '</td>';
                    $tabla .= '<td style="text-align:center;">' . number_format($value['monto_comprometido'], 2, ".", ",") . '</td>';
                    $tabla .= '<td style="text-align:center;">' . number_format($monto_x_ejecutar - $value['monto_comprometido'], 2, ".", ",") . '</td>';
                    $tabla .= '</tr>';
                }
            }

            $tabla .= '<tfoot><tr class="totales">';
            $tabla .= '<td style="text-align: right;" colspan="4"><b>Totales</b></td>';
            $tabla .= '<td style="text-align:center;">' . number_format($puesupuesto_actividad, 2, ".", ",") . '</td>';
            $tabla .= '<td style="text-align:center;">' . number_format($monto_ejecutado, 2, ".", ",") . '</td>';
            $tabla .= '<td style="text-align:center;">' . number_format($total_monto_x_ejecutar, 2, ".", ",") . '</td>';
            $tabla .= '<td style="text-align:center;">' . number_format($comprometido, 2, ".", ",") . '</td>';
            $tabla .= '<td style="text-align:center;">' . number_format($disponible, 2, ".", ",") . '</td>';
            $tabla .= '</tr></tfoot>';
            echo $tabla;
            ?>
        </tbody>
        </table>
        <!-- Fin tabla-->