<?php
    if ($tipo_reporte == 'excel') {
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header("content-disposition: attachment;filename=" . $filename . ".xls");
        header("Pragma: no-cache");
        header("Expires: 0");
    }
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                      <?php echo "Reporte " . $titulo;?>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<style type="text/css">
    .totales td{
        vertical-align: middle;
        text-align: center;
        font-weight:bold;
      
    }
    .titulo th{
        vertical-align: middle;
        text-align: center;
        font-weight:bold;
       
    }
    
</style>

<!-- Encabezado -->
<?php if ($tipo_reporte != '') { ?>
    <table>
    
        <tr>
            <td width="50%"><b>Proyecto: </b> <?php echo (count($consulta)  > 0 )?$consulta[0]["pcl_nombre"]:""; ?></td>
            <td width="50%"><b>Presupuesto: </b> <?php echo (count($consulta)  > 0 )?$consulta[0]["psp_nombre"]:""; ?></td>
        </tr>
        <tr>
        	<td></td>
        	<td></td>
        </tr>
        
    </table>
<?php } ?>
<!-- Encabezado -->
<!-- Tabla-->
<?php if ($tipo_reporte != '') { ?>
    <table border="1" class="tabla">
<?php } else { ?>
    <table class="responsive display table table-bordered dataTable" id="tbl_table" name="tbl_table" border="0" style="margin-left: 4px; width: 99%; font-size:12px;">
<?php } ?>
<thead>
        <tr class="titulo">
            <th style="text-align:center;">#</th>
            <th style="text-align:center;">Fecha del Gasto</th>     
            <th style="text-align:center;">Tipo de gasto</th>     
            <th style="text-align:center;">Descripción</th>  
            <th style="text-align:center;">Referencia</th>     
            <th style="text-align:center;">Cantidad</th>     
            <th style="text-align:center;">Monto</th> 
            <th style="text-align:center;">Impuestos</th> 
            <th style="text-align:center;">Retenciones</th> 
            <th style="text-align:center;">Total de gastos</th> 
        </tr>
    </thead>
    <tbody>
        <?php
            $tabla = "";
            $total_cantidad     = 0;
            $total_monto        = 0;
            $total_impuestos    = 0;
            $total_retenciones  = 0;
            $total_gastos       = 0;
            $i                  = 0;
            if (count($consulta) > 0) { 
                foreach ($consulta as $key => $value) {
                    //acumulaciones
                    $total_cantidad     += $value['dgp_cantidad'];
                    $total_monto        += $value['dgp_sub_monto'];
                    $total_impuestos    += $value['dgp_total_impuesto'];
                    $total_retenciones  += $value['dgp_total_retencion'];
                    $total_gastos       += $value['dgp_monto'];
                    $i++;

                    $tabla.= '<tr>';
                        $tabla.= '<td style="text-align:center;">'.$i.'</td>';
                        $tabla.= '<td style="text-align:center;">'.formatear_fecha('d-m-Y',$value['dgp_fecha']).'</td>';
                        $tabla.= '<td style="text-align:center;">'.$value['tgp_nombre'].'</td>';
                        $tabla.= '<td style="text-align:center;">'.$value['dgp_descripcion'].'</td>';
                        $tabla.= '<td style="text-align:center;">'.$value['dgp_referencia'].'</td>';
                        $tabla.= '<td style="text-align:center;">'.number_format($value['dgp_cantidad'],2,".",",").'</td>';
                        $tabla.= '<td style="text-align:center;">'.number_format($value['dgp_sub_monto'],2,".",",").'</td>';
                        $tabla.= '<td style="text-align:center;">'.number_format($value['dgp_total_impuesto'],2,".",",").'</td>';
                        $tabla.= '<td style="text-align:center;">'.number_format($value['dgp_total_retencion'],2,".",",").'</td>';
                        $tabla.= '<td style="text-align:center;">'.number_format($value['dgp_monto'],2,".",",").'</td>';
                    $tabla.= '</tr>';
                }
            }

            $tabla.= '<tfoot><tr class="totales">';
                $tabla.= '<td style="text-align: right;" colspan="5"><b>Totales</b></td>';
                $tabla.= '<td style="text-align:center;">'.number_format($total_cantidad,2,".",",").'</td>';
                $tabla.= '<td style="text-align:center;">'.number_format($total_monto,2,".",",").'</td>';
                $tabla.= '<td style="text-align:center;">'.number_format($total_impuestos,2,".",",").'</td>';
                $tabla.= '<td style="text-align:center;">'.number_format($total_retenciones,2,".",",").'</td>';
                $tabla.= '<td style="text-align:center;">'.number_format($total_gastos,2,".",",").'</td>';
            $tabla.= '</tr></tfoot>';
            echo $tabla;
        ?>
    </tbody>
</table>
<!-- Fin tabla-->

