<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

$mes_1      = date('m', strtotime($fecha_inicio)) - 1;
$dias_1     = date('d', strtotime($fecha_inicio));
$year_1     = date('y', strtotime($fecha_inicio));
$anio_1     = date('Y', strtotime($fecha_inicio));

$mes_2      = date('m', strtotime($fecha_fin)) - 1;
$dias_2     = date('d', strtotime($fecha_fin));
$year_2     = date('y', strtotime($fecha_fin));

$meses_fecha = array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
$meses      = array("Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic");
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        <?php echo "Reporte " . $titulo; ?>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<style type="text/css">
    .totales {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }

    .titulo {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }
</style>

<!-- Encabezado -->
<?php if ($tipo_reporte != '') { ?>
    <table>

        <tr>
            <td width="50%"><b>Proyecto: </b> <?php echo $presupuesto[0]['pcl_nombre']; ?></td>
            <td width="50%"><b>Ejecutor: </b> <?php echo $presupuesto[0]['ejecutor']; ?></td>
        </tr>

        <tr>
            <td width="50%"><b>Presupuesto: </b> <?php echo $presupuesto[0]['psp_nombre']; ?></td>
            <td width="50%"><b>Seguimiento por: </b> <?php echo $presupuesto[0]['seguimiento']; ?></td>
        </tr>

        <tr>
            <td width="50%"><b>Tipo de Presupuesto: </b> <?php echo $presupuesto[0]['tpp_nombre']; ?></td>
            <td></td>
        </tr>

        <tr>
            <td width="50%"><b>Periodo: </b> <?php echo formatear_fecha("d/m/Y", $presupuesto[0]['psp_fecha_desde']) . " al " . formatear_fecha("d/m/Y", $presupuesto[0]['psp_fecha_hasta']); ?></td>
            <td></td>
        </tr>

        <tr>
            <td width="50%"><b>Financiador: </b> <?php echo $presupuesto[0]['fnc_nombre']; ?></td>
            <td></td>
        </tr>

        <tr>
            <td width="50%"><b>Presupuesto Total (<?= $simbolo ?>):</b> <?php echo number_format($presupuesto[0]['psp_total'], $cantidad_decimales, ".", ","); ?></td>
            <td></td>
        </tr>

        <tr>
            <td></td>
            <td></td>
        </tr>

    </table>
<?php } ?>
<!-- Encabezado -->
<!-- Tabla-->

<?php if ($tipo_reporte != '') { ?>
    <table border="1" class="tabla">
    <?php } else { ?>
        <table class="responsive display table table-bordered dataTable" id="tbl_table" name="tbl_table" border="0" style="margin-left: 4px; width: 99%; font-size:12px;">
        <?php } ?>
        <thead>
            <tr>
                <th class="titulo">Pda. Presup. / Rubro</th>
                <th class="titulo">Presupuesto Actividad (<?= $simbolo ?>)</th>
                <?php
                $mes_evaluado   = intval($mes_1);
                $anio_evaluado  = intval($year_1);
                for ($i = 0; $i <= $cant_meses; $i++) {
                    echo '<th class="titulo">' . $meses[$mes_evaluado] . '-' . $anio_evaluado . '</th>';
                    $mes_evaluado++;
                    if ($mes_evaluado >= 12) {
                        $mes_evaluado = 0;
                        $anio_evaluado++;
                    }
                }
                ?>
            </tr>
        </thead>
        <tbody>
            <?php
            $tabla              = "";
            $columna_clave      = array_column($detalles, 'clave');
            $totales            = 0;
            $suma_total_meses   = array();
            if (count($consulta) > 0) {
                $actividad_general_evaluado  = $consulta[0]['acg_id'];
                foreach ($consulta as $key => $value) {
                    //variables a usar
                    $mes_evaluado       = intval($mes_1) + 1;
                    $anio_evaluado      = intval($anio_1);
                    $totales            += $value['presupuesto'];

                    $tabla .= '<tr>';
                    $tabla .= '<td style="text-align:center;">' . $value['ace_nombre'] . '</td>';
                    $tabla .= '<td style="text-align:center;">' . number_format($value['presupuesto'], $cantidad_decimales, ".", ",") . '</td>';
                    //se agregaran los meses
                    for ($i = 0; $i <= $cant_meses; $i++) {
                        $clave      = $value['ace_id'] . "_" . str_pad(($mes_evaluado), 2, "0", STR_PAD_LEFT) . "_" . $anio_evaluado;
                        $posicion   = array_search($clave, $columna_clave);
                        if ($posicion !== false) {
                            $tabla  .= '<td style="text-align:center;">' . number_format($detalles[$posicion]["suma"], $cantidad_decimales, ".", ",") . '</td>';
                            $suma_total_meses[$i]   += $detalles[$posicion]["suma"];
                        } else {
                            $tabla .= '<td style="text-align:center;">-</td>';
                            $suma_total_meses[$i]   += 0;
                        }
                        $mes_evaluado++;
                        if ($mes_evaluado > 12) {
                            $mes_evaluado = 1;
                            $anio_evaluado++;
                        }
                    }
                    $tabla .= '</tr>';
                }
            }
            $tabla .= '<tfoot><tr>';
            $tabla .= '<td style="text-align: right;" height="20px"><b>Totales</b></td>';
            $tabla .= '<td style="text-align:center;">' . number_format($totales, 2, ".", ",") . '</td>';
            for ($i = 0; $i <= $cant_meses; $i++) {
                $valor_mes = ($suma_total_meses[$i] > 0) ? number_format($suma_total_meses[$i], 2, ".", ",") : "-";
                $tabla .= '<td style="text-align:center;">' . $valor_mes . '</td>';
            }
            $tabla .= '</tr></tfoot>';
            echo $tabla;
            ?>
        </tbody>
        </table>
        <!-- Fin tabla-->