<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

$mes_1      = date('m', strtotime($fecha_inicio)) - 1;
$dias_1     = date('d', strtotime($fecha_inicio));
$year_1     = date('y', strtotime($fecha_inicio));
$anio_1     = date('Y', strtotime($fecha_inicio));

$mes_2      = date('m', strtotime($fecha_fin)) - 1;
$dias_2     = date('d', strtotime($fecha_fin));
$year_2     = date('y', strtotime($fecha_fin));

$meses_fecha = array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
$meses      = array("Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic");
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        <?php echo "Reporte " . $titulo; ?>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<style type="text/css">
    .totales {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }

    .titulo {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }

    .tfoot tr td {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }

    .thead tr th {
        text-align: center;
        font-weight: bold;
    }
</style>


<!-- Tabla-->

<?php if ($tipo_reporte != '') { ?>
    <table border="1" class="tabla">
    <?php } else { ?>
        <table class="responsive display table table-bordered dataTable" id="tbl_table" name="tbl_table" border="0" style="margin-left: 4px; width: 99%; font-size:12px;">
        <?php } ?>
        <thead class="thead">
            <tr>
                <!-- <th>Área general de gastos</th> -->
                <th>Actividad General</th>
                <th>Pda. Presup. / Rubro</th>
                <th>Presupuesto</br>Actividad (<?= $simbolo ?>)</th>
                <?php
                $mes_evaluado   = intval($mes_1);
                $anio_evaluado  = intval($year_1);
                for ($i = 0; $i <= $cant_meses; $i++) {
                    echo '<th>' . $meses[$mes_evaluado] . '-' . $anio_evaluado . '</th>';
                    $mes_evaluado++;
                    if ($mes_evaluado >= 12) {
                        $mes_evaluado = 0;
                        $anio_evaluado++;
                    }
                }
                ?>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $tabla                          = "";
            //VARIABLES DE CALCULOS
            //CALCULOS POR FILA
            $suma_fila                      = 0;
            //CALCULOS DE GLOBALES
            $global_presupuesto_actividad   = 0;
            $global_global_suma_meses              = array();

            //asignacion de valores
            for ($i = 0; $i <= $cant_meses; $i++) {
                $global_suma_meses[$i] = 0;
            }

            if (count($consulta) > 0) {
                $columna_clave      = array_column($detalles, 'clave');
                foreach ($consulta as $key => $value) {
                    //variables para obtener
                    $suma_fila          = 0;
                    $mes_evaluado       = intval($mes_1) + 1;
                    $anio_evaluado      = intval($anio_1);
                    $monto_ejecutado    = 0;

                    $global_presupuesto_actividad += $value['dps_presupuesto_actividad'];

                    $tabla .= '<tr>';
                    $tabla .= '<td>' . $value['acg_codigo'] . '- <br> ' . $value['acg_nombre'] . '</td>';
                    $tabla .= '<td>' . $value['ace_codigo'] . '- <br> ' . $value['ace_nombre'] . '</td>';
                    $tabla .= '<td style="text-align:right;">' . number_format($value['dps_presupuesto_actividad'], $cantidad_decimales, ".", ",") . '</td>';
                    for ($i = 0; $i <= $cant_meses; $i++) {
                        $clave      = $value['dps_id'] . "_" . str_pad(($mes_evaluado), 2, "0", STR_PAD_LEFT) . "_" . $anio_evaluado;
                        $posicion   = array_search($clave, $columna_clave);
                        if ($posicion !== false) {
                            $tabla                  .= "<td>" . number_format($detalles[$posicion]["suma"], $cantidad_decimales, ".", ",") . "</td>";
                            $suma_fila              += $detalles[$posicion]["suma"];
                            $global_suma_meses[$i]  += $detalles[$posicion]["suma"];
                        } else {
                            $tabla .= '<td style="text-align:right;">' . $simbolo . '0.00</td>';
                        }
                        $mes_evaluado++;
                        if ($mes_evaluado > 12) {
                            $mes_evaluado = 1;
                            $anio_evaluado++;
                        }
                    }
                    $tabla .= '<td style="text-align:right;">' . number_format($suma_fila, $cantidad_decimales, ".", ",") . '</td>';
                    $tabla .= '</tr>';
                }
                $suma_fila = 0;
            } else {
            }
            $tabla .= '</tbody>';
            $tabla .= '<tfoot class="tfoot">';
            $tabla .= '<tr>';
            $tabla .= '<td colspan="2" style="text-align: right;">Totales:</td>';
            $tabla .= '<td style="text-align:right;">' . number_format($global_presupuesto_actividad, $cantidad_decimales, ".", ",") . '</td>';
            for ($i = 0; $i <= $cant_meses; $i++) {
                $tabla .= '<td style="text-align:right;">' . number_format($global_suma_meses[$i], $cantidad_decimales, ".", ",") . '</td>';
                $suma_fila += $global_suma_meses[$i];
            }
            $tabla .= '<td style="text-align:right;">' . number_format($suma_fila, $cantidad_decimales, ".", ",") . '</td>';
            $tabla .= '</tr>';
            $tabla .= '</tfoot>';
            echo $tabla;
            ?>
        </table>