<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

$mes_1      = date('m', strtotime($fecha_inicio)) - 1;
$dias_1     = date('d', strtotime($fecha_inicio));
$year_1     = date('y', strtotime($fecha_inicio));
$anio_1     = date('Y', strtotime($fecha_inicio));

$mes_2      = date('m', strtotime($fecha_fin)) - 1;
$dias_2     = date('d', strtotime($fecha_fin));
$year_2     = date('y', strtotime($fecha_fin));

$meses_fecha = array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
$meses      = array("Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic");
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        <?php echo "Reporte " . $titulo; ?>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<style type="text/css">
    .totales {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }

    .titulo {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }
</style>

<!-- Encabezado -->
<?php if ($tipo_reporte != '') { ?>
    <table>

        <tr>
            <td width="50%"><b>Proyecto: </b> <?php echo $presupuesto[0]['pcl_nombre']; ?></td>
            <td width="50%"><b>Ejecutor: </b> <?php echo $presupuesto[0]['ejecutor']; ?></td>
        </tr>

        <tr>
            <td width="50%"><b>Presupuesto: </b> <?php echo $presupuesto[0]['psp_nombre']; ?></td>
            <td width="50%"><b>Seguimiento por: </b> <?php echo $presupuesto[0]['seguimiento']; ?></td>
        </tr>

        <tr>
            <td width="50%"><b>Tipo de Presupuesto: </b> <?php echo $presupuesto[0]['tpp_nombre']; ?></td>
            <td></td>
        </tr>

        <tr>
            <td width="50%"><b>Periodo: </b> <?php echo formatear_fecha("d/m/Y", $presupuesto[0]['psp_fecha_desde']) . " al " . formatear_fecha("d/m/Y", $presupuesto[0]['psp_fecha_hasta']); ?></td>
            <td></td>
        </tr>

        <tr>
            <td width="50%"><b>Financiador: </b> <?php echo $presupuesto[0]['fnc_nombre']; ?></td>
            <td></td>
        </tr>

        <tr>
            <td width="50%"><b>Presupuesto Total (<?= $simbolo ?>):</b> <?php echo number_format($presupuesto[0]['psp_total'], $cantidad_decimales, ".", ","); ?></td>
            <td></td>
        </tr>

        <tr>
            <td></td>
            <td></td>
        </tr>

    </table>
<?php } ?>
<!-- Encabezado -->
<!-- Tabla-->

<?php if ($tipo_reporte != '') { ?>
    <table border="1" class="tabla">
    <?php } else { ?>
        <table class="responsive display table table-bordered dataTable" id="tbl_table" name="tbl_table" border="0" style="margin-left: 4px; width: 99%; font-size:12px;">
        <?php } ?>
        <thead>
            <tr>
                <!-- <th>Área general de gastos</th> -->
                <th>Actividad General</th>
                <th>Pda. Presup. / Rubro</th>
                <th>Objeto</th>
                <th>Fuente de Financiamiento</th>
                <th>Financiador</th>
                <th>Presupuesto Actividad (<?= $simbolo ?>)</th>
                <?php
                $mes_evaluado   = intval($mes_1);
                $anio_evaluado  = intval($year_1);
                for ($i = 0; $i <= $cant_meses; $i++) {
                    echo '<th>' . $meses[$mes_evaluado] . '-' . $anio_evaluado . '</th>';
                    $mes_evaluado++;
                    if ($mes_evaluado >= 12) {
                        $mes_evaluado = 0;
                        $anio_evaluado++;
                    }
                }
                ?>
                <th>Monto Ejecutado (<?= $simbolo ?>)</th>
                <th>Monto por ejecutar (<?= $simbolo ?>)</th>
                <th>Aporte Externo (<?= $simbolo ?>)</th>
                <th>Aporte Interno (<?= $simbolo ?>)</th>
                <th>Fuente de Verificación</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $Sub_presupuesto_actividad  = 0;
            $actividad_general_evaluado = "";
            $tabla                      = "";
            $suma_meses                 = array();

            //totales globales
            $suma_total_meses               = array();
            $global_presupuesto_actividad   = 0;
            $global_aporte_externo          = 0;
            $global_aporte_interno          = 0;
            $global_monto_ejecutado         = 0;

            if (count($consulta) > 0) {
                $actividad_general_evaluado = $consulta[0]['acg_id'];
                $columna_clave              = array_column($detalles, 'clave');
                foreach ($consulta as $key => $value) {
                    //variables a usar
                    $mes_evaluado       = intval($mes_1) + 1;
                    $anio_evaluado      = intval($anio_1);
                    $monto_ejecutado    = 0;



                    // Evaluar si es actividad general diferente
                    if ($value['acg_id'] != $actividad_general_evaluado) {
                        $tabla .= '<tr>';
                        $tabla .= '<td colspan="5" style="text-align: right;">Sub-Total actividad</td>';
                        $tabla .= '<td>' . number_format($Sub_presupuesto_actividad, $cantidad_decimales, ".", ",") . '</td>';
                        //total independiente de cada mes     
                        $monto_ejecutado = 0;
                        for ($i = 0; $i <= $cant_meses; $i++) {
                            $valor_mes = ($suma_meses[$i] > 0) ? $suma_meses[$i] : "-";
                            $tabla .= '<td>' . $valor_mes . '</td>';
                            $monto_ejecutado += $valor_mes;
                        }
                        $tabla .= '<td>' . number_format($monto_ejecutado, 2, ".", ",") . '</td>';
                        $tabla .= '<td>' . number_format($sub_aporte_externo, 2, ".", ",") . '</td>';
                        $tabla .= '<td>' . number_format($sub_aporte_interno, 2, ".", ",") . '</td>';
                        $tabla .= '<td></td>';
                        $tabla .= '</tr>';
                        $suma_meses = array();
                        $Sub_presupuesto_actividad = 0;
                        $sub_aporte_externo        = 0;
                        $sub_aporte_interno        = 0;
                        $actividad_general_evaluado = $value['acg_id'];
                    } //else {

                    //sub_sumas
                    $Sub_presupuesto_actividad += $value['dps_presupuesto_actividad'];
                    $sub_aporte_externo        += $value['dps_aporte_externo'];
                    $sub_aporte_interno        += $value['dps_aporte_interno'];
                    $sub_monto_ejecutado        = 0;

                    //suma de globales
                    $global_presupuesto_actividad += $value['dps_presupuesto_actividad'];
                    $global_aporte_externo        += $value['dps_aporte_externo'];
                    $global_aporte_interno        += $value['dps_aporte_interno'];

                    $tabla .= '<tr>';
                    // $tabla.= '<td>'.$value['ars_nombre'].'</td>';
                    $tabla .= '<td>' . $value['acg_nombre'] . '</td>';
                    $tabla .= '<td>' . $value['ace_nombre'] . '</td>';
                    $tabla .= '<td>' . $value['dps_objetivo'] . '</td>';
                    $tabla .= '<td>' . $value['fnf_nombre'] . '</td>';
                    $tabla .= '<td>' . $value['financiador'] . '</td>';
                    $tabla .= '<td>' . number_format($value['dps_presupuesto_actividad'], $cantidad_decimales, ".", ",") . '</td>';

                    for ($i = 0; $i <= $cant_meses; $i++) {
                        $clave      = $value['dps_id'] . "_" . str_pad(($mes_evaluado), 2, "0", STR_PAD_LEFT) . "_" . $anio_evaluado;
                        $posicion   = array_search($clave, $columna_clave);
                        if ($posicion !== false) {
                            $tabla                  .= "<td>" . number_format($detalles[$posicion]["suma"], $cantidad_decimales, ".", ",") . "</td>";
                            $monto_ejecutado        += $detalles[$posicion]["suma"];
                            $suma_meses[$i]         += $detalles[$posicion]["suma"];
                            $suma_total_meses[$i]   += $detalles[$posicion]["suma"];
                            $global_monto_ejecutado += $detalles[$posicion]["suma"];
                        } else {
                            $tabla .= '<td style="text-align:center;">-</td>';
                            $suma_meses[$i]         += 0;
                            $suma_total_meses[$i]   += 0;
                        }

                        //$llave = array_search($clave, $columna_clave);                           
                        $mes_evaluado++;
                        if ($mes_evaluado > 12) {
                            $mes_evaluado = 1;
                            $anio_evaluado++;
                        }
                    }
                    $tabla .= '<td>' . number_format($monto_ejecutado, $cantidad_decimales, ".", ",") . '</td>';
                    $tabla .= '<td>' . number_format(($value['dps_presupuesto_actividad'] - $monto_ejecutado), $cantidad_decimales, ".", ",") . '</td>';
                    $tabla .= '<td>' . $value['dps_aporte_externo'] . '</td>';
                    $tabla .= '<td>' . $value['dps_aporte_interno'] . '</td>';
                    $tabla .= '<td>' . $value['fuv_nombre'] . '</td>';
                    $tabla .= '</tr>';
                    // }        
                }
                $tabla .= '<tr>';
                $tabla .= '<td colspan="5" style="text-align: right;">Sub-Total actividad</td>';
                $tabla .= '<td>' . number_format($Sub_presupuesto_actividad, $cantidad_decimales, ".", ",") . '</td>';
                //total independiente de cada mes
                $monto_ejecutado = 0;
                for ($i = 0; $i <= $cant_meses; $i++) {
                    $valor_mes = ($suma_meses[$i] > 0) ? number_format($suma_meses[$i], $cantidad_decimales, ".", ",") : "-";
                    $tabla .= '<td>' . $valor_mes . '</td>';
                    $monto_ejecutado += $valor_mes;
                }
                $tabla .= '<td>' . number_format($monto_ejecutado, $cantidad_decimales, ".", ",") . '</td>';
                $tabla .= '<td>' . number_format(($value['dps_presupuesto_actividad'] - $monto_ejecutado), $cantidad_decimales, ".", ",") . '</td>';
                $tabla .= '<td>' . number_format($sub_aporte_externo, $cantidad_decimales, ".", ",") . '</td>';
                $tabla .= '<td>' . number_format($sub_aporte_interno, $cantidad_decimales, ".", ",") . '</td>';
                $tabla .= '<td></td>';
                $tabla .= '</tr>';
                //total global
                $global_mes = 0;
                $tabla .= '<tr>';
                $tabla .= '<td colspan="5" style="text-align: right;">Total global</td>';
                $tabla .= '<td>' . number_format($global_presupuesto_actividad, $cantidad_decimales, ".", ",") . '</td>';
                for ($i = 0; $i <= $cant_meses; $i++) {
                    $valor_mes = ($suma_total_meses[$i] > 0) ? number_format($suma_total_meses[$i], $cantidad_decimales, ".", ",") : "-";
                    $tabla .= '<td>' . $valor_mes . '</td>';
                    $global_mes += $valor_mes;
                }
                $tabla .= '<td>' . number_format($global_mes, $cantidad_decimales, ".", ",") . '</td>';
                $tabla .= '<td>' . number_format(($global_presupuesto_actividad - $global_mes), $cantidad_decimales, ".", ",") . '</td>';
                $tabla .= '<td>' . number_format($global_aporte_externo, $cantidad_decimales, ".", ",") . '</td>';
                $tabla .= '<td>' . number_format($global_aporte_interno, $cantidad_decimales, ".", ",") . '</td>';
                $tabla .= '<td></td>';
                $tabla .= '</tr>';
                echo $tabla;
            }
            ?>
        </tbody>
        </table>
        <!-- Fin tabla-->