<?php if (count($detalles)>0) { ?>
<?php foreach ($detalles as $llave => $valor) { ?>
    <?php 
        $estado = '';
        switch ($valor['psp_estado_prespuesto']) {
            case 1:
                $estado = 'Creado';
                break;
            case 2: 
                $estado = 'Aprobado';
                break;
            case 3:
                $estado = 'Rechazado';
                break;
        }
    ?>
    <tr>            
        <td><?php echo $valor['psp_codigo']; ?></td>
        <td><?php echo $valor['psp_nombre']; ?></td>
        <td><?php echo number_format($valor['psp_total'], $cantidad_decimales, ".", ","); ?></td>
        <td><?php echo number_format($valor['pres_actividades'], $cantidad_decimales, ".", ","); ?></td>
        <td><?php echo number_format($valor['monto_ejecutado'], $cantidad_decimales, ".", ","); ?></td>
        <td><?php echo number_format($valor['monto_ejecutar'], $cantidad_decimales, ".", ","); ?></td>
        <td><?php echo formatear_fecha('d-m-Y', $valor['psp_fecha_desde']); ?></td>
        <td><?php echo formatear_fecha('d-m-Y', $valor['psp_fecha_hasta']); ?></td>
        <td><?php echo $estado; ?></td>
        <td>
            <div class="tools">
                <div class="btn-group">
                    <button class="btn" type="button"><span class="icon16 icomoon-icon-cog-2"></span></button>
                    <button class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret"></span></button>
                    <ul class="dropdown-menu">


                    <?php if ($permisos['permite_editar']) { ?>
                        <li>
                            <a href="<?php echo base_url('modulo_presupuesto/pre_procesos/editar_presupuesto/'.$valor['psp_id']); ?>" >
                                <span aria-hidden="true" class="icomoon-icon-pencil"></span>
                                Editar Presupuesto
                            </a>
                        </li>
                    <?php } ?>
                    
                    <?php if ($valor['psp_estado_prespuesto'] == 1 && count($tiene_autoridad) > 0) { ?>
                    <li>
                        <a href="#pre_aprobacion" data-id="<?php echo $valor['psp_id']; ?>" class="mostar_modal aprobacion">
                            <span aria-hidden="true" class="icomoon-icon-grid-view"></span>
                            Aprobación
                        </a>
                    </li>
                    <?php } ?>
                    
                    <?php if ($valor['psp_estado_prespuesto'] == 1 && count($tiene_autoridad) > 0) { ?>
                    <li>
                        <a href="#frm_rechazo" data-id="<?php echo $valor['psp_id']; ?>" class="mostar_modal rechazar">
                            <span aria-hidden="true" class="icomoon-icon-blocked"></span>
                            Rechazar
                        </a>
                    </li>
                    <?php } ?>                     
                    </ul>
                </div>
            </div>
        </td>
    </tr>
   <?php } ?>
<?php }  ?>