<meta charset="utf-8" />
<?php 
foreach($css_files as $file): ?>
    <link type="text/css" rel="stylesheet" href="<?php echo $file; ?>" />
<?php endforeach; ?>
<?php foreach($js_files as $file): ?>
    <script src="<?php echo $file; ?>"></script>
<?php endforeach; ?>
<style type='text/css'>
body
{
    font-family: Arial;
    font-size: 14px;
}
a {
    color: blue;
    text-decoration: none;
    font-size: 14px;
}
a:hover
{
    text-decoration: underline;
}
</style>
<div style='height:10px;'>
    <?php if (isset($agregar) ) { ?>
        <a class="btn btn-large" href="<?php echo base_url('modulo_presupuesto/pre_mantenimientos/agregar_proyecto');?>" title="Agregar Componente">
		    <strong>Agregar Proyecto</strong>
	    </a>
        <br>
    <?php } ?>
</div>  
<div>
    <?php echo $output;?>
</div>

<a id="btn_modal_finalizar" href="#modal_finalizar" style="margin-left: 10px;" class="modal_finalizar icon-table"></a>

<!-- Modal -->
<div id="modal_finalizar"  style="display:none">
    <div class="box">
        <div class="title">
            <h4><span>Finalizar Proyecto</span></h4>
        </div>
        <div class="content">
            <div class="form-row row-fluid">
                <form id="frm_finalizar" name="frm_finalizar" action="<?php echo base_url(); ?>cotizaciones/mantenimientos/finalizar_proyecto" method="post">
                <input type="hidden" name="txt_ruta" id="txt_ruta" value="modulo_presupuesto/pre_mantenimientos/proyectos">
                <div class="span12">
                    <div class="row-fluid">
                        <label class="span4">Descripción: <b style="color:red;">*</b></label>
                        <div class="span7 controls">
                            <textarea name="txt_descripcion" id="txt_descripcion" cols="30" rows="5" maxlength="500" onfocus="$('#txt_descripcion_error').text('');"></textarea>
                            <div id="txt_descripcion_error" style="color:red;padding-top:1px;"></div>
                            <input type="hidden" name="txt_proyecto" id="txt_proyecto" >
                        </div>
                    </div>
                </div>
                </form>
                <div class="span12">
                    <div class="form-actions " style="text-align:center;">
                        <button id ="guardar_modal" type="submit" class="btn btn-info" ><span class="icon16 icomoon-icon-checkmark white"></span>Finalizar</button>
                        <button id ="cancelar_modal" type="button" class="btn btn-danger btn-close" onclick="javascript:$.fancybox.close();"><span class="icon16 icomoon-icon-cancel-2 white"></span>Cancelar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
var result = 0;
$(document).ready(function () {
  
    $(".modal_finalizar").fancybox({
        width: '60%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {

        },
        beforeClose: function () {

        }
    }); 

    $(".finalizar").click(function () {
        event.preventDefault();
        $("#txt_descripcion").val("");
        var ruta = $(this).attr("href");
        verificar_proyecto_finalizado(ruta,"",3);
        if ( result == 1 ) {
            $('#txt_descripcion').attr('readonly', false);
            $('#guardar_modal').attr('disabled', false);
        } else {
            obtener_descripcion(ruta);
            $('#txt_descripcion').attr('readonly', true);
            $('#guardar_modal').attr('disabled', true);
        }
        verificar_estado_finalizado(ruta);
    });

    $("#guardar_modal").click(function () {
       if ( $("#txt_descripcion").val() != "" ) {
           $("#frm_finalizar").submit();
       } else{
            $("#txt_descripcion_error").text("Campo es requerido");
            crear_alerta('error', 'Proyectos', 'Favor agregar una descripción');
       }
    });

    function verificar_estado_finalizado( ruta ) {
        var proyecto_array = ruta.split("/");
        var proyecto= proyecto_array.pop();
        $.ajax({
            url: urlj + "cotizaciones/mantenimientos/verificar_estado_finalizado",
            type: 'POST',
            dataType: 'json',
            data: {},
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                wait.close();
                if (data == 0) {
                    crear_alerta('info', 'Proyectos', 'Falta crear un estado como última etapa de un proyecto');
                } else {
                    $("#txt_proyecto").val(proyecto);
                    $('#btn_modal_finalizar').trigger('click');
                }
            }
        });
    }

    $(".icomoon-icon-pencil-5").parent().click(function (event) {
        event.preventDefault();
        ruta        = $(this).attr("href");
        nueva_ruta  = urlj + "modulo_presupuesto/pre_mantenimientos/editar_proyecto/"+(ruta.split('/').pop());
     
        verificar_proyecto_finalizado(nueva_ruta,"no puede editarse",1);
    });

    $(".delete-row").click(function (event) {
        event.preventDefault();
        var ruta = $(this).attr("href");
        verificar_proyecto_finalizado(ruta,"no puede borrarse",2);
        if ( result == 1 ) {
            return true;
        } else {
            return false;
        }
    });

    //tipo 1 = editar, 2 = eliminar,3 = finalizar
    function verificar_proyecto_finalizado( ruta, mensaje, tipo ) {
        var proyecto_array = ruta.split("/");
        var proyecto= proyecto_array.pop();
        $.ajax({
            url: urlj + "cotizaciones/mantenimientos/verificar_proyecto_finalizado",
            type: 'POST',
            dataType: 'json',
            data: {proyecto:proyecto},
            async: false ,
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                wait.close();
                if (data == 1) {
                    if (tipo != 3) {
                        crear_alerta('info', 'Proyectos', 'Proyecto ya fue finalizado, '+mensaje);
                    }
                    result = 0; 
                    return result;
                } else {
                    result = 1;
                    if ( tipo == 1) {
                        window.location.href = ruta;
                    } else  {
                    }
                    return result;
                }
            }
        });
    }

    function obtener_descripcion( ruta ) {
        var proyecto_array = ruta.split("/");
        var proyecto= proyecto_array.pop();
        $.ajax({
            url: urlj + "cotizaciones/mantenimientos/obtener_descripcion",
            type: 'POST',
            dataType: 'text',
            data: {proyecto:proyecto},
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                $("#txt_descripcion").val(data);
                wait.close();
            }
        });
    }

    $(document).on('click','#agreg',function(evento){
        evento.preventDefault();
        var url_id     = $(this).attr('href');
        var id_cliente = url_id.split('/',8).pop();
        var url        = urlj + "cotizaciones/mantenimientos/agregar_proyectos/" + id_cliente;
        window.location = url;
    });

    $(document).on('click','.ver_proyectos',function(evento){
        evento.preventDefault();
        var url_id     = $(this).attr('href');
        var id_cliente = url_id.split('/',10).pop();
    
        var url        = urlj + "cotizaciones/mantenimientos/ver_proyectos/" + id_cliente;
        
        window.location = url;
    });

    
});
</script>