<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@"; /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8"/>
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br/>
                        Reporte de Formulación POA
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<table class="tabla <?php echo ($tipo_reporte == null) ? "responsive table table-bordered contenedor" : ""; ?>">
    <thead>
        <tr style="vertical-align: middle;">
            <th rowspan="2">No.</th>
            <th rowspan="2">Meta</th>
            <th rowspan="2">Objetivo Operativo</th>
            <th rowspan="2">Área</th>
            <th rowspan="2">Indicadores</th>
            <th rowspan="2">Tipo de Medición</th>
            <th colspan="2">Fecha.</th>
            <th colspan="12">Programación</th>
            <th rowspan="2">Total</th>
            <th rowspan="2">Recursos $.</th>
        </tr>
        <tr>
            <th>Inicio</th>
            <th>Fin</th>
            <th>E</th>
            <th>F</th>
            <th>M</th>
            <th>A</th>
            <th>M</th>
            <th>J</th>
            <th>J</th>
            <th>A</th>
            <th>S</th>
            <th>O</th>
            <th>N</th>
            <th>D</th>
        </tr>
    </thead>
    <tbody>
        <?php
        //Si la variable tipo reporte existe se declara la tabla
        foreach ($reporte as $row) {
            //Se obtiene la programación de la meta
            $this->db->order_by('per_codigo ASC');
            $programacion = $this->plan_operativo_model->get_programacion_meta(array('prm_id_met' => $row['met_id']));
            $ultimo_mes_programado = (count($programacion) > 0) ? array_filter($programacion, function ($value) {
                return ($value['prm_programa'] > 0);
            }) : null;
            $total_programacion = (count($programacion) > 0) ? array_sum(array_column($programacion, 'sgm_ejecutado')) : 0;
            $total_monto_prog = (count($programacion) > 0) ? array_sum(array_column($programacion, 'sgm_monto_ejecutado')) : 0;
            ?>
            <tr>
                <td rowspan="2"><?php echo $row['met_codigo']; ?></td>
                <td rowspan="2"><?php echo $row['met_nombre']; ?></td>
                <td rowspan="2"><?php echo $row['obo_nombre']; ?></td>
                <td rowspan="2"><?php echo $row['are_nombre']; ?></td>
                <td rowspan="2"><?php echo $row['met_indicador']; ?></td>
                <td rowspan="2"><?php echo $row['tmd_nombre']; ?></td>
                <td rowspan="2"><?php echo (count($programacion) > 0) ? substr($programacion[0]['per_nombre'], 0, 1) : "E"; ?></td>
                <td rowspan="2"><?php echo (count($programacion) > 0) ? substr($ultimo_mes_programado[count($ultimo_mes_programado) - 1]['per_nombre'], 0, 1) : "E"; ?></td>
                <?php if (count($programacion) > 0) {
                    foreach ($programacion as $prm) {
                        ?>
                        <td><?php echo $prm['sgm_ejecutado']; ?></td>
                    <?php }
                } else { ?>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                <?php } ?>
                <td><?php echo $total_programacion; ?></td>
                <td rowspan="2">$<?php echo $row['met_asignacion_presupuesto']; ?></td>
            </tr>
            <tr>
                <?php if (count($programacion) > 0) {
                    foreach ($programacion as $prm) { ?>
                        <td>$<?php echo number_format($prm['sgm_monto_ejecutado'],2); ?></td>
                    <?php }
                } else { ?>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                <?php } ?>
                <td>$<?php echo number_format($total_monto_prog, 2); ?></td>
            </tr>
        <?php } ?>
    </tbody>
</table>
