<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@"; /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8"/>
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br/>
                        Reporte de Formulación POA
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<table class="tabla <?php echo ($tipo_reporte == null) ? "responsive table table-bordered contenedor" : ""; ?>">
    <thead>
    <tr style="vertical-align: middle;font-weight: bold;">
        <th >Unidad</th>
        <th>Estratégicas</th>
        <th>Operativas</th>
        <th>Cantidad de Programadas</th>
        <th>Recursos Presupuestarios Asignados $</th>
    </tr>
    </thead>
    <tbody>


    <?php
    //Si la variable tipo reporte existe se declara la tabla
    $total_estrategicas = 0;
    $total_operativas = 0;
    $total_presupuesto = 0;
    $total_programadas = 0;
    foreach ($reporte as $row) {
        $total_estrategicas += $row['estrategica'];
        $total_operativas += $row['operativa'];
        $total_presupuesto += $row['asignacion_presupuesto'];
        $total_programadas += $row['programadas'];
        ?>
        <tr>
            <td><?php echo $row['are_nombre']; ?></td>
            <td><?php echo $row['estrategica']; ?></td>
            <td><?php echo $row['operativa']; ?></td>
            <td><?php echo $row['programadas']; ?></td>
            <td>$<?php echo $row['asignacion_presupuesto']; ?></td>
        </tr>
    <?php } ?>
    <tr>
        <td><b>Total</b></td>
        <td><b><?php echo number_format($total_estrategicas, 2); ?></b></td>
        <td><b><?php echo number_format($total_operativas, 2); ?></b></td>
        <td><b><?php echo number_format($total_programadas, 2); ?></b></td>
        <td><b>$<?php echo number_format($total_presupuesto, 2); ?></b></td>
    </tr>
    </tbody>
</table>
