<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }
        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }
        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }
        .tabla {
            border: 1px solid black;
        }
        .num {
            mso-number-format: General;
        }
        .text {
            mso-number-format: "\@"; /*force text*/
        }
        .dec{
            mso-number-format: '#,##0.00';
        }
        .coin{
            mso-number-format: currency;
        }
    </style>
    <?php 
}

if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8"/>
    <div class="head">
        <table>
            <tr>
                <td rowspan="2">
                    <img src="<?php echo base_url(); ?>media/imagenes/sistema/<?php echo $this->gsatelite->get_parametro('SYS_LOGOTIPO') ?>.png" width="108px" height="48">
                </td>
                <td align="center" colspan="5">
                    <h4>
                        <?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?>
                        <br/>
                        <span>Reporte de Formulación <?= $reporte[0]['poa_nombre'] ?></span>
                    </h4>
                </td>
            </tr>
            <tr>
                <td align="center" colspan="5">Dependencia: <?= $are_nombre ?></td>
            </tr>
        </table>
    </div>
<?php } ?>

<table <?= ($tipo_reporte == 'excel') ? "border='1'" : ""; ?> class="tabla <?php echo ($tipo_reporte == null) ? "responsive table table-bordered contenedor" : ""; ?>">
    <thead>
        <tr style="font-weight: bold;">
            <th style="vertical-align: middle; text-align: center;" rowspan="3">Objetivo Operativo</th>
            <th style="vertical-align: middle; text-align: center;" rowspan="3">Indicador Operativo</th>
            <th style="vertical-align: middle; text-align: center;" rowspan="3">Forma de Cálculo</th>
            <th style="vertical-align: middle; text-align: center;" rowspan="3">Frecuencia de Medición</th>
            <th style="vertical-align: middle; text-align: center;" rowspan="3">Meta</th>
            <th style="vertical-align: middle; text-align: center;" rowspan="3">Responsable(s)</th>
            <th style="vertical-align: middle; text-align: center;" rowspan="3">Actividad</th>
            <th style="vertical-align: middle; text-align: center;" rowspan="3">Planificación</th>
            <th colspan="24" style="text-align: center;">Programación y Seguimiento</th>
            <th colspan="2" style="vertical-align: middle; text-align: center;" rowspan="2">Total</th>
        </tr>
        <tr style="font-weight: bold;">
            <th style="text-align: center;" colspan="2">Ene</th>
            <th style="text-align: center;" colspan="2">Feb</th>
            <th style="text-align: center;" colspan="2">Mar</th>
            <th style="text-align: center;" colspan="2">Abr</th>
            <th style="text-align: center;" colspan="2">May</th>
            <th style="text-align: center;" colspan="2">Jun</th>
            <th style="text-align: center;" colspan="2">Jul</th>
            <th style="text-align: center;" colspan="2">Ago</th>
            <th style="text-align: center;" colspan="2">Sep</th>
            <th style="text-align: center;" colspan="2">Oct</th>
            <th style="text-align: center;" colspan="2">Nov</th>
            <th style="text-align: center;" colspan="2">Dic</th>
        </tr>
        <tr style="font-weight: bold;">
            <?php for ($i = 0; $i < 12; $i++) { ?>
                <th style="text-align: center;" >P</th>
                <th style="text-align: center;" >E</th>
            <?php } ?>
            <th>P</th>
            <th>E</th>
        </tr>
    </thead>
    <tbody>
        <?php
        if (count($reporte) > 0) {
            $obo_v = $ino_v = 0;
            $ver_obo = $ver_ino = true;
            $row_obo = array_count_values(array_column($reporte, 'obo_id'));
            $row_ino = array_count_values(array_column($reporte, 'ino_id'));
            $total_monto_programado = $total_monto_disponible = $total_monto_ejecutado = 0;
            foreach ($reporte as $row) {
                //Se obtiene la programación de la meta
                $this->db->order_by('per_codigo ASC');
                $programacion = $this->plan_operativo_model->get_programacion_meta(array('prm_id_met' => $row['met_id']));
                $total_programacion = $total_monto_prog = $total_ejecucion = $total_monto_ejec = 0;
                if (count($programacion) > 0) {
                    foreach ($programacion as $prog) {
                        $total_programacion += ($prog['rpd_programacion_nueva'] > 0) ? $prog['rpd_programacion_nueva'] : $prog['prm_programa'];
                        $total_monto_prog += $prog['prm_monto_asignado'];
                        $total_monto_ejec += $prog['sgm_monto_ejecutado'];
                        $total_ejecucion += $prog['sgm_ejecutado'];
                    }
                }
                $porc_color = number_format((($total_ejecucion / $row['met_unidad_program']) * 100), 2, '.','');
                $estado = $this->gsatelite->get_tabla('evp_evaluacion_meta_poa', array('evp_rango_inicio <= ' => $porc_color, 'evp_rango_fin >= ' => $porc_color));
                ?>
                <tr>
                    <?php if ($ver_obo) {
                        ?>
                        <td style="vertical-align: middle;" rowspan="<?= ($row_obo[$row['obo_id']] * 2) ?>"><?php echo $row['obo_codigo'] . ' - ' . $row['obo_nombre']; ?></td>
                        <?php 
                        $obo_v++;
                        if ($obo_v < $row_obo[$row['obo_id']]) {
                            $ver_obo = false;
                        }else{
                            $ver_obo = true;
                            $obo_v = 0;
                        }
                    } else { 
                        $obo_v++;
                        if ($obo_v < $row_obo[$row['obo_id']]) {
                            $ver_obo = false;
                        } else {
                            $ver_obo = true;
                            $obo_v = 0;
                        }
                    } ?>
                    <?php if ($ver_ino) {
                        $responsables = $this->plan_operativo_model->get_plz_responsables_ino(array('ino_id' => $row['ino_id']))[0];
                        ?>
                        <td style="vertical-align: middle;" rowspan="<?= ($row_ino[$row['ino_id']] * 2) ?>"><?php echo $row['ino_nombre']; ?></td>
                        <td style="vertical-align: middle;" rowspan="<?= ($row_ino[$row['ino_id']] * 2) ?>"><?php echo $row['ino_forma_calculo']; ?></td>
                        <td style="vertical-align: middle;" rowspan="<?= ($row_ino[$row['ino_id']] * 2) ?>"><?php echo $row['ino_frecuencia_medicion']; ?></td>
                        <td style="vertical-align: middle;" rowspan="<?= ($row_ino[$row['ino_id']] * 2) ?>"><?php echo $row['ino_meta']; ?></td>
                        <td style="vertical-align: middle;" rowspan="<?= ($row_ino[$row['ino_id']] * 2) ?>"><?php echo $responsables['responsables']; ?></td>
                        <?php 
                        $ino_v++;
                        if ($ino_v < $row_ino[$row['ino_id']]) {
                            $ver_ino = false;
                        }else{
                            $ver_ino = true;
                            $ino_v = 0;
                        }
                    } else { 
                        $ino_v++;
                        if ($ino_v < $row_ino[$row['ino_id']]) {
                            $ver_ino = false;
                        } else {
                            $ver_ino = true;
                            $ino_v = 0;
                        }
                    } ?>
                    <td rowspan="2"><?php echo $row['met_codigo'] . ' - ' . $row['met_nombre']; ?></td>
                    <td class="dec"><?php echo $row['met_unidad_program']; ?></td>
                    <?php if (count($programacion) > 0) {
                        foreach ($programacion as $prm) { ?>
                            <td class="dec"><?php echo ($prm['rpd_programacion_nueva'] > 0) ? $prm['rpd_programacion_nueva'] : $prm['prm_programa']; ?></td>
                            <td class="dec"><?php echo $prm['sgm_ejecutado']; ?></td>
                        <?php }
                    } else {
                        for ($i = 0; $i < 24 ; $i++) { ?>
                            <td></td>
                            <?php 
                        } 
                    } ?>
                    <td class="dec" style="background-color: <?php echo $estado[0]['evp_color'] ?>;"><?php echo $total_programacion; ?></td>
                    <td class="dec" style="background-color: <?php echo $estado[0]['evp_color'] ?>;"><?php echo $total_ejecucion; ?></td>
                </tr>
                <tr>
                    <td class="coin" >$<?php echo $row['met_asignacion_presupuesto']; ?></td>
                    <?php if (count($programacion) > 0) {
                        foreach ($programacion as $prm) { ?>
                            <td class="coin">$<?php echo ($prm['prm_monto_asignado'] > 0) ? number_format($prm['prm_monto_asignado'], 2) : number_format(0, 2); ?></td>
                            <td class="coin">$<?php echo ($prm['sgm_monto_ejecutado'] != "") ? number_format($prm['sgm_monto_ejecutado'], 2) : number_format(0, 2);  ?></td>
                        <?php }
                    } else {
                        for ($i = 0; $i < 24 ; $i++) { ?>
                            <td></td>
                            <?php 
                        } 
                    } ?>
                    <td class="coin" style="background-color: <?php echo $estado[0]['evp_color'] ?>;">$<?php echo number_format($total_monto_prog, 2); ?></td>
                    <td class="coin" style="background-color: <?php echo $estado[0]['evp_color'] ?>;">$<?php echo $total_monto_ejec ?></td>
                </tr>
                <?php
                $total_monto_programado += $total_monto_prog;
                $total_monto_ejecutado += $total_monto_ejec;
            }
            $total_monto_disponible += ($total_monto_programado - $total_monto_ejecutado);
        } else { ?>
            <tr><td colspan="34" style="text-align: center; font-weight: bold;">No se encontraron registros con los filtros aplicados</td></tr>
        <?php }
        ?>
    </tbody>
    <?php if (count($reporte) > 0) { ?>
        <tfoot>
            <tr><td colspan="34"></td></tr>
            <tr>
                <td colspan="8"></td>
                <td colspan="5" style="text-align: right;"><b>Total Presupuesto Programado</b></td>
                <td colspan="3" style="text-align: right;" class="coin">$<?php echo number_format($total_monto_programado, 2) ?></td>
                <td colspan="5" style="text-align: right;"><b>Total Presupuesto Ejecutado</b></td>
                <td colspan="3" style="text-align: right;" class="coin">$<?php echo number_format($total_monto_ejecutado, 2); ?></td>
                <td colspan="5" style="text-align: right;"><b>Presupuesto Disponible</b></td>
                <td colspan="3" style="text-align: right;" class="coin">$<?php echo number_format($total_monto_disponible, 2); ?></td>
                <td colspan="2"></td>
            </tr>
        </tfoot>
    <?php } ?>
</table>
